/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.chainsSearch;

import com.intellij.compiler.backwardRefs.CompilerReferenceServiceEx;
import com.intellij.compiler.chainsSearch.ChainOpAndOccurrences;
import com.intellij.compiler.chainsSearch.MethodCall;
import com.intellij.compiler.chainsSearch.OperationChain;
import com.intellij.compiler.chainsSearch.RefChainOperation;
import com.intellij.compiler.chainsSearch.SearchInitializer;
import com.intellij.compiler.chainsSearch.TypeCast;
import com.intellij.compiler.chainsSearch.context.ChainCompletionContext;
import com.intellij.compiler.chainsSearch.context.ChainSearchTarget;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.containers.IntStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.backwardRefs.CompilerRef;

public class ChainSearcher {
    @NotNull
    public static List<OperationChain> search(int pathMaximalLength, ChainSearchTarget searchTarget, int maxResultSize, ChainCompletionContext context, CompilerReferenceServiceEx compilerReferenceServiceEx) {
        SearchInitializer initializer = ChainSearcher.createInitializer(searchTarget, compilerReferenceServiceEx, context);
        return ChainSearcher.search(compilerReferenceServiceEx, initializer, pathMaximalLength, maxResultSize, context);
    }

    @NotNull
    private static SearchInitializer createInitializer(ChainSearchTarget target, CompilerReferenceServiceEx referenceServiceEx, ChainCompletionContext context) {
        ChainOpAndOccurrences<TypeCast> typeCast;
        TreeSet<ChainOpAndOccurrences<RefChainOperation>> operations = new TreeSet<ChainOpAndOccurrences<RefChainOperation>>();
        for (byte kind2 : target.getArrayKind()) {
            SortedSet<ChainOpAndOccurrences<MethodCall>> methods = referenceServiceEx.findMethodReferenceOccurrences(target.getClassQName(), kind2, context);
            operations.addAll(methods);
        }
        if (operations.isEmpty() && (typeCast = referenceServiceEx.getMostUsedTypeCast(target.getClassQName())) != null) {
            operations.add(typeCast);
        }
        return new SearchInitializer(operations, context);
    }

    @NotNull
    private static List<OperationChain> search(CompilerReferenceServiceEx referenceServiceEx, SearchInitializer initializer, int chainMaxLength, int maxResultSize, ChainCompletionContext context) {
        LinkedList<OperationChain> q = initializer.getChainQueue();
        ArrayList<OperationChain> result = new ArrayList<OperationChain>();
        while (!q.isEmpty()) {
            OperationChain continuation;
            CompilerRef.CompilerClassHierarchyElementDef def;
            ChainOpAndOccurrences candidate;
            OperationChain currentChain = q.poll();
            ProgressManager.checkCanceled();
            RefChainOperation head = currentChain.getHead();
            if (ChainSearcher.addChainIfTerminal(currentChain, result, chainMaxLength, context)) continue;
            boolean updated = false;
            SortedSet<ChainOpAndOccurrences<MethodCall>> candidates = referenceServiceEx.findMethodReferenceOccurrences(head.getQualifierRawName(), (byte)0, context);
            CompilerRef ref = head.getCompilerRef();
            Iterator iterator = candidates.iterator();
            while (iterator.hasNext() && (candidate = (ChainOpAndOccurrences)iterator.next()).getOccurrenceCount() * 10 >= currentChain.getChainWeight()) {
                boolean stopChain;
                OperationChain continuation2;
                MethodCall sign = (MethodCall)candidate.getOperation();
                if (!sign.isStatic() && sign.getQualifierRawName().equals(context.getTarget().getClassQName()) || ref instanceof CompilerRef.JavaCompilerMethodRef && !referenceServiceEx.mayHappen((CompilerRef)((MethodCall)candidate.getOperation()).getCompilerRef(), ref, 5) || (continuation2 = currentChain.continuationWithMethod((MethodCall)candidate.getOperation(), candidate.getOccurrenceCount(), context)) == null) continue;
                boolean bl = stopChain = ((MethodCall)candidate.getOperation()).isStatic() || context.hasQualifier(context.resolvePsiClass(((MethodCall)candidate.getOperation()).getQualifierDef()));
                if (stopChain) {
                    ChainSearcher.addChainIfNotPresent(continuation2, result);
                } else {
                    q.addFirst(continuation2);
                }
                updated = true;
            }
            if (ref instanceof CompilerRef.JavaCompilerMethodRef && (def = referenceServiceEx.mayCallOfTypeCast((CompilerRef.JavaCompilerMethodRef)ref, 5)) != null && (continuation = currentChain.continuationWithCast(new TypeCast(def, head.getQualifierDef(), referenceServiceEx), context)) != null) {
                q.addFirst(continuation);
                updated = true;
            }
            if (!updated) {
                ChainSearcher.addChainIfQualifierCanBeOccurredInContext(currentChain, result, context, referenceServiceEx);
            }
            if (result.size() <= maxResultSize) continue;
            return result;
        }
        return result;
    }

    private static void addChainIfQualifierCanBeOccurredInContext(OperationChain currentChain, List<OperationChain> result, ChainCompletionContext context, CompilerReferenceServiceEx referenceServiceEx) {
        RefChainOperation signature = currentChain.getHead();
        if (currentChain.hasCast()) {
            return;
        }
        if (!context.getTarget().getClassQName().equals(signature.getQualifierRawName())) {
            Set<CompilerRef> references = context.getContextClassReferences();
            boolean isRelevantQualifier = false;
            for (CompilerRef ref : references) {
                if (!referenceServiceEx.mayHappen((CompilerRef)signature.getQualifierDef(), ref, 1)) continue;
                isRelevantQualifier = true;
                break;
            }
            if (references.isEmpty() || isRelevantQualifier) {
                ChainSearcher.addChainIfNotPresent(currentChain, result);
            }
        }
    }

    private static boolean addChainIfTerminal(OperationChain currentChain, List<OperationChain> result, int pathMaximalLength, ChainCompletionContext context) {
        MethodCall signature = currentChain.getHeadMethodCall();
        if (signature == null) {
            return false;
        }
        RefChainOperation head = currentChain.getHead();
        if (signature.isStatic() || context.hasQualifier(context.resolvePsiClass(head.getQualifierDef()))) {
            ChainSearcher.addChainIfNotPresent(currentChain, result);
            return true;
        }
        if (currentChain.length() >= pathMaximalLength) {
            ChainSearcher.addChainIfNotPresent(currentChain.getHead() == signature ? currentChain : currentChain.removeHeadCast(context), result);
            return true;
        }
        return false;
    }

    private static void addChainIfNotPresent(OperationChain newChain, List<OperationChain> result) {
        if (result.isEmpty()) {
            result.add(newChain);
            return;
        }
        boolean doAdd = true;
        IntStack indicesToRemove = new IntStack();
        block4: for (int i = 0; i < result.size(); ++i) {
            OperationChain chain = result.get(i);
            OperationChain.CompareResult r = OperationChain.compare(chain, newChain);
            switch (r) {
                case LEFT_CONTAINS_RIGHT: {
                    indicesToRemove.push(i);
                    continue block4;
                }
                case RIGHT_CONTAINS_LEFT: 
                case EQUAL: {
                    doAdd = false;
                    continue block4;
                }
            }
        }
        while (!indicesToRemove.empty()) {
            result.remove(indicesToRemove.pop());
        }
        if (doAdd) {
            result.add(newChain);
        }
    }
}

