/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs.view;

import com.intellij.compiler.backwardRefs.view.DirtyScopeTestInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompilerReferenceFindUsagesTestInfo {
    @Nullable
    private final IntSet myFileIds;
    @NotNull
    private final DirtyScopeTestInfo myDirtyScopeInfo;

    public CompilerReferenceFindUsagesTestInfo(@Nullable IntSet occurrencesIds, @NotNull DirtyScopeTestInfo dirtyScopeTestInfo) {
        this.myFileIds = occurrencesIds;
        this.myDirtyScopeInfo = dirtyScopeTestInfo;
    }

    @NotNull
    private List<VirtualFile> getFilesWithKnownOccurrences() {
        if (this.myFileIds == null) {
            throw new IllegalStateException();
        }
        ManagingFS managingFs = ManagingFS.getInstance();
        ArrayList<VirtualFile> list = new ArrayList<VirtualFile>();
        IntIterator iterator = this.myFileIds.iterator();
        while (iterator.hasNext()) {
            VirtualFile f = managingFs.findFileById(iterator.nextInt());
            if (f == null || this.myDirtyScopeInfo.getDirtyScope().contains(f)) continue;
            list.add(f);
        }
        return list;
    }

    private Module @NotNull [] getDirtyModules() {
        return this.myDirtyScopeInfo.getDirtyModules();
    }

    private Module @NotNull [] getDirtyUnsavedModules() {
        return this.myDirtyScopeInfo.getDirtyUnsavedModules();
    }

    private VirtualFile @NotNull [] getExcludedFiles() {
        return this.myDirtyScopeInfo.getExcludedFiles();
    }

    private boolean isEnabled() {
        return this.myFileIds != null;
    }

    DefaultMutableTreeNode asTree() {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode();
        if (this.isEnabled()) {
            DefaultMutableTreeNode knownOccurrences = new DefaultMutableTreeNode("Known occurrence files");
            node.add(knownOccurrences);
            for (VirtualFile virtualFile : this.getFilesWithKnownOccurrences()) {
                knownOccurrences.add(new DefaultMutableTreeNode(virtualFile));
            }
            DefaultMutableTreeNode dirtyModules = new DefaultMutableTreeNode("Dirty modules");
            node.add(dirtyModules);
            for (Module module : this.getDirtyModules()) {
                dirtyModules.add(new DefaultMutableTreeNode(module));
            }
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Unsaved dirty modules");
            node.add(defaultMutableTreeNode);
            for (Module module : this.getDirtyUnsavedModules()) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(module));
            }
            DefaultMutableTreeNode excludedFiles = new DefaultMutableTreeNode("Current excluded files");
            node.add(excludedFiles);
            for (VirtualFile excludedFile : this.getExcludedFiles()) {
                excludedFiles.add(new DefaultMutableTreeNode(excludedFile));
            }
        } else {
            node.add(new DefaultMutableTreeNode("Service is not available"));
        }
        return node;
    }
}

