/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.ProjectTopics;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerReferenceService;
import com.intellij.compiler.backwardRefs.CompilerReferenceServiceBase;
import com.intellij.compiler.backwardRefs.ExcludedFromCompileFilesUtil;
import com.intellij.compiler.backwardRefs.view.DirtyScopeTestInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.compiler.options.ExcludedEntriesListener;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirtyScopeHolder
extends UserDataHolderBase
implements AsyncFileListener {
    private final CompilerReferenceServiceBase<?> myService;
    private final FileDocumentManager myFileDocManager;
    private final PsiDocumentManager myPsiDocManager;
    private final Object myLock = new Object();
    private final Set<Module> myVFSChangedModules = new HashSet<Module>();
    private final Set<Module> myChangedModulesDuringCompilation = new HashSet<Module>();
    private final List<ExcludeEntryDescription> myExcludedDescriptions = new SmartList();
    private boolean myCompilationPhase;
    private volatile GlobalSearchScope myExcludedFilesScope;
    private final Set<String> myCompilationAffectedModules = ContainerUtil.newConcurrentSet();
    private final FileTypeRegistry myFileTypeRegistry = FileTypeRegistry.getInstance();

    DirtyScopeHolder(@NotNull CompilerReferenceServiceBase<?> service, @NotNull FileDocumentManager fileDocumentManager, @NotNull PsiDocumentManager psiDocumentManager, @NotNull BiConsumer<? super MessageBusConnection, ? super Set<String>> compilationAffectedModulesSubscription) {
        this.myService = service;
        this.myFileDocManager = fileDocumentManager;
        this.myPsiDocManager = psiDocumentManager;
        if (CompilerReferenceService.isEnabled()) {
            MessageBusConnection connect = service.getProject().getMessageBus().connect();
            connect.subscribe(ExcludedEntriesListener.TOPIC, (Object)new ExcludedEntriesListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onEntryAdded(@NotNull ExcludeEntryDescription description) {
                    Object object = DirtyScopeHolder.this.myLock;
                    synchronized (object) {
                        if (DirtyScopeHolder.this.myCompilationPhase) {
                            DirtyScopeHolder.this.myExcludedDescriptions.add(description);
                        }
                    }
                }
            });
            compilationAffectedModulesSubscription.accept((MessageBusConnection)connect, this.myCompilationAffectedModules);
            connect.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void beforeRootsChange(@NotNull ModuleRootEvent event) {
                    Object[] modules = ModuleManager.getInstance((Project)DirtyScopeHolder.this.myService.getProject()).getModules();
                    Object object = DirtyScopeHolder.this.myLock;
                    synchronized (object) {
                        ContainerUtil.addAll((Collection)DirtyScopeHolder.this.myVFSChangedModules, (Object[])modules);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compilerActivityStarted() {
        ExcludeEntryDescription[] excludeEntryDescriptions = CompilerConfiguration.getInstance((Project)this.myService.getProject()).getExcludedEntriesConfiguration().getExcludeEntryDescriptions();
        Object object = this.myLock;
        synchronized (object) {
            this.myCompilationPhase = true;
            Collections.addAll(this.myExcludedDescriptions, excludeEntryDescriptions);
            this.myExcludedFilesScope = null;
            this.myCompilationAffectedModules.clear();
        }
    }

    public void upToDateChecked(boolean isUpToDate) {
        Module[] modules = (Module[])ReadAction.compute(() -> {
            Project project = this.myService.getProject();
            if (project.isDisposed()) {
                return null;
            }
            return ModuleManager.getInstance((Project)project).getModules();
        });
        if (modules == null) {
            return;
        }
        this.compilationFinished(() -> {
            if (!isUpToDate) {
                ContainerUtil.addAll(this.myVFSChangedModules, (Object[])modules);
            }
        });
    }

    void compilerActivityFinished() {
        List compiledModules = (List)ReadAction.compute(() -> {
            Project project = this.myService.getProject();
            if (project.isDisposed()) {
                return null;
            }
            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myService.getProject());
            return ContainerUtil.map(this.myCompilationAffectedModules, arg_0 -> ((ModuleManager)moduleManager).findModuleByName(arg_0));
        });
        this.compilationFinished(() -> {
            if (compiledModules == null) {
                return;
            }
            this.myVFSChangedModules.removeAll(compiledModules);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compilationFinished(@NotNull Runnable action) {
        ExcludeEntryDescription[] descriptions;
        Object object = this.myLock;
        synchronized (object) {
            this.myCompilationPhase = false;
            action.run();
            this.myVFSChangedModules.addAll(this.myChangedModulesDuringCompilation);
            this.myChangedModulesDuringCompilation.clear();
            descriptions = this.myExcludedDescriptions.toArray(new ExcludeEntryDescription[0]);
            this.myExcludedDescriptions.clear();
        }
        this.myCompilationAffectedModules.clear();
        this.myExcludedFilesScope = ExcludedFromCompileFilesUtil.getExcludedFilesScope(descriptions, this.myService.getFileTypes(), this.myService.getProject(), this.myService.getFileIndex());
    }

    @NotNull
    public GlobalSearchScope getDirtyScope() {
        Project project = this.myService.getProject();
        return (GlobalSearchScope)ReadAction.compute(() -> {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myCompilationPhase) {
                    return GlobalSearchScope.allScope((Project)project);
                }
                if (project.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                return (GlobalSearchScope)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)this, () -> CachedValueProvider.Result.create((Object)this.calculateDirtyScope(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, VirtualFileManager.getInstance(), this.myService}));
            }
        });
    }

    @NotNull
    private GlobalSearchScope calculateDirtyScope() {
        Set<Module> dirtyModules = this.getAllDirtyModules();
        if (dirtyModules.isEmpty()) {
            return this.myExcludedFilesScope;
        }
        GlobalSearchScope dirtyModuleScope = GlobalSearchScope.union((GlobalSearchScope[])((GlobalSearchScope[])dirtyModules.stream().map(Module::getModuleWithDependentsScope).toArray(GlobalSearchScope[]::new)));
        return dirtyModuleScope.union((SearchScope)this.myExcludedFilesScope);
    }

    @NotNull
    public Set<Module> getAllDirtyModules() {
        THashSet dirtyModules = new THashSet(this.myVFSChangedModules);
        for (Document document : this.myFileDocManager.getUnsavedDocuments()) {
            Module m;
            VirtualFile file = this.myFileDocManager.getFile(document);
            if (file == null || (m = this.getModuleForSourceContentFile(file)) == null) continue;
            dirtyModules.add(m);
        }
        for (Document document : this.myPsiDocManager.getUncommittedDocuments()) {
            Module m;
            VirtualFile file;
            PsiFile psiFile = this.myPsiDocManager.getPsiFile(document);
            if (psiFile == null || (file = psiFile.getVirtualFile()) == null || (m = this.getModuleForSourceContentFile(file)) == null) continue;
            dirtyModules.add(m);
        }
        return dirtyModules;
    }

    public boolean contains(@NotNull VirtualFile file) {
        return this.getDirtyScope().contains(file);
    }

    @Nullable
    public AsyncFileListener.ChangeApplier prepareChange(final @NotNull List<? extends VFileEvent> events) {
        final List<Module> modulesToBeMarkedDirty = this.getModulesToBeMarkedDirtyBefore(events);
        return new AsyncFileListener.ChangeApplier(){

            public void beforeVfsChange() {
                modulesToBeMarkedDirty.forEach(x$0 -> DirtyScopeHolder.this.addToDirtyModules(x$0));
            }

            public void afterVfsChange() {
                if (!DirtyScopeHolder.this.myService.getProject().isDisposed()) {
                    DirtyScopeHolder.this.after(events);
                }
            }
        };
    }

    private void after(@NotNull List<? extends VFileEvent> events) {
        for (VFileEvent vFileEvent : events) {
            VFilePropertyChangeEvent pce;
            String propertyName;
            if (vFileEvent instanceof VFileCreateEvent) {
                String fileName;
                VirtualFile parent = ((VFileCreateEvent)vFileEvent).getParent();
                Module module = this.getModuleForSourceContentFile(parent, fileName = ((VFileCreateEvent)vFileEvent).getChildName());
                if (module == null) continue;
                this.addToDirtyModules(module);
                continue;
            }
            if (vFileEvent instanceof VFileCopyEvent || vFileEvent instanceof VFileMoveEvent) {
                VirtualFile file = vFileEvent.getFile();
                if (file == null) continue;
                this.fileChanged(file);
                continue;
            }
            if (!(vFileEvent instanceof VFilePropertyChangeEvent) || !"name".equals(propertyName = (pce = (VFilePropertyChangeEvent)vFileEvent).getPropertyName()) && !"symlink".equals(propertyName)) continue;
            this.fileChanged(pce.getFile());
        }
    }

    @Contract(pure=true)
    @NotNull
    private List<Module> getModulesToBeMarkedDirtyBefore(@NotNull List<? extends VFileEvent> events) {
        ArrayList<Module> modulesToBeMarkedDirty = new ArrayList<Module>();
        for (VFileEvent vFileEvent : events) {
            VFilePropertyChangeEvent pce;
            String propertyName;
            ProgressManager.checkCanceled();
            if (vFileEvent instanceof VFileDeleteEvent || vFileEvent instanceof VFileMoveEvent || vFileEvent instanceof VFileContentChangeEvent) {
                VirtualFile file = vFileEvent.getFile();
                if (file == null) continue;
                Module module = this.getModuleForSourceContentFile(file);
                ContainerUtil.addIfNotNull(modulesToBeMarkedDirty, (Object)module);
                continue;
            }
            if (!(vFileEvent instanceof VFilePropertyChangeEvent) || !"name".equals(propertyName = (pce = (VFilePropertyChangeEvent)vFileEvent).getPropertyName()) && !"symlink".equals(propertyName)) continue;
            String path = pce.getFile().getPath();
            for (Module module : ModuleManager.getInstance((Project)this.myService.getProject()).getModules()) {
                if (!FileUtil.isAncestor((String)path, (String)module.getModuleFilePath(), (boolean)true)) continue;
                modulesToBeMarkedDirty.add(module);
            }
        }
        return modulesToBeMarkedDirty;
    }

    public void installVFSListener(@NotNull Disposable parentDisposable) {
        VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)this, parentDisposable);
    }

    private void fileChanged(@NotNull VirtualFile file) {
        Module module = this.getModuleForSourceContentFile(file);
        if (module != null) {
            this.addToDirtyModules(module);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToDirtyModules(@NotNull Module module) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myCompilationPhase) {
                this.myChangedModulesDuringCompilation.add(module);
            } else {
                this.myVFSChangedModules.add(module);
            }
        }
    }

    private Module getModuleForSourceContentFile(@NotNull VirtualFile file) {
        return this.getModuleForSourceContentFile(file, file.getNameSequence());
    }

    private Module getModuleForSourceContentFile(@NotNull VirtualFile parent, @NotNull CharSequence fileName) {
        FileType fileType = this.myFileTypeRegistry.getFileTypeByFileName(fileName);
        if (this.myService.getFileTypes().contains(fileType) && this.myService.getFileIndex().isInSourceContent(parent)) {
            return this.myService.getFileIndex().getModuleForFile(parent);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    Set<Module> getAllDirtyModulesForTest() {
        Object object = this.myLock;
        synchronized (object) {
            return this.getAllDirtyModules();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    DirtyScopeTestInfo getState() {
        Object object = this.myLock;
        synchronized (object) {
            Object[] vfsChangedModules = this.myVFSChangedModules.toArray(Module.EMPTY_ARRAY);
            ArrayList<Module> unsavedChangedModuleList = new ArrayList<Module>(this.getAllDirtyModules());
            ContainerUtil.removeAll(unsavedChangedModuleList, (Object[])vfsChangedModules);
            Module[] unsavedChangedModules = unsavedChangedModuleList.toArray(Module.EMPTY_ARRAY);
            ArrayList excludedFiles = this.myExcludedFilesScope instanceof Iterable ? ContainerUtil.newArrayList((Iterable)((Iterable)this.myExcludedFilesScope)) : Collections.emptyList();
            return new DirtyScopeTestInfo((Module[])vfsChangedModules, unsavedChangedModules, excludedFiles.toArray(VirtualFile.EMPTY_ARRAY), this.getDirtyScope());
        }
    }
}

