/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.actions;

import com.intellij.compiler.actions.ArtifactAwareProjectSettingsService;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.IdeLanguageCustomization;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MultiSelectionListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.compiler.ArtifactsWorkspaceSettings;
import com.intellij.task.ProjectTaskManager;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import gnu.trove.TIntArrayList;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildArtifactAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        boolean enabled;
        Project project = BuildArtifactAction.getEventProject((AnActionEvent)e);
        Presentation presentation = e.getPresentation();
        boolean bl = enabled = project != null && !ArtifactUtil.getArtifactWithOutputPaths(project).isEmpty();
        if (IdeLanguageCustomization.getInstance().getPrimaryIdeLanguages().contains(JavaFileType.INSTANCE.getLanguage()) && "MainMenu".equals(e.getPlace())) {
            presentation.setEnabled(enabled);
        } else {
            presentation.setEnabledAndVisible(enabled);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = BuildArtifactAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            return;
        }
        List<Artifact> artifacts = ArtifactUtil.getArtifactWithOutputPaths(project);
        if (artifacts.isEmpty()) {
            return;
        }
        ArrayList<ArtifactPopupItem> items = new ArrayList<ArtifactPopupItem>();
        if (artifacts.size() > 1) {
            items.add(0, new ArtifactPopupItem(null, "All Artifacts", EmptyIcon.ICON_16));
        }
        HashSet<Artifact> selectedArtifacts = new HashSet<Artifact>(ArtifactsWorkspaceSettings.getInstance(project).getArtifactsToBuild());
        TIntArrayList selectedIndices = new TIntArrayList();
        if (Comparing.haveEqualElements(artifacts, selectedArtifacts) && selectedArtifacts.size() > 1) {
            selectedIndices.add(0);
            selectedArtifacts.clear();
        }
        for (Artifact artifact : artifacts) {
            ArtifactPopupItem item = new ArtifactPopupItem(artifact, artifact.getName(), artifact.getArtifactType().getIcon());
            if (selectedArtifacts.contains(artifact)) {
                selectedIndices.add(items.size());
            }
            items.add(item);
        }
        ProjectSettingsService projectSettingsService = ProjectSettingsService.getInstance((Project)project);
        final ArtifactAwareProjectSettingsService settingsService = projectSettingsService instanceof ArtifactAwareProjectSettingsService ? (ArtifactAwareProjectSettingsService)projectSettingsService : null;
        ChooseArtifactStep step2 = new ChooseArtifactStep(items, artifacts.get(0), project, settingsService);
        step2.setDefaultOptionIndices(selectedIndices.toNativeArray());
        final ListPopupImpl popup = (ListPopupImpl)JBPopupFactory.getInstance().createListPopup((ListPopupStep)step2);
        KeyStroke editKeyStroke = KeymapUtil.getKeyStroke((ShortcutSet)CommonShortcuts.getEditSource());
        if (settingsService != null && editKeyStroke != null) {
            popup.registerAction("editArtifact", editKeyStroke, (Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object[] values = popup.getSelectedValues();
                    popup.cancel();
                    settingsService.openArtifactSettings(values.length > 0 ? ((ArtifactPopupItem)values[0]).getArtifact() : null);
                }
            });
        }
        popup.showCenteredInCurrentWindow(project);
    }

    private static void doBuild(@NotNull Project project, @NotNull List<? extends ArtifactPopupItem> items, boolean rebuild) {
        Artifact[] artifacts = BuildArtifactAction.getArtifacts(items, project);
        if (rebuild) {
            ProjectTaskManager.getInstance((Project)project).rebuild((ProjectModelBuildableElement[])artifacts);
        } else {
            ProjectTaskManager.getInstance((Project)project).build((ProjectModelBuildableElement[])artifacts);
        }
    }

    private static Artifact[] getArtifacts(List<? extends ArtifactPopupItem> items, Project project) {
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        for (ArtifactPopupItem artifactPopupItem : items) {
            artifacts.addAll(artifactPopupItem.getArtifacts(project));
        }
        return artifacts.toArray(new Artifact[0]);
    }

    private static class ChooseArtifactStep
    extends MultiSelectionListPopupStep<ArtifactPopupItem> {
        private final Artifact myFirst;
        private final Project myProject;
        private final ArtifactAwareProjectSettingsService mySettingsService;

        ChooseArtifactStep(List<ArtifactPopupItem> artifacts, Artifact first, Project project, ArtifactAwareProjectSettingsService settingsService) {
            super("Build Artifact", artifacts);
            this.myFirst = first;
            this.myProject = project;
            this.mySettingsService = settingsService;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public Icon getIconFor(ArtifactPopupItem aValue) {
            return aValue.getIcon();
        }

        @NotNull
        public String getTextFor(ArtifactPopupItem value2) {
            return value2.getText();
        }

        public boolean hasSubstep(List<? extends ArtifactPopupItem> selectedValues) {
            return true;
        }

        public ListSeparator getSeparatorAbove(ArtifactPopupItem value2) {
            return this.myFirst.equals(value2.getArtifact()) ? new ListSeparator() : null;
        }

        public PopupStep<?> onChosen(List<ArtifactPopupItem> selectedValues, boolean finalChoice) {
            if (finalChoice) {
                return this.doFinalStep(() -> BuildArtifactAction.doBuild(this.myProject, selectedValues, false));
            }
            ArrayList<ArtifactActionItem> actions = new ArrayList<ArtifactActionItem>();
            actions.add(new BuildArtifactItem((List)selectedValues, this.myProject));
            actions.add(new RebuildArtifactItem((List)selectedValues, this.myProject));
            actions.add(new CleanArtifactItem((List)selectedValues, this.myProject));
            if (this.mySettingsService != null) {
                actions.add(new EditArtifactItem(selectedValues, this.myProject, this.mySettingsService));
            }
            return new BaseListPopupStep<ArtifactActionItem>(selectedValues.size() == 1 ? "Action" : "Action for " + selectedValues.size() + " artifacts", actions){

                @NotNull
                public String getTextFor(ArtifactActionItem value2) {
                    return value2.getActionName();
                }

                public PopupStep onChosen(ArtifactActionItem selectedValue, boolean finalChoice) {
                    return this.doFinalStep(selectedValue);
                }
            };
        }
    }

    private static class ArtifactPopupItem {
        @Nullable
        private final Artifact myArtifact;
        private final String myText;
        private final Icon myIcon;

        private ArtifactPopupItem(@Nullable Artifact artifact, String text2, Icon icon) {
            this.myArtifact = artifact;
            this.myText = text2;
            this.myIcon = icon;
        }

        @Nullable
        public Artifact getArtifact() {
            return this.myArtifact;
        }

        public String getText() {
            return this.myText;
        }

        public Icon getIcon() {
            return this.myIcon;
        }

        public List<Artifact> getArtifacts(Project project) {
            Artifact artifact = this.getArtifact();
            return artifact != null ? Collections.singletonList(artifact) : ArtifactUtil.getArtifactWithOutputPaths(project);
        }
    }

    private static abstract class ArtifactActionItem
    implements Runnable {
        protected final List<ArtifactPopupItem> myArtifactPopupItems;
        protected final Project myProject;
        private final String myActionName;

        protected ArtifactActionItem(@NotNull List<ArtifactPopupItem> item, @NotNull Project project, @NotNull String name2) {
            this.myArtifactPopupItems = item;
            this.myProject = project;
            this.myActionName = name2;
        }

        public String getActionName() {
            return this.myActionName;
        }
    }

    private static class EditArtifactItem
    extends ArtifactActionItem {
        private final ArtifactAwareProjectSettingsService mySettingsService;

        private EditArtifactItem(List<ArtifactPopupItem> item, Project project, ArtifactAwareProjectSettingsService projectSettingsService) {
            super(item, project, "Edit...");
            this.mySettingsService = projectSettingsService;
        }

        @Override
        public void run() {
            this.mySettingsService.openArtifactSettings(((ArtifactPopupItem)this.myArtifactPopupItems.get(0)).getArtifact());
        }
    }

    private static class RebuildArtifactItem
    extends ArtifactActionItem {
        private RebuildArtifactItem(List<ArtifactPopupItem> item, Project project) {
            super(item, project, "Rebuild");
        }

        @Override
        public void run() {
            BuildArtifactAction.doBuild(this.myProject, this.myArtifactPopupItems, true);
        }
    }

    private static class CleanArtifactItem
    extends ArtifactActionItem {
        private CleanArtifactItem(@NotNull List<ArtifactPopupItem> item, @NotNull Project project) {
            super(item, project, "Clean");
        }

        @Override
        public void run() {
            VirtualFile artifacts;
            VirtualFile[] roots;
            HashSet<VirtualFile> parents = new HashSet<VirtualFile>();
            VirtualFile[] virtualFileArray = roots = ProjectRootManager.getInstance((Project)this.myProject).getContentSourceRoots();
            int n = virtualFileArray.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile root;
                for (VirtualFile parent = root = virtualFileArray[i]; parent != null && !parents.contains(parent); parent = parent.getParent()) {
                    parents.add(parent);
                }
            }
            HashMap<String, String> outputPathContainingSourceRoots = new HashMap<String, String>();
            final ArrayList<Pair> toClean = new ArrayList<Pair>();
            for (VirtualFile artifact : artifacts = BuildArtifactAction.getArtifacts(this.myArtifactPopupItems, this.myProject)) {
                String outputPath = artifact.getOutputFilePath();
                if (outputPath == null) continue;
                toClean.add(Pair.create((Object)new File(FileUtil.toSystemDependentName((String)outputPath)), (Object)artifact));
                VirtualFile outputFile = LocalFileSystem.getInstance().findFileByPath(outputPath);
                if (!parents.contains(outputFile)) continue;
                outputPathContainingSourceRoots.put(artifact.getName(), outputPath);
            }
            if (!outputPathContainingSourceRoots.isEmpty()) {
                String message2;
                if (outputPathContainingSourceRoots.size() == 1 && outputPathContainingSourceRoots.values().size() == 1) {
                    String name2 = (String)ContainerUtil.getFirstItem(outputPathContainingSourceRoots.keySet());
                    String output = (String)outputPathContainingSourceRoots.get(name2);
                    message2 = "The output directory '" + output + "' of '" + name2 + "' artifact contains source roots of the project. Do you want to continue and clear it?";
                } else {
                    StringBuilder info = new StringBuilder();
                    for (String name3 : outputPathContainingSourceRoots.keySet()) {
                        info.append(" '").append(name3).append("' artifact ('").append((String)outputPathContainingSourceRoots.get(name3)).append("')\n");
                    }
                    message2 = "The output directories of the following artifacts contains source roots:\n" + info + "Do you want to continue and clear these directories?";
                }
                int answer = Messages.showYesNoDialog((Project)this.myProject, (String)message2, (String)JavaCompilerBundle.message((String)"clean.artifacts", (Object[])new Object[0]), null);
                if (answer != 0) {
                    return;
                }
            }
            new Task.Backgroundable(this.myProject, JavaCompilerBundle.message((String)"cleaning.artifacts", (Object[])new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    ArrayList<File> deleted = new ArrayList<File>();
                    for (Pair pair2 : toClean) {
                        indicator.checkCanceled();
                        File file = (File)pair2.getFirst();
                        if (!FileUtil.delete((File)file)) {
                            Holder.NOTIFICATION_GROUP.createNotification(JavaCompilerBundle.message((String)"cannot.clean.0.artifact", (Object[])new Object[]{((Artifact)pair2.getSecond()).getName()}), JavaCompilerBundle.message((String)"cannot.delete.0", (Object[])new Object[]{file.getAbsolutePath()}), NotificationType.ERROR, null).notify(this.myProject);
                            continue;
                        }
                        deleted.add(file);
                    }
                    LocalFileSystem.getInstance().refreshIoFiles(deleted, true, true, null);
                }
            }.queue();
        }
    }

    private static class BuildArtifactItem
    extends ArtifactActionItem {
        private BuildArtifactItem(List<ArtifactPopupItem> item, Project project) {
            super(item, project, "Build");
        }

        @Override
        public void run() {
            BuildArtifactAction.doBuild(this.myProject, this.myArtifactPopupItems, false);
        }
    }

    private static class Holder {
        private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)"Clean artifact");

        private Holder() {
        }
    }
}

