/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.TripleFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompilerMessageImpl
implements CompilerMessage {
    private final Project myProject;
    private final CompilerMessageCategory myCategory;
    @Nullable
    private Navigatable myNavigatable;
    private final String myMessage;
    private final VirtualFile myFile;
    private final int myRow;
    private final int myColumn;
    @NotNull
    private TripleFunction<? super CompilerMessage, ? super Integer, ? super Integer, Integer> myColumnAdjuster = (msg, line, col) -> col;

    public CompilerMessageImpl(Project project, CompilerMessageCategory category, String message2) {
        this(project, category, message2, null, -1, -1, null);
    }

    public CompilerMessageImpl(Project project, @NotNull CompilerMessageCategory category, String message2, @Nullable VirtualFile file, int row, int column, @Nullable Navigatable navigatable) {
        this.myProject = project;
        this.myCategory = category;
        this.myNavigatable = navigatable;
        this.myMessage = message2 == null ? "" : message2;
        this.myRow = row;
        this.myColumn = column;
        this.myFile = file;
    }

    public void setColumnAdjuster(@NotNull TripleFunction<? super CompilerMessage, ? super Integer, ? super Integer, Integer> columnAdjuster) {
        this.myColumnAdjuster = columnAdjuster;
    }

    @NotNull
    public CompilerMessageCategory getCategory() {
        return this.myCategory;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public Navigatable getNavigatable() {
        int line;
        if (this.myNavigatable != null) {
            return this.myNavigatable;
        }
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile != null && virtualFile.isValid() && !virtualFile.getFileType().isBinary() && (line = this.getLine() - 1) >= 0) {
            this.myNavigatable = new OpenFileDescriptor(this.myProject, virtualFile, line, ((Integer)this.myColumnAdjuster.fun((Object)this, (Object)line, (Object)Math.max(0, this.getColumn() - 1))).intValue());
            return this.myNavigatable;
        }
        return null;
    }

    public VirtualFile getVirtualFile() {
        return this.myFile;
    }

    public String getExportTextPrefix() {
        if (this.getLine() >= 0) {
            return JavaCompilerBundle.message((String)"compiler.results.export.text.prefix", (Object[])new Object[]{this.getLine()});
        }
        return "";
    }

    public String getRenderTextPrefix() {
        if (this.getLine() >= 0) {
            return "(" + this.getLine() + ", " + this.getColumn() + ")";
        }
        return "";
    }

    public int getLine() {
        return this.myRow;
    }

    public int getColumn() {
        return this.myColumn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompilerMessage)) {
            return false;
        }
        CompilerMessageImpl compilerMessage = (CompilerMessageImpl)o;
        if (this.myColumn != compilerMessage.myColumn) {
            return false;
        }
        if (this.myRow != compilerMessage.myRow) {
            return false;
        }
        if (!this.myCategory.equals((Object)compilerMessage.myCategory)) {
            return false;
        }
        if (this.myFile != null ? !this.myFile.equals(compilerMessage.myFile) : compilerMessage.myFile != null) {
            return false;
        }
        return this.myMessage.equals(compilerMessage.myMessage);
    }

    public int hashCode() {
        int result = this.myCategory.hashCode();
        result = 29 * result + this.myMessage.hashCode();
        result = 29 * result + (this.myFile != null ? this.myFile.hashCode() : 0);
        result = 29 * result + this.myRow;
        result = 29 * result + this.myColumn;
        return result;
    }

    public String toString() {
        return this.myMessage;
    }
}

