/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamToLoop;

import com.intellij.codeInspection.streamToLoop.ChainContext;
import com.intellij.codeInspection.streamToLoop.ConditionalExpression;
import com.intellij.codeInspection.streamToLoop.FunctionHelper;
import com.intellij.codeInspection.streamToLoop.Operation;
import com.intellij.codeInspection.streamToLoop.StreamToLoopInspection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StreamToLoopReplacementContext
extends ChainContext {
    private final boolean myHasNestedLoops;
    private final Set<String> myUsedLabels;
    private final CommentTracker myCommentTracker;
    private final String mySuffix;
    private String myFinisher;
    private String myLabel;
    private static final Logger LOG = Logger.getInstance(StreamToLoopReplacementContext.class);

    StreamToLoopReplacementContext(PsiStatement statement, List<StreamToLoopInspection.OperationRecord> records, @NotNull PsiExpression streamExpression, CommentTracker ct) {
        super((PsiElement)streamExpression);
        this.myHasNestedLoops = records.stream().anyMatch(or -> or.myOperation instanceof Operation.FlatMapOperation);
        this.mySuffix = this.myHasNestedLoops ? "Outer" : "";
        this.myUsedLabels = StreamEx.iterate((Object)statement, Objects::nonNull, PsiElement::getParent).select(PsiLabeledStatement.class).map(PsiLabeledStatement::getName).toSet();
        this.myCommentTracker = ct;
    }

    StreamToLoopReplacementContext(StreamToLoopReplacementContext parentContext, List<StreamToLoopInspection.OperationRecord> records) {
        super(parentContext);
        this.myUsedLabels = parentContext.myUsedLabels;
        this.mySuffix = "Inner";
        this.myHasNestedLoops = records.stream().anyMatch(or -> or.myOperation instanceof Operation.FlatMapOperation);
        this.myCommentTracker = parentContext.myCommentTracker;
    }

    public void registerReusedElement(@Nullable PsiElement element) {
        if (element == null) {
            return;
        }
        element.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitVariable(PsiVariable variable) {
                super.visitVariable(variable);
                StreamToLoopReplacementContext.this.myUsedNames.add(variable.getName());
            }
        });
        this.myCommentTracker.markUnchanged(element);
    }

    @Nullable
    private String allocateLabel() {
        if (!this.myHasNestedLoops) {
            return null;
        }
        if (this.myLabel == null) {
            String base = StringUtil.toUpperCase((String)this.mySuffix);
            this.myLabel = (String)((StreamEx)IntStreamEx.ints().mapToObj(i -> i == 0 ? base : base + i).remove(this.myUsedLabels::contains)).findFirst().orElseThrow(IllegalArgumentException::new);
            this.myUsedLabels.add(this.myLabel);
        }
        return this.myLabel;
    }

    public String getLoopLabel() {
        return this.myLabel == null ? "" : this.myLabel + ":\n";
    }

    public String getBreakStatement() {
        String label = this.allocateLabel();
        return label == null ? "break;\n" : "break " + label + ";\n";
    }

    @Override
    public String declare(String desiredName, String type2, String initializer) {
        String name2 = this.registerVarName(this.mySuffix.isEmpty() ? Collections.singleton(desiredName) : Arrays.asList(desiredName, desiredName + this.mySuffix));
        this.addBeforeStep(type2 + " " + name2 + " = " + initializer + ";");
        return name2;
    }

    public String declareResult(String desiredName, PsiType type2, String initializer, @NotNull StreamToLoopInspection.ResultKind kind2) {
        return this.declareResult(desiredName, type2, null, initializer, kind2);
    }

    public String declareResult(String desiredName, PsiType type2, String mostAbstractAllowedType, String initializer, @NotNull StreamToLoopInspection.ResultKind kind2) {
        PsiDeclarationStatement declaration2;
        PsiVariable var;
        if (kind2 != StreamToLoopInspection.ResultKind.UNKNOWN && this.myChainExpression.getParent() instanceof PsiVariable && StreamToLoopReplacementContext.isCompatibleType(var = (PsiVariable)this.myChainExpression.getParent(), type2, mostAbstractAllowedType) && var.getParent() instanceof PsiDeclarationStatement && (kind2 == StreamToLoopInspection.ResultKind.FINAL || VariableAccessUtils.canUseAsNonFinal((PsiLocalVariable)ObjectUtils.tryCast((Object)var, PsiLocalVariable.class))) && (declaration2 = (PsiDeclarationStatement)var.getParent()).getDeclaredElements().length == 1) {
            PsiExpression oldInitializer;
            PsiModifierList modifierList;
            this.myChainExpression = declaration2;
            PsiVariable copy = (PsiVariable)var.copy();
            if (kind2 == StreamToLoopInspection.ResultKind.NON_FINAL && (modifierList = copy.getModifierList()) != null) {
                modifierList.setModifierProperty("final", false);
            }
            LOG.assertTrue((oldInitializer = copy.getInitializer()) != null);
            oldInitializer.replace((PsiElement)this.createExpression(initializer));
            this.addBeforeStep(copy.getText());
            return var.getName();
        }
        String name2 = this.registerVarName(Arrays.asList(desiredName, "result"));
        this.addBeforeStep(type2.getCanonicalText() + " " + name2 + " = " + initializer + ";");
        if (this.myFinisher != null) {
            throw new IllegalStateException("Finisher is already defined");
        }
        this.setFinisher(name2);
        return name2;
    }

    public boolean tryUnwrapOrElse(@NotNull Number wantedValue) {
        if (!(this.myChainExpression instanceof PsiExpression)) {
            return false;
        }
        PsiMethodCallExpression call = ExpressionUtils.getCallForQualifier((PsiExpression)this.myChainExpression);
        if (call == null || call.getParent() instanceof PsiExpressionStatement || !"orElse".equals(call.getMethodExpression().getReferenceName())) {
            return false;
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        if (args.length == 1 && wantedValue.equals(ExpressionUtils.computeConstantExpression(args[0]))) {
            this.myChainExpression = call;
            return true;
        }
        return false;
    }

    private static boolean isCompatibleType(@NotNull PsiVariable var, @NotNull PsiType type2, @Nullable String mostAbstractAllowedType) {
        if (EquivalenceChecker.getCanonicalPsiEquivalence().typesAreEquivalent(var.getType(), type2)) {
            return true;
        }
        if (mostAbstractAllowedType == null) {
            return false;
        }
        PsiType[] superTypes = type2.getSuperTypes();
        return Arrays.stream(superTypes).anyMatch(superType -> InheritanceUtil.isInheritor((PsiType)superType, (String)mostAbstractAllowedType) && StreamToLoopReplacementContext.isCompatibleType(var, superType, mostAbstractAllowedType));
    }

    public PsiElement makeFinalReplacement() {
        LOG.assertTrue(this.myChainExpression != null);
        if (this.myFinisher == null || this.myChainExpression instanceof PsiStatement) {
            PsiElement toDelete = this.myChainExpression;
            if (toDelete instanceof PsiExpression && toDelete.getParent() instanceof PsiExpressionStatement) {
                toDelete = toDelete.getParent();
                while (toDelete instanceof PsiExpressionStatement && toDelete.getParent() instanceof PsiLabeledStatement) {
                    toDelete = toDelete.getParent();
                }
            }
            this.myCommentTracker.delete(toDelete);
            return null;
        }
        PsiExpression expression2 = this.createExpression(this.myFinisher);
        PsiElement parent = this.myChainExpression.getParent();
        if (parent instanceof PsiExpression && ParenthesesUtils.areParenthesesNeeded(expression2, (PsiExpression)parent, false)) {
            expression2 = this.createExpression("(" + this.myFinisher + ")");
        }
        return this.myCommentTracker.replace(this.myChainExpression, (PsiElement)expression2);
    }

    public void setFinisher(String finisher) {
        this.myFinisher = finisher;
    }

    public void setFinisher(ConditionalExpression conditionalExpression) {
        if (conditionalExpression instanceof ConditionalExpression.Optional) {
            conditionalExpression = this.tryUnwrapOptional((ConditionalExpression.Optional)conditionalExpression, true);
        }
        this.setFinisher(conditionalExpression.asExpression());
    }

    public String assignAndBreak(ConditionalExpression conditionalExpression) {
        FunctionHelper fn;
        PsiExpression[] args;
        PsiMethodCallExpression call;
        PsiIfStatement ifStatement;
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myChainExpression, PsiStatement.class);
        boolean inReturn = statement instanceof PsiReturnStatement;
        if (conditionalExpression instanceof ConditionalExpression.Optional) {
            conditionalExpression = this.tryUnwrapOptional((ConditionalExpression.Optional)conditionalExpression, inReturn);
        }
        if (conditionalExpression instanceof ConditionalExpression.Boolean) {
            conditionalExpression = this.tryUnwrapBoolean((ConditionalExpression.Boolean)conditionalExpression, inReturn);
        }
        if (inReturn) {
            this.setFinisher(conditionalExpression.getFalseBranch());
            Object mark = new Object();
            PsiTreeUtil.mark((PsiElement)this.myChainExpression, (Object)mark);
            PsiElement returnCopy = statement.copy();
            PsiElement placeHolderCopy = PsiTreeUtil.releaseMark((PsiElement)returnCopy, (Object)mark);
            LOG.assertTrue(placeHolderCopy != null);
            PsiElement replacement = placeHolderCopy.replace((PsiElement)this.createExpression(conditionalExpression.getTrueBranch()));
            if (returnCopy == placeHolderCopy) {
                returnCopy = replacement;
            }
            String text2 = returnCopy.getText();
            if (returnCopy.getLastChild() instanceof PsiComment) {
                text2 = text2 + "\n";
            }
            return text2;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)this.myChainExpression.getParent());
        if (parent instanceof PsiIfStatement && conditionalExpression instanceof ConditionalExpression.Boolean && !((ConditionalExpression.Boolean)conditionalExpression).isInverted() && (ifStatement = (PsiIfStatement)parent).getElseBranch() == null) {
            PsiStatement thenStatement = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
            if (thenStatement instanceof PsiReturnStatement || thenStatement instanceof PsiThrowStatement) {
                this.myChainExpression = parent;
                return thenStatement.getText();
            }
            if (thenStatement instanceof PsiExpressionStatement) {
                this.myChainExpression = parent;
                return thenStatement.getText() + "\n" + this.getBreakStatement();
            }
        }
        if (conditionalExpression instanceof ConditionalExpression.Optional && this.myChainExpression instanceof PsiExpression && (call = ExpressionUtils.getCallForQualifier((PsiExpression)this.myChainExpression)) != null && call.getParent() instanceof PsiExpressionStatement && (args = call.getArgumentList().getExpressions()).length == 1 && "ifPresent".equals(call.getMethodExpression().getReferenceName()) && (fn = FunctionHelper.create(args[0], 1)) != null) {
            fn.transform(this, ((ConditionalExpression.Optional)conditionalExpression).unwrap("").getTrueBranch());
            this.myChainExpression = call.getParent();
            return fn.getStatementText() + this.getBreakStatement();
        }
        String found = this.declareResult(conditionalExpression.getCondition(), this.createType(conditionalExpression.getType()), conditionalExpression.getFalseBranch(), StreamToLoopInspection.ResultKind.NON_FINAL);
        return found + " = " + conditionalExpression.getTrueBranch() + ";\n" + this.getBreakStatement();
    }

    private ConditionalExpression tryUnwrapBoolean(ConditionalExpression.Boolean condition2, boolean unwrapLazilyEvaluated) {
        if (this.myChainExpression instanceof PsiExpression) {
            PsiConditionalExpression ternary;
            PsiExpression negation = BoolUtils.findNegation((PsiExpression)this.myChainExpression);
            if (negation != null) {
                this.myChainExpression = negation;
                condition2 = condition2.negate();
            }
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)this.myChainExpression.getParent());
            ConditionalExpression candidate = null;
            if (parent instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression expression2 = (PsiPolyadicExpression)parent;
                Object[] operands2 = expression2.getOperands();
                if (operands2.length > 1 && PsiTreeUtil.isAncestor((PsiElement)operands2[0], (PsiElement)this.myChainExpression, (boolean)false)) {
                    IElementType type2 = expression2.getOperationTokenType();
                    if (type2.equals(JavaTokenType.ANDAND)) {
                        candidate = condition2.toPlain((PsiType)PsiType.BOOLEAN, StreamEx.of((Object[])operands2, (int)1, (int)operands2.length).map(PsiElement::getText).joining((CharSequence)" && "), "false");
                    } else if (type2.equals(JavaTokenType.OROR)) {
                        candidate = condition2.toPlain((PsiType)PsiType.BOOLEAN, "true", StreamEx.of((Object[])operands2, (int)1, (int)operands2.length).map(PsiElement::getText).joining((CharSequence)" || "));
                    }
                }
            } else if (parent instanceof PsiConditionalExpression && PsiTreeUtil.isAncestor((PsiElement)(ternary = (PsiConditionalExpression)parent).getCondition(), (PsiElement)this.myChainExpression, (boolean)false)) {
                PsiType type3 = ternary.getType();
                PsiExpression thenExpression2 = ternary.getThenExpression();
                PsiExpression elseExpression2 = ternary.getElseExpression();
                if (type3 != null && thenExpression2 != null && elseExpression2 != null) {
                    candidate = condition2.toPlain(type3, thenExpression2.getText(), elseExpression2.getText());
                }
            }
            if (candidate != null && (unwrapLazilyEvaluated || ExpressionUtils.isSafelyRecomputableExpression(this.createExpression(candidate.getFalseBranch())))) {
                this.myChainExpression = parent;
                return candidate;
            }
        }
        return condition2;
    }

    @NotNull
    private ConditionalExpression tryUnwrapOptional(ConditionalExpression.Optional condition2, boolean unwrapLazilyEvaluated) {
        PsiMethodCallExpression call;
        if (this.myChainExpression instanceof PsiExpression && (call = ExpressionUtils.getCallForQualifier((PsiExpression)this.myChainExpression)) != null && !(call.getParent() instanceof PsiExpressionStatement)) {
            String name2 = call.getMethodExpression().getReferenceName();
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length == 0 && "isPresent".equals(name2)) {
                this.myChainExpression = call;
                return new ConditionalExpression.Boolean(condition2.getCondition(), false);
            }
            if (args.length == 1) {
                FunctionHelper helper;
                String absentExpression = null;
                if ("orElse".equals(name2)) {
                    absentExpression = args[0].getText();
                } else if (unwrapLazilyEvaluated && "orElseGet".equals(name2) && (helper = FunctionHelper.create(args[0], 0)) != null) {
                    helper.transform(this, new String[0]);
                    absentExpression = helper.getText();
                }
                if (absentExpression != null) {
                    this.myChainExpression = call;
                    return condition2.unwrap(absentExpression);
                }
            }
        }
        return condition2;
    }
}

