/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamToLoop;

import com.intellij.codeInspection.streamToLoop.ChainContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class ChainVariable {
    private static final Logger LOG = Logger.getInstance(ChainVariable.class);
    public static final ChainVariable STUB = new ChainVariable((PsiType)PsiType.VOID){

        @Override
        public void addBestNameCandidate(String candidate) {
        }

        @Override
        public void register(ChainContext context) {
        }

        @Override
        public String toString() {
            return "###STUB###";
        }
    };
    String myName;
    @NotNull
    PsiType myType;
    boolean myFinal;
    private Collection<String> myBestCandidates = new LinkedHashSet<String>();
    private Collection<String> myOtherCandidates = new LinkedHashSet<String>();

    public ChainVariable(@NotNull PsiType type2) {
        this.myType = type2;
    }

    public ChainVariable(@NotNull PsiType type2, @NotNull String name2) {
        this.myType = type2;
        this.myName = name2;
    }

    public void markFinal() {
        this.myFinal = true;
    }

    public void addBestNameCandidate(String candidate) {
        this.myBestCandidates.add(candidate);
    }

    void addOtherNameCandidate(String candidate) {
        this.myOtherCandidates.add(candidate);
    }

    public void register(ChainContext context) {
        LOG.assertTrue(this.myName == null);
        Object[] fromType = JavaCodeStyleManager.getInstance((Project)context.getProject()).suggestVariableName((VariableKind)VariableKind.LOCAL_VARIABLE, null, null, (PsiType)this.myType, (boolean)true).names;
        List variants = ((StreamEx)StreamEx.of(this.myBestCandidates).append(this.myOtherCandidates).append(fromType).distinct()).toList();
        if (variants.isEmpty()) {
            variants.add("val");
        }
        this.myName = context.registerVarName(variants);
        this.myOtherCandidates = null;
        this.myBestCandidates = null;
    }

    public String getName() {
        return this.myName;
    }

    @NotNull
    public PsiType getType() {
        return this.myType;
    }

    public String getDeclaration() {
        return this.getType().getCanonicalText() + " " + this.getName();
    }

    public String getDeclaration(String initializer) {
        return this.getType().getCanonicalText() + " " + this.getName() + "=" + initializer + ";\n";
    }

    public boolean isFinal() {
        return this.myFinal;
    }

    public boolean isRegistered() {
        return this.myName != null;
    }

    public String toString() {
        if (this.myName == null) {
            return "###(unregistered: " + this.myBestCandidates + "|" + this.myOtherCandidates + ")###";
        }
        return this.myName;
    }
}

