/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.ForEachMigration;
import com.intellij.codeInspection.streamMigration.MigrateToStreamFix;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplifyForEachInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher.Simple ITERABLE_FOREACH = CallMatcher.instanceCall("java.lang.Iterable", "forEach").parameterCount(1);
    private static final CallMatcher.Simple STREAM_FOREACH_ORDERED = CallMatcher.instanceCall("java.util.stream.BaseStream", "forEachOrdered").parameterCount(1);
    private static final CallMatcher STREAM_FOREACH = CallMatcher.instanceCall("java.util.stream.BaseStream", "forEach", "forEachOrdered").parameterCount(1);

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return InspectionsBundle.message((String)"group.names.language.level.specific.issues.and.migration.aids", (Object[])new Object[0]);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiFile file = holder.getFile();
        VirtualFile virtualFile = file.getVirtualFile();
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)file) || virtualFile == null || !FileIndexFacade.getInstance((Project)holder.getProject()).isInSourceContent(virtualFile)) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                boolean lastOpChanged;
                SimplifyForEachContext context = SimplifyForEachContext.from(call);
                if (context == null) {
                    return;
                }
                boolean opCountChanged = context.myTerminalBlock.getOperationCount() > 1;
                boolean bl = lastOpChanged = !(context.myMigration instanceof ForEachMigration);
                if (opCountChanged || lastOpChanged) {
                    String customMessage = lastOpChanged ? JavaBundle.message((String)"inspection.simplify.for.each.replace", (Object[])new Object[]{context.myMigration.getReplacement()}) : JavaBundle.message((String)"inspection.simplify.for.each.extract.intermediate.operations", (Object[])new Object[0]);
                    ProblemHighlightType highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                    holder.registerProblem((PsiElement)context.myMainStatement, customMessage, highlightType, SimplifyForEachInspection.getRange(call).shiftRight(-call.getTextOffset()), new LocalQuickFix[]{new SimplifyForEachFix(customMessage)});
                }
            }
        };
    }

    @NotNull
    private static TextRange getRange(PsiMethodCallExpression call) {
        if (!InspectionProjectProfileManager.isInformationLevel((String)"SimplifyForEach", (PsiElement)call)) {
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            return new TextRange(methodExpression.getTextOffset(), call.getArgumentList().getTextOffset());
        }
        return call.getTextRange();
    }

    @Nullable
    static TerminalBlock extractTerminalBlock(@Nullable PsiElement lambdaBody, @NotNull ExistingStreamSource source) {
        if (lambdaBody instanceof PsiCodeBlock) {
            return TerminalBlock.from((StreamApiMigrationInspection.StreamSource)source, (PsiCodeBlock)lambdaBody);
        }
        if (lambdaBody instanceof PsiExpression) {
            return TerminalBlock.fromStatements(source, new PsiStatement[]{new LightExpressionStatement((PsiExpression)lambdaBody)});
        }
        return null;
    }

    @Nullable
    static PsiLambdaExpression extractLambdaFromForEach(@NotNull PsiMethodCallExpression call) {
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        if (qualifier == null || !STREAM_FOREACH.test(call) && !SimplifyForEachInspection.isCollectionForEach(call, qualifier)) {
            return null;
        }
        PsiExpression arg = call.getArgumentList().getExpressions()[0];
        return (PsiLambdaExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)arg), PsiLambdaExpression.class);
    }

    private static boolean isCollectionForEach(PsiMethodCallExpression call, PsiExpression qualifier) {
        return ITERABLE_FOREACH.test(call) && InheritanceUtil.isInheritor((PsiType)qualifier.getType(), (String)"java.util.Collection");
    }

    public static class ForEachNonFinalFix
    extends PsiElementBaseIntentionAction
    implements HighPriorityAction {
        private final PsiElement myContext;

        public ForEachNonFinalFix(PsiElement context) {
            SimplifyForEachContext simplifyContext = ForEachNonFinalFix.findMigration(context);
            if (simplifyContext == null) {
                this.myContext = null;
            } else {
                this.myContext = context;
                this.setText(JavaBundle.message((String)"quickfix.text.avoid.mutation.using.stream.api.0.operation", (Object[])new Object[]{simplifyContext.myMigration.getReplacement()}));
            }
        }

        private static SimplifyForEachContext findMigration(PsiElement context) {
            if (!(context instanceof PsiReferenceExpression) || !PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)context))) {
                return null;
            }
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)context, PsiLambdaExpression.class);
            if (lambda2 == null) {
                return null;
            }
            PsiElement lambdaBody = lambda2.getBody();
            if (lambdaBody == null) {
                return null;
            }
            PsiExpressionList parameters2 = (PsiExpressionList)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)lambda2.getParent()), PsiExpressionList.class);
            if (parameters2 == null || parameters2.getExpressionCount() != 1) {
                return null;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)parameters2.getParent(), PsiMethodCallExpression.class);
            SimplifyForEachContext simplifyForEachContext = SimplifyForEachContext.from(call);
            if (simplifyForEachContext == null || simplifyForEachContext.myMigration instanceof ForEachMigration) {
                return null;
            }
            return simplifyForEachContext;
        }

        public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
            PsiElement result;
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLambdaExpression.class), PsiMethodCallExpression.class);
            SimplifyForEachContext simplifyForEachContext = SimplifyForEachContext.from(call);
            if (simplifyForEachContext != null && (result = simplifyForEachContext.migrate()) != null) {
                MigrateToStreamFix.simplify(project, result);
            }
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
            return this.myContext != null && this.myContext.isValid();
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"quickfix.family.avoid.mutation.using.stream.api", (Object[])new Object[0]);
        }
    }

    public static class SimplifyForEachFix
    implements LocalQuickFix {
        @NotNull
        private final String myCustomName;

        protected SimplifyForEachFix(@NotNull String customName) {
            this.myCustomName = customName;
        }

        @Nls
        @NotNull
        public String getName() {
            return this.myCustomName;
        }

        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"quickfix.family.simplify.foreach.lambda", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiExpressionStatement statement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)descriptor.getPsiElement(), PsiExpressionStatement.class);
            if (statement == null) {
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)statement.getExpression(), PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            SimplifyForEachContext simplifyForEachContext = SimplifyForEachContext.from(call);
            if (simplifyForEachContext == null) {
                return;
            }
            PsiElement result = simplifyForEachContext.migrate();
            if (result == null) {
                return;
            }
            MigrateToStreamFix.simplify(project, result);
        }
    }

    static class SimplifyForEachContext {
        @NotNull
        private final TerminalBlock myTerminalBlock;
        @NotNull
        private final PsiStatement myMainStatement;
        @NotNull
        private final BaseStreamApiMigration myMigration;
        @NotNull
        private final PsiElement myLambdaBody;

        private SimplifyForEachContext(@NotNull TerminalBlock terminalBlock, @NotNull PsiStatement mainStatement, @NotNull PsiElement body2, @NotNull BaseStreamApiMigration migration) {
            this.myTerminalBlock = terminalBlock;
            this.myMainStatement = mainStatement;
            this.myLambdaBody = body2;
            this.myMigration = migration;
        }

        public PsiElement migrate() {
            PsiElement result = this.myMigration.migrate(this.myMainStatement.getProject(), this.myLambdaBody, this.myTerminalBlock);
            if (result != null) {
                this.myTerminalBlock.operations().forEach(StreamApiMigrationInspection.Operation::cleanUp);
            }
            return result;
        }

        static SimplifyForEachContext from(@Nullable PsiMethodCallExpression call) {
            if (call == null) {
                return null;
            }
            PsiLambdaExpression lambda2 = SimplifyForEachInspection.extractLambdaFromForEach(call);
            if (lambda2 == null) {
                return null;
            }
            PsiElement lambdaBody = lambda2.getBody();
            ExistingStreamSource source = ExistingStreamSource.extractSource(call, lambda2);
            if (source == null) {
                return null;
            }
            TerminalBlock terminalBlock = SimplifyForEachInspection.extractTerminalBlock(lambdaBody, source);
            if (terminalBlock == null) {
                return null;
            }
            PsiStatement mainStatement = source.getMainStatement();
            BaseStreamApiMigration migration = StreamApiMigrationInspection.findMigration(mainStatement, lambdaBody, terminalBlock, true, true);
            if (migration instanceof ForEachMigration && STREAM_FOREACH_ORDERED.test(call)) {
                migration = new ForEachMigration(migration.isShouldWarn(), "forEachOrdered");
            }
            return migration == null ? null : new SimplifyForEachContext(terminalBlock, mainStatement, lambdaBody, migration);
        }
    }

    static class ExistingStreamSource
    extends StreamApiMigrationInspection.StreamSource {
        private final boolean myIsCollectionForEach;

        protected ExistingStreamSource(PsiStatement mainStatement, PsiVariable variable, PsiExpression expression2, boolean isCollectionForEach) {
            super(mainStatement, variable, expression2);
            this.myIsCollectionForEach = isCollectionForEach;
        }

        @Override
        String createReplacement(CommentTracker ct) {
            return this.myExpression.getText() + (this.myIsCollectionForEach ? ".stream()" : "");
        }

        @Nullable
        static ExistingStreamSource extractSource(PsiMethodCallExpression call, PsiLambdaExpression lambda2) {
            PsiParameter[] parameters2 = lambda2.getParameterList().getParameters();
            if (parameters2.length != 1) {
                return null;
            }
            PsiParameter parameter2 = parameters2[0];
            boolean isCollectionForEach = ITERABLE_FOREACH.test(call);
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return null;
            }
            PsiStatement parent = (PsiStatement)ObjectUtils.tryCast((Object)call.getParent(), PsiExpressionStatement.class);
            if (parent == null) {
                return null;
            }
            return new ExistingStreamSource(parent, (PsiVariable)parameter2, qualifier, isCollectionForEach);
        }
    }

    static class LightExpressionStatement
    extends LightElement
    implements PsiExpressionStatement {
        @NotNull
        private final PsiExpression myExpression;

        protected LightExpressionStatement(@NotNull PsiExpression expression2) {
            super(expression2.getManager(), (Language)JavaLanguage.INSTANCE);
            this.myExpression = expression2;
        }

        @NotNull
        public PsiExpression getExpression() {
            return this.myExpression;
        }

        public String toString() {
            return this.myExpression.getText() + ";";
        }
    }
}

