/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.sameParameterValue;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefParameterImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.unusedSymbol.VisibilityModifierChooser;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.safeDelete.JavaSafeDeleteProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.uast.UastHintedVisitorAdapter;
import com.intellij.ui.components.fields.IntegerField;
import com.intellij.ui.components.fields.valueEditors.ValueEditor;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

public class SameParameterValueInspection
extends GlobalJavaBatchInspectionTool {
    private static final Logger LOG = Logger.getInstance(SameParameterValueInspection.class);
    @PsiModifier.ModifierConstant
    private static final String DEFAULT_HIGHEST_MODIFIER = "protected";
    @PsiModifier.ModifierConstant
    public String highestModifier = "protected";
    public int minimalUsageCount = 1;

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        LabeledComponent component = LabeledComponent.create((JComponent)new VisibilityModifierChooser(() -> true, this.highestModifier, (Consumer<? super String>)((Consumer)newModifier -> {
            this.highestModifier = newModifier;
        })), (String)JavaBundle.message((String)"label.minimal.reported.method.visibility", (Object[])new Object[0]), (String)"West");
        panel2.add((Component)component, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 23, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        IntegerField minimalUsageCountEditor = new IntegerField(null, 1, Integer.MAX_VALUE);
        minimalUsageCountEditor.getValueEditor().addListener((ValueEditor.Listener)new ValueEditor.Listener<Integer>(){

            public void valueChanged(@NotNull Integer newValue) {
                SameParameterValueInspection.this.minimalUsageCount = newValue;
            }
        });
        minimalUsageCountEditor.setValue(Integer.valueOf(this.minimalUsageCount));
        minimalUsageCountEditor.setColumns(4);
        panel2.add((Component)LabeledComponent.create((JComponent)minimalUsageCountEditor, (String)JavaBundle.message((String)"label.minimal.reported.method.usage.count", (Object[])new Object[0]), (String)"West"), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 23, 18, (Insets)JBUI.emptyInsets(), 0, 0));
        return panel2;
    }

    protected LocalQuickFix createFix(String paramName, String value2) {
        return new InlineParameterValueFix(paramName, value2);
    }

    public CommonProblemDescriptor @Nullable [] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor2) {
        ArrayList<ProblemDescriptor> problems = null;
        if (refEntity instanceof RefMethod) {
            RefParameter[] parameters2;
            RefMethod refMethod = (RefMethod)refEntity;
            if (refMethod.hasSuperMethods() || VisibilityUtil.compare((String)refMethod.getAccessModifier(), (String)this.highestModifier) < 0 || refMethod.isEntry()) {
                return null;
            }
            for (RefParameter refParameter : parameters2 = refMethod.getParameters()) {
                UParameter parameter2;
                Object value2 = refParameter.getActualConstValue();
                if (value2 == RefParameter.VALUE_IS_NOT_CONST || value2 == RefParameter.VALUE_UNDEFINED || this.minimalUsageCount != 0 && refParameter.getUsageCount() < this.minimalUsageCount || !globalContext.shouldCheck((RefEntity)refParameter, (GlobalInspectionTool)this)) continue;
                if (problems == null) {
                    problems = new ArrayList<ProblemDescriptor>(1);
                }
                if ((parameter2 = refParameter.getUastElement()) == null) continue;
                problems.add(this.registerProblem(manager, parameter2, value2, refParameter.isUsedForWriting()));
            }
        }
        return problems == null ? null : problems.toArray(CommonProblemDescriptor.EMPTY_ARRAY);
    }

    protected boolean queryExternalUsagesRequests(@NotNull RefManager manager, final @NotNull GlobalJavaInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor processor2) {
        manager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity instanceof RefElement && processor2.getDescriptions(refEntity) != null) {
                    refEntity.accept((RefVisitor)new RefJavaVisitor(){

                        public void visitMethod(final @NotNull RefMethod refMethod) {
                            globalContext.enqueueMethodUsagesProcessor(refMethod, new GlobalJavaInspectionContext.UsagesProcessor(){

                                public boolean process(PsiReference psiReference) {
                                    processor2.ignoreElement((RefEntity)refMethod);
                                    return false;
                                }
                            });
                        }
                    });
                }
            }
        });
        return false;
    }

    @NotNull
    public String getGroupDisplayName() {
        return InspectionsBundle.message((String)"group.names.declaration.redundancy", (Object[])new Object[0]);
    }

    @NotNull
    public String getShortName() {
        return "SameParameterValue";
    }

    @Nullable
    public QuickFix getQuickFix(String hint) {
        if (hint == null) {
            return null;
        }
        int spaceIdx = hint.indexOf(32);
        if (spaceIdx == -1 || spaceIdx >= hint.length() - 1) {
            return null;
        }
        String paramName = hint.substring(0, spaceIdx);
        String value2 = hint.substring(spaceIdx + 1);
        return this.createFix(paramName, value2);
    }

    @Nullable
    public String getHint(@NotNull QuickFix fix) {
        return fix.toString();
    }

    @Nullable
    public LocalInspectionTool getSharedLocalInspectionTool() {
        return new LocalSameParameterValueInspection(this);
    }

    private ProblemDescriptor registerProblem(@NotNull InspectionManager manager, UParameter parameter2, Object value2, boolean usedForWriting) {
        String shortName;
        String stringPresentation;
        String name2 = parameter2.getName();
        boolean accessible = true;
        PsiParameter javaParameter = (PsiParameter)ObjectUtils.tryCast((Object)parameter2.getSourcePsi(), PsiParameter.class);
        if (value2 instanceof PsiType) {
            stringPresentation = ((PsiType)value2).getCanonicalText() + ".class";
            shortName = ((PsiType)value2).getPresentableText() + ".class";
        } else if (value2 instanceof PsiField) {
            accessible = javaParameter != null && PsiUtil.isMemberAccessibleAt((PsiMember)((PsiMember)value2), (PsiElement)javaParameter);
            stringPresentation = PsiFormatUtil.formatVariable((PsiVariable)((PsiVariable)value2), (int)6145, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            shortName = PsiFormatUtil.formatVariable((PsiVariable)((PsiVariable)value2), (int)4097, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        } else {
            stringPresentation = shortName = String.valueOf(value2);
        }
        boolean suggestFix = false;
        if (javaParameter != null) {
            suggestFix = !javaParameter.isVarArgs() && !usedForWriting && accessible;
        }
        return manager.createProblemDescriptor((PsiElement)ObjectUtils.notNull((Object)UDeclarationKt.getAnchorPsi((UDeclaration)parameter2), (Object)parameter2), JavaBundle.message((String)"inspection.same.parameter.problem.descriptor", (Object[])new Object[]{name2, StringUtil.unquoteString((String)shortName)}), suggestFix ? this.createFix(name2, stringPresentation) : null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false);
    }

    private class LocalSameParameterValueInspection
    extends AbstractBaseUastLocalInspectionTool {
        private final SameParameterValueInspection myGlobal;

        private LocalSameParameterValueInspection(SameParameterValueInspection global) {
            this.myGlobal = global;
        }

        public boolean runForWholeFile() {
            return true;
        }

        @NotNull
        public String getGroupDisplayName() {
            return this.myGlobal.getGroupDisplayName();
        }

        @NotNull
        public String getShortName() {
            return this.myGlobal.getShortName();
        }

        @NotNull
        public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
            return UastHintedVisitorAdapter.create((Language)holder.getFile().getLanguage(), (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(){
                private final UnusedDeclarationInspectionBase myDeadCodeTool;
                {
                    this.myDeadCodeTool = UnusedDeclarationInspectionBase.findUnusedDeclarationInspection((PsiElement)holder.getFile());
                }

                public boolean visitMethod(@NotNull UMethod method) {
                    Object[] paramValues;
                    PsiMethod javaMethod = method.getJavaPsi();
                    if (method.isConstructor() || VisibilityUtil.compare((String)VisibilityUtil.getVisibilityModifier((PsiModifierList)javaMethod.getModifierList()), (String)SameParameterValueInspection.this.highestModifier) < 0) {
                        return true;
                    }
                    if (javaMethod.hasModifierProperty("native")) {
                        return true;
                    }
                    List parameters2 = method.getUastParameters();
                    if (parameters2.isEmpty()) {
                        return true;
                    }
                    if (this.myDeadCodeTool.isEntryPoint((PsiElement)javaMethod)) {
                        return true;
                    }
                    if (!javaMethod.getHierarchicalMethodSignature().getSuperSignatures().isEmpty()) {
                        return true;
                    }
                    UParameter lastParameter = (UParameter)parameters2.get(parameters2.size() - 1);
                    boolean hasVarArg = lastParameter.getType() instanceof PsiEllipsisType;
                    if (hasVarArg) {
                        if (parameters2.size() == 1) {
                            return true;
                        }
                        paramValues = new Object[parameters2.size() - 1];
                    } else {
                        paramValues = new Object[parameters2.size()];
                    }
                    Arrays.fill(paramValues, RefParameter.VALUE_UNDEFINED);
                    int[] usageCount = new int[]{0};
                    if (UnusedSymbolUtil.processUsages(holder.getProject(), holder.getFile(), (PsiMember)javaMethod, (ProgressIndicator)new EmptyProgressIndicator(), null, (Processor<? super UsageInfo>)((Processor)info -> {
                        PsiElement element = info.getElement();
                        usageCount[0] = usageCount[0] + 1;
                        UElement uElement = UastContextKt.toUElement((PsiElement)element);
                        if (!(uElement instanceof UReferenceExpression)) {
                            return false;
                        }
                        if (uElement instanceof UCallableReferenceExpression) {
                            return false;
                        }
                        UElement parent = uElement.getUastParent();
                        if (!(parent instanceof UCallExpression)) {
                            return false;
                        }
                        UCallExpression methodCall = (UCallExpression)parent;
                        List arguments = methodCall.getValueArguments();
                        if (arguments.size() < paramValues.length) {
                            return false;
                        }
                        boolean needFurtherProcess = false;
                        for (int i = 0; i < paramValues.length; ++i) {
                            Object value2 = paramValues[i];
                            Object currentArg = LocalSameParameterValueInspection.this.getArgValue((UExpression)arguments.get(i), method.getPsi());
                            if (value2 == RefParameter.VALUE_UNDEFINED) {
                                paramValues[i] = currentArg;
                                if (currentArg == RefParameter.VALUE_IS_NOT_CONST) continue;
                                needFurtherProcess = true;
                                continue;
                            }
                            if (value2 == RefParameter.VALUE_IS_NOT_CONST) continue;
                            if (!Comparing.equal((Object)paramValues[i], (Object)currentArg)) {
                                paramValues[i] = RefParameter.VALUE_IS_NOT_CONST;
                                continue;
                            }
                            needFurtherProcess = true;
                        }
                        return needFurtherProcess;
                    }))) {
                        if (SameParameterValueInspection.this.minimalUsageCount != 0 && usageCount[0] < SameParameterValueInspection.this.minimalUsageCount) {
                            return true;
                        }
                        int length = paramValues.length;
                        for (int i = 0; i < length; ++i) {
                            Object value2 = paramValues[i];
                            if (value2 == RefParameter.VALUE_UNDEFINED || value2 == RefParameter.VALUE_IS_NOT_CONST) continue;
                            holder.registerProblem(SameParameterValueInspection.this.registerProblem(holder.getManager(), (UParameter)parameters2.get(i), value2, false));
                        }
                    }
                    return true;
                }
            }, (Class[])new Class[]{UMethod.class});
        }

        private Object getArgValue(UExpression arg, PsiMethod method) {
            return RefParameterImpl.getAccessibleExpressionValue(arg, () -> method);
        }
    }

    public static class InlineParameterValueFix
    implements LocalQuickFix {
        private final String myValue;
        private final String myParameterName;

        private InlineParameterValueFix(String parameterName, String value2) {
            this.myValue = value2;
            this.myParameterName = parameterName;
        }

        public String toString() {
            return this.getParamName() + " " + this.myValue;
        }

        @NotNull
        public String getName() {
            return JavaBundle.message((String)"inspection.same.parameter.fix.name", (Object[])new Object[]{this.myParameterName, StringUtil.unquoteString((String)this.myValue)});
        }

        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"inspection.same.parameter.fix.family.name", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiExpression defToInline;
            PsiElement element = descriptor.getPsiElement();
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
            if (method == null) {
                return;
            }
            PsiParameter parameter2 = (PsiParameter)PsiTreeUtil.getParentOfType((PsiElement)element, PsiParameter.class, (boolean)false);
            if (parameter2 == null) {
                PsiParameter[] parameters2;
                for (PsiParameter psiParameter : parameters2 = method.getParameterList().getParameters()) {
                    if (!Comparing.strEqual((String)psiParameter.getName(), (String)this.myParameterName)) continue;
                    parameter2 = psiParameter;
                    break;
                }
            }
            if (parameter2 == null) {
                return;
            }
            try {
                defToInline = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(this.myValue, (PsiElement)parameter2);
            }
            catch (IncorrectOperationException e) {
                return;
            }
            PsiParameter parameterToInline = parameter2;
            InlineParameterValueFix.inlineSameParameterValue(method, parameterToInline, defToInline);
        }

        public boolean startInWriteAction() {
            return false;
        }

        public static void inlineSameParameterValue(PsiMethod method, PsiParameter parameter2, PsiExpression defToInline) {
            MultiMap conflicts = new MultiMap();
            ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>();
            methods.add(method);
            Project project = method.getProject();
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> methods.addAll(OverridingMethodsSearch.search((PsiMethod)method).findAll()), JavaBundle.message((String)"progress.title.search.for.overriding.methods", (Object[])new Object[0]), true, project)) {
                return;
            }
            if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, methods, (boolean)true)) {
                return;
            }
            int parameterIndex = method.getParameterList().getParameterIndex(parameter2);
            HashMap<PsiParameter, Collection> paramsToInline = new HashMap<PsiParameter, Collection>();
            for (PsiMethod psiMethod : methods) {
                PsiParameter psiParameter = psiMethod.getParameterList().getParameters()[parameterIndex];
                JavaSafeDeleteProcessor.collectMethodConflicts((MultiMap<PsiElement, String>)conflicts, psiMethod, psiParameter);
                Collection refsToInline = ReferencesSearch.search((PsiElement)psiParameter).findAll();
                for (PsiReference reference : refsToInline) {
                    PsiElement referenceElement = reference.getElement();
                    if (!(referenceElement instanceof PsiExpression) || !PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)referenceElement))) continue;
                    conflicts.putValue((Object)referenceElement, (Object)"Parameter has write usages. Inline is not supported");
                    break;
                }
                paramsToInline.put(psiParameter, refsToInline);
            }
            if (!BaseRefactoringProcessor.processConflicts((Project)project, (MultiMap)conflicts)) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                for (Map.Entry entry : paramsToInline.entrySet()) {
                    Collection refsToInline = (Collection)entry.getValue();
                    try {
                        PsiExpression[] exprs = new PsiExpression[refsToInline.size()];
                        int idx = 0;
                        for (PsiReference reference : refsToInline) {
                            if (!(reference instanceof PsiJavaCodeReferenceElement)) continue;
                            exprs[idx++] = InlineUtil.inlineVariable((PsiVariable)entry.getKey(), defToInline, (PsiJavaCodeReferenceElement)reference);
                        }
                        for (PsiExpression expr2 : exprs) {
                            if (expr2 == null) continue;
                            InlineUtil.tryToInlineArrayCreationForVarargs(expr2);
                        }
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            });
            InlineParameterValueFix.removeParameter(method, parameter2);
        }

        public static void removeParameter(PsiMethod method, PsiParameter parameter2) {
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            ArrayList<ParameterInfoImpl> psiParameters = new ArrayList<ParameterInfoImpl>();
            int paramIdx = 0;
            String paramName = parameter2.getName();
            for (PsiParameter param : parameters2) {
                if (!Comparing.strEqual((String)paramName, (String)param.getName())) {
                    psiParameters.add(ParameterInfoImpl.create(paramIdx).withName(param.getName()).withType(param.getType()));
                }
                ++paramIdx;
            }
            new ChangeSignatureProcessor(method.getProject(), method, false, null, method.getName(), method.getReturnType(), psiParameters.toArray(new ParameterInfoImpl[0])).run();
        }

        public String getParamName() {
            return this.myParameterName;
        }
    }
}

