/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reflectiveAccess;

import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.reflectiveAccess.JavaLangReflectHandleInvocationChecker;
import com.intellij.codeInspection.reflectiveAccess.JavaLangReflectVarHandleInvocationChecker;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLangInvokeHandleSignatureInspection
extends AbstractBaseJavaLocalInspectionTool {
    public static final Key<JavaReflectionReferenceUtil.ReflectiveSignature> DEFAULT_SIGNATURE = Key.create((String)"DEFAULT_SIGNATURE");
    public static final Key<List<LookupElement>> POSSIBLE_SIGNATURES = Key.create((String)"POSSIBLE_SIGNATURES");
    static final Set<String> KNOWN_METHOD_NAMES = Collections.unmodifiableSet(ContainerUtil.union(Arrays.asList(JavaReflectionReferenceUtil.HANDLE_FACTORY_METHOD_NAMES), Collections.singletonList("findConstructor")));
    private static final CallChecker[] CALL_CHECKERS = new CallChecker[]{JavaLangInvokeHandleSignatureInspection::checkHandlerFactoryCall, JavaLangReflectHandleInvocationChecker::checkMethodHandleInvocation, JavaLangReflectVarHandleInvocationChecker::checkVarHandleAccess};

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression callExpression) {
                super.visitMethodCallExpression(callExpression);
                for (CallChecker checker : CALL_CHECKERS) {
                    if (!checker.checkCall(callExpression, holder)) continue;
                    return;
                }
            }
        };
    }

    private static boolean checkHandlerFactoryCall(@NotNull PsiMethodCallExpression callExpression, @NotNull ProblemsHolder holder) {
        PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (methodName != null && KNOWN_METHOD_NAMES.contains(methodName)) {
            PsiMethod method = callExpression.resolveMethod();
            if (method != null && JavaReflectionReferenceUtil.isClassWithName(method.getContainingClass(), "java.lang.invoke.MethodHandles.Lookup")) {
                PsiExpression[] arguments = callExpression.getArgumentList().getExpressions();
                JavaLangInvokeHandleSignatureInspection.checkHandleFactory(methodName, methodExpression, arguments, holder);
            }
            return true;
        }
        if (JavaReflectionReferenceUtil.isCallToMethod(callExpression, "java.lang.invoke.MethodHandles", "arrayElementVarHandle")) {
            JavaLangInvokeHandleSignatureInspection.checkArrayElementVarHandle(callExpression, holder);
            return true;
        }
        return false;
    }

    private static void checkHandleFactory(@NotNull String factoryMethodName, @NotNull PsiReferenceExpression factoryMethodExpression, PsiExpression @NotNull [] arguments, @NotNull ProblemsHolder holder) {
        PsiExpression nameExpression;
        PsiExpression nameDefinition;
        String memberName;
        JavaReflectionReferenceUtil.ReflectiveClass ownerClass;
        if (arguments.length == 2) {
            JavaReflectionReferenceUtil.ReflectiveClass ownerClass2;
            if ("findConstructor".equals(factoryMethodName) && (ownerClass2 = JavaReflectionReferenceUtil.getReflectiveClass(arguments[0])) != null) {
                PsiExpression typeExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)arguments[1]);
                JavaLangInvokeHandleSignatureInspection.checkConstructor(ownerClass2, typeExpression, holder);
            }
        } else if (arguments.length >= 3 && (ownerClass = JavaReflectionReferenceUtil.getReflectiveClass(arguments[0])) != null && !StringUtil.isEmpty((String)(memberName = JavaReflectionReferenceUtil.computeConstantExpression(nameDefinition = JavaReflectionReferenceUtil.findDefinition(nameExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)arguments[1])), String.class)))) {
            PsiExpression typeExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)arguments[2]);
            switch (factoryMethodName) {
                case "findGetter": 
                case "findSetter": 
                case "findVarHandle": {
                    JavaLangInvokeHandleSignatureInspection.checkField(ownerClass, memberName, nameExpression, typeExpression, false, factoryMethodExpression, holder);
                    break;
                }
                case "findStaticGetter": 
                case "findStaticSetter": 
                case "findStaticVarHandle": {
                    JavaLangInvokeHandleSignatureInspection.checkField(ownerClass, memberName, nameExpression, typeExpression, true, factoryMethodExpression, holder);
                    break;
                }
                case "findVirtual": {
                    JavaLangInvokeHandleSignatureInspection.checkMethod(ownerClass, memberName, nameExpression, typeExpression, false, true, factoryMethodExpression, holder);
                    break;
                }
                case "findStatic": {
                    JavaLangInvokeHandleSignatureInspection.checkMethod(ownerClass, memberName, nameExpression, typeExpression, true, true, factoryMethodExpression, holder);
                    break;
                }
                case "findSpecial": {
                    JavaLangInvokeHandleSignatureInspection.checkMethod(ownerClass, memberName, nameExpression, typeExpression, false, false, factoryMethodExpression, holder);
                    if (arguments.length <= 3) break;
                    JavaLangInvokeHandleSignatureInspection.checkSpecial(ownerClass, arguments[3], holder);
                }
            }
        }
    }

    private static void checkConstructor(@NotNull JavaReflectionReferenceUtil.ReflectiveClass ownerClass, @NotNull PsiExpression constructorTypeExpression, @NotNull ProblemsHolder holder) {
        if (!ownerClass.isExact()) {
            return;
        }
        JavaReflectionReferenceUtil.ReflectiveSignature constructorSignature = JavaReflectionReferenceUtil.composeMethodSignature(constructorTypeExpression);
        if (constructorSignature != null) {
            String declarationText;
            List constructors = ContainerUtil.filter((Object[])ownerClass.getPsiClass().getMethods(), PsiMethod::isConstructor);
            List<JavaReflectionReferenceUtil.ReflectiveSignature> validSignatures = null;
            if (constructors.isEmpty()) {
                if (!constructorSignature.equals(JavaReflectionReferenceUtil.ReflectiveSignature.NO_ARGUMENT_CONSTRUCTOR_SIGNATURE)) {
                    validSignatures = Collections.singletonList(JavaReflectionReferenceUtil.ReflectiveSignature.NO_ARGUMENT_CONSTRUCTOR_SIGNATURE);
                }
            } else if (JavaLangInvokeHandleSignatureInspection.findMethodBySignature(constructors, constructorSignature).isEmpty()) {
                validSignatures = constructors.stream().map(JavaReflectionReferenceUtil::getMethodSignature).filter(Objects::nonNull).collect(Collectors.toList());
            }
            if (validSignatures != null && (declarationText = JavaLangInvokeHandleSignatureInspection.getConstructorDeclarationText(ownerClass, constructorSignature)) != null) {
                LocalQuickFix fix = null;
                String ownerClassName = ownerClass.getPsiClass().getName();
                if (ownerClassName != null) {
                    fix = ReplaceSignatureQuickFix.createFix((PsiElement)constructorTypeExpression, ownerClassName, validSignatures, true, holder.isOnTheFly());
                }
                holder.registerProblem((PsiElement)constructorTypeExpression, JavaErrorBundle.message("cannot.resolve.constructor", declarationText), new LocalQuickFix[]{fix});
            }
        }
    }

    private static void checkField(@NotNull JavaReflectionReferenceUtil.ReflectiveClass ownerClass, @NotNull String fieldName, @NotNull PsiExpression fieldNameExpression, @NotNull PsiExpression fieldTypeExpression, boolean isStaticExpected, @NotNull PsiReferenceExpression factoryMethodExpression, @NotNull ProblemsHolder holder) {
        JavaReflectionReferenceUtil.ReflectiveType reflectiveType;
        if (!ownerClass.isExact()) {
            return;
        }
        PsiField field = ownerClass.getPsiClass().findFieldByName(fieldName, true);
        if (field == null) {
            holder.registerProblem((PsiElement)fieldNameExpression, JavaBundle.message((String)"inspection.handle.signature.field.cannot.resolve", (Object[])new Object[]{fieldName}), new LocalQuickFix[0]);
            return;
        }
        if (field.hasModifierProperty("static") != isStaticExpected) {
            String factoryMethodName = factoryMethodExpression.getReferenceName();
            PsiElement factoryMethodNameElement = factoryMethodExpression.getReferenceNameElement();
            if (factoryMethodName != null && factoryMethodNameElement != null) {
                LocalQuickFix fix = SwitchStaticnessQuickFix.createFix(factoryMethodName, isStaticExpected);
                String message2 = JavaBundle.message((String)(isStaticExpected ? "inspection.handle.signature.field.not.static" : "inspection.handle.signature.field.static"), (Object[])new Object[]{fieldName});
                holder.registerProblem(factoryMethodNameElement, message2, new LocalQuickFix[]{fix});
                return;
            }
        }
        if ((reflectiveType = JavaReflectionReferenceUtil.getReflectiveType(fieldTypeExpression)) != null && !reflectiveType.isEqualTo(field.getType())) {
            String expectedTypeText = JavaReflectionReferenceUtil.getTypeText(field.getType());
            String message3 = JavaBundle.message((String)"inspection.handle.signature.field.type", (Object[])new Object[]{fieldName, expectedTypeText});
            holder.registerProblem((PsiElement)fieldTypeExpression, message3, new LocalQuickFix[]{new FieldTypeQuickFix(expectedTypeText)});
        }
    }

    private static void checkMethod(@NotNull JavaReflectionReferenceUtil.ReflectiveClass ownerClass, @NotNull String methodName, @NotNull PsiExpression methodNameExpression, @NotNull PsiExpression methodTypeExpression, boolean isStaticExpected, boolean isAbstractAllowed, @NotNull PsiReferenceExpression factoryMethodExpression, @NotNull ProblemsHolder holder) {
        String className2;
        boolean allAbstract;
        JavaReflectionReferenceUtil.ReflectiveSignature methodSignature;
        if (!ownerClass.isExact()) {
            return;
        }
        Object[] methods = ownerClass.getPsiClass().findMethodsByName(methodName, true);
        if (methods.length == 0) {
            holder.registerProblem((PsiElement)methodNameExpression, JavaErrorBundle.message("cannot.resolve.method", methodName), new LocalQuickFix[0]);
            return;
        }
        List filteredMethods = ContainerUtil.filter((Object[])methods, method -> method.hasModifierProperty("static") == isStaticExpected);
        if (filteredMethods.isEmpty()) {
            String factoryMethodName = factoryMethodExpression.getReferenceName();
            PsiElement factoryMethodNameElement = factoryMethodExpression.getReferenceNameElement();
            if (factoryMethodName != null && factoryMethodNameElement != null) {
                LocalQuickFix fix = SwitchStaticnessQuickFix.createFix(factoryMethodName, isStaticExpected);
                String message2 = JavaBundle.message((String)(isStaticExpected ? "inspection.handle.signature.method.not.static" : "inspection.handle.signature.method.static"), (Object[])new Object[]{methodName});
                holder.registerProblem(factoryMethodNameElement, message2, new LocalQuickFix[]{fix});
                return;
            }
        }
        if ((methodSignature = JavaReflectionReferenceUtil.composeMethodSignature(methodTypeExpression)) == null) {
            return;
        }
        List<PsiMethod> matchingMethods = JavaLangInvokeHandleSignatureInspection.findMethodBySignature(filteredMethods, methodSignature);
        if (matchingMethods.isEmpty()) {
            String declarationText = JavaLangInvokeHandleSignatureInspection.getMethodDeclarationText(methodName, methodSignature);
            List validSignatures = filteredMethods.stream().map(JavaReflectionReferenceUtil::getMethodSignature).filter(Objects::nonNull).collect(Collectors.toList());
            LocalQuickFix fix = ReplaceSignatureQuickFix.createFix((PsiElement)methodTypeExpression, methodName, validSignatures, false, holder.isOnTheFly());
            holder.registerProblem((PsiElement)methodTypeExpression, JavaErrorBundle.message("cannot.resolve.method", declarationText), new LocalQuickFix[]{fix});
            return;
        }
        if (!isAbstractAllowed && (allAbstract = matchingMethods.stream().allMatch(method -> method.hasModifierProperty("abstract"))) && (className2 = ownerClass.getPsiClass().getQualifiedName()) != null) {
            holder.registerProblem((PsiElement)methodNameExpression, JavaBundle.message((String)"inspection.handle.signature.method.abstract", (Object[])new Object[]{methodName, className2}), new LocalQuickFix[0]);
        }
    }

    private static void checkSpecial(@NotNull JavaReflectionReferenceUtil.ReflectiveClass ownerClass, @NotNull PsiExpression callerClassExpression, @NotNull ProblemsHolder holder) {
        PsiClass owner2;
        PsiClass caller;
        JavaReflectionReferenceUtil.ReflectiveClass callerClass = JavaReflectionReferenceUtil.getReflectiveClass(callerClassExpression);
        if (callerClass != null && callerClass.isExact() && !InheritanceUtil.isInheritorOrSelf((PsiClass)(caller = callerClass.getPsiClass()), (PsiClass)(owner2 = ownerClass.getPsiClass()), (boolean)true)) {
            String callerName = caller.getQualifiedName();
            String ownerName = owner2.getQualifiedName();
            if (callerName != null && ownerName != null) {
                holder.registerProblem((PsiElement)callerClassExpression, JavaBundle.message((String)"inspection.handle.signature.not.subclass", (Object[])new Object[]{callerName, ownerName}), new LocalQuickFix[0]);
            }
        }
    }

    private static void checkArrayElementVarHandle(PsiMethodCallExpression factoryCallExpression, ProblemsHolder holder) {
        String name2;
        PsiExpressionList argumentList = factoryCallExpression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length != 1) {
            holder.registerProblem((PsiElement)argumentList, JavaBundle.message((String)"inspection.reflection.invocation.argument.count", (Object[])new Object[]{1}), new LocalQuickFix[0]);
            return;
        }
        JavaReflectionReferenceUtil.ReflectiveType argumentType = JavaReflectionReferenceUtil.getReflectiveType(arguments[0]);
        if (argumentType == null || argumentType.getType() instanceof PsiArrayType) {
            return;
        }
        if (!argumentType.isPrimitive() && !argumentType.isExact() && ("java.lang.Object".equals(name2 = argumentType.getQualifiedName()) || "java.io.Serializable".equals(name2) || "java.lang.Cloneable".equals(name2))) {
            return;
        }
        holder.registerProblem((PsiElement)arguments[0], JavaBundle.message((String)"inspection.reflect.handle.invocation.argument.not.array", (Object[])new Object[0]), new LocalQuickFix[0]);
    }

    @NotNull
    private static String getMethodDeclarationText(@NotNull String methodName, @NotNull JavaReflectionReferenceUtil.ReflectiveSignature methodSignature) {
        String returnType = methodSignature.getShortReturnType();
        return returnType + " " + methodName + methodSignature.getShortArgumentTypes();
    }

    @Nullable
    private static String getConstructorDeclarationText(@NotNull JavaReflectionReferenceUtil.ReflectiveClass ownerClass, @NotNull JavaReflectionReferenceUtil.ReflectiveSignature methodSignature) {
        String className2 = ownerClass.getPsiClass().getName();
        if (className2 != null) {
            return JavaLangInvokeHandleSignatureInspection.getConstructorDeclarationText(className2, methodSignature);
        }
        return null;
    }

    @NotNull
    private static String getConstructorDeclarationText(@NotNull String className2, @NotNull JavaReflectionReferenceUtil.ReflectiveSignature methodSignature) {
        String returnType = methodSignature.getShortReturnType();
        String fakeReturnType = !"void".equals(returnType) ? returnType + " " : "";
        return fakeReturnType + className2 + methodSignature.getShortArgumentTypes();
    }

    @NotNull
    private static List<PsiMethod> findMethodBySignature(@NotNull List<? extends PsiMethod> methods, @NotNull JavaReflectionReferenceUtil.ReflectiveSignature expectedMethodSignature) {
        return ContainerUtil.filter(methods, method -> expectedMethodSignature.equals(JavaReflectionReferenceUtil.getMethodSignature(method)));
    }

    private static class ReplaceSignatureQuickFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private final String myName;
        private final List<? extends JavaReflectionReferenceUtil.ReflectiveSignature> mySignatures;
        private final boolean myIsConstructor;

        ReplaceSignatureQuickFix(@Nullable PsiElement element, @NotNull String name2, @NotNull List<? extends JavaReflectionReferenceUtil.ReflectiveSignature> signatures, boolean isConstructor) {
            super(element);
            this.myName = name2;
            this.mySignatures = signatures;
            this.myIsConstructor = isConstructor;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return this.getText();
        }

        @NotNull
        public String getText() {
            if (this.mySignatures.size() == 1) {
                String declarationText = this.getDeclarationText(this.mySignatures.get(0));
                return JavaBundle.message((String)(this.myIsConstructor ? "inspection.handle.signature.use.constructor.fix.name" : "inspection.handle.signature.use.method.fix.name"), (Object[])new Object[]{declarationText});
            }
            return JavaBundle.message((String)(this.myIsConstructor ? "inspection.handle.signature.use.constructor.fix.family.name" : "inspection.handle.signature.use.method.fix.family.name"), (Object[])new Object[0]);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                PsiElement element = this.myStartElement.getElement();
                if (editor != null && element != null) {
                    JavaReflectionReferenceUtil.ReflectiveSignature signature = (JavaReflectionReferenceUtil.ReflectiveSignature)editor.getUserData(DEFAULT_SIGNATURE);
                    if (signature != null && this.mySignatures.contains(signature)) {
                        ReplaceSignatureQuickFix.applyFix(project, element, signature);
                    }
                    editor.putUserData(POSSIBLE_SIGNATURES, this.createLookupElements());
                }
                return;
            }
            if (this.mySignatures.size() == 1) {
                ReplaceSignatureQuickFix.applyFix(project, startElement, this.mySignatures.get(0));
            } else if (editor != null) {
                this.showLookup(project, editor);
            }
        }

        @NotNull
        private List<LookupElement> createLookupElements() {
            return this.mySignatures.stream().sorted(JavaReflectionReferenceUtil.ReflectiveSignature::compareTo).map(signature -> LookupElementBuilder.create((Object)signature, (String)"").withIcon(signature.getIcon()).withPresentableText(this.myName + signature.getShortArgumentTypes()).withTypeText(!this.myIsConstructor ? signature.getShortReturnType() : null)).collect(Collectors.toList());
        }

        private void showLookup(final @NotNull Project project, @NotNull Editor editor) {
            editor.getSelectionModel().removeSelection();
            List<LookupElement> items = this.createLookupElements();
            LookupManager lookupManager = LookupManager.getInstance((Project)project);
            LookupEx lookup = lookupManager.showLookup(editor, items.toArray(LookupElement.EMPTY_ARRAY));
            if (lookup != null) {
                lookup.addLookupListener(new LookupListener(){

                    public void itemSelected(@NotNull LookupEvent event) {
                        LookupElement item = event.getItem();
                        if (item != null) {
                            PsiElement element = myStartElement.getElement();
                            Object object = item.getObject();
                            if (element != null && object instanceof JavaReflectionReferenceUtil.ReflectiveSignature) {
                                WriteAction.run(() -> ReplaceSignatureQuickFix.applyFix(project, element, (JavaReflectionReferenceUtil.ReflectiveSignature)object));
                            }
                        }
                    }
                });
            }
        }

        private static void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull JavaReflectionReferenceUtil.ReflectiveSignature signature) {
            String replacementText = JavaReflectionReferenceUtil.getMethodTypeExpressionText(signature);
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiExpression replacement = factory.createExpressionFromText(replacementText, element);
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
            styleManager.shortenClassReferences(element.replace((PsiElement)replacement));
        }

        @NotNull
        private String getDeclarationText(@NotNull JavaReflectionReferenceUtil.ReflectiveSignature signature) {
            return this.myIsConstructor ? JavaLangInvokeHandleSignatureInspection.getConstructorDeclarationText(this.myName, signature) : JavaLangInvokeHandleSignatureInspection.getMethodDeclarationText(this.myName, signature);
        }

        @Nullable
        private static LocalQuickFix createFix(@Nullable PsiElement element, @NotNull String methodName, @NotNull List<? extends JavaReflectionReferenceUtil.ReflectiveSignature> methodSignatures, boolean isConstructor, boolean isOnTheFly) {
            if (isOnTheFly && !methodSignatures.isEmpty() || methodSignatures.size() == 1) {
                return new ReplaceSignatureQuickFix(element, methodName, methodSignatures, isConstructor);
            }
            return null;
        }
    }

    private static class SwitchStaticnessQuickFix
    implements LocalQuickFix {
        private static final Map<String, String> STATIC_TO_NON_STATIC = ContainerUtil.immutableMapBuilder().put((Object)"findStaticGetter", (Object)"findGetter").put((Object)"findStaticSetter", (Object)"findSetter").put((Object)"findStaticVarHandle", (Object)"findVarHandle").put((Object)"findStatic", (Object)"findVirtual").build();
        private static final Map<String, String> NON_STATIC_TO_STATIC = ContainerUtil.immutableMapBuilder().put((Object)"findGetter", (Object)"findStaticGetter").put((Object)"findSetter", (Object)"findStaticSetter").put((Object)"findVarHandle", (Object)"findStaticVarHandle").put((Object)"findVirtual", (Object)"findStatic").build();
        private final String myReplacementName;

        SwitchStaticnessQuickFix(@NotNull String replacementName) {
            this.myReplacementName = replacementName;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"inspection.handle.signature.replace.with.fix.name", (Object[])new Object[]{this.myReplacementName});
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiIdentifier identifier = factory.createIdentifier(this.myReplacementName);
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
            styleManager.shortenClassReferences(element.replace((PsiElement)identifier));
        }

        @Nullable
        public static LocalQuickFix createFix(@NotNull String methodName, boolean wasStatic) {
            String replacementName = wasStatic ? STATIC_TO_NON_STATIC.get(methodName) : NON_STATIC_TO_STATIC.get(methodName);
            return replacementName != null ? new SwitchStaticnessQuickFix(replacementName) : null;
        }
    }

    private static class FieldTypeQuickFix
    implements LocalQuickFix {
        private final String myFieldTypeText;

        FieldTypeQuickFix(String fieldTypeText) {
            this.myFieldTypeText = fieldTypeText;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"inspection.handle.signature.change.type.fix.name", (Object[])new Object[]{this.myFieldTypeText});
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiExpression typeExpression = factory.createExpressionFromText(this.myFieldTypeText + ".class", element);
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
            styleManager.shortenClassReferences(element.replace((PsiElement)typeExpression));
        }
    }

    private static interface CallChecker {
        public boolean checkCall(@NotNull PsiMethodCallExpression var1, @NotNull ProblemsHolder var2);
    }
}

