/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.optionalToIf;

import com.intellij.codeInspection.optionalToIf.Operation;
import com.intellij.codeInspection.optionalToIf.OptionalToIfContext;
import com.intellij.codeInspection.streamToLoop.ChainVariable;
import com.intellij.codeInspection.streamToLoop.FunctionHelper;
import com.intellij.psi.PsiExpression;
import com.siyeh.ig.psiutils.SideEffectChecker;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class TerminalOperation
implements Operation {
    TerminalOperation() {
    }

    @Override
    @NotNull
    public ChainVariable getOutVar(@NotNull ChainVariable inVar) {
        return inVar;
    }

    @Nullable
    static TerminalOperation create(String name2, PsiExpression[] args) {
        if ("get".equals(name2) && args.length == 0) {
            return new Get();
        }
        if ("orElse".equals(name2) && args.length == 1) {
            return new OrElse(args[0].getText());
        }
        if ("ifPresentOrElse".equals(name2) && args.length == 2) {
            FunctionHelper ifPresentFn = FunctionHelper.create(args[0], 1);
            if (ifPresentFn == null) {
                return null;
            }
            FunctionHelper orElseFn = FunctionHelper.create(args[1], 0);
            return orElseFn == null ? null : new IfPresentOrElse(ifPresentFn, orElseFn);
        }
        if ("ifPresent".equals(name2) && args.length == 1) {
            FunctionHelper fn = FunctionHelper.create(args[0], 1);
            return fn == null ? null : new IfPresent(fn);
        }
        if (("isPresent".equals(name2) || "isEmpty".equals(name2)) && args.length == 0) {
            return new IsPresent("isEmpty".equals(name2));
        }
        if ("orElseGet".equals(name2) && args.length == 1) {
            FunctionHelper myFn = FunctionHelper.create(args[0], 0);
            return myFn == null ? null : new OrElseGet(myFn);
        }
        if ("orElseThrow".equals(name2)) {
            if (args.length == 0) {
                return new OrElseThrow(null);
            }
            FunctionHelper myFn = args.length == 1 ? FunctionHelper.create(args[0], 0) : null;
            return myFn == null ? null : new OrElseThrow(myFn);
        }
        if ("stream".equals(name2) && args.length == 0) {
            return new Stream();
        }
        return null;
    }

    static class Stream
    extends TerminalOperation {
        Stream() {
        }

        @Override
        @Nullable
        public String generate(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull String code, @NotNull OptionalToIfContext context) {
            context.setInitializer("java.util.stream.Stream.empty()");
            return context.createResult("java.util.stream.Stream.of(" + outVar.getName() + ")");
        }
    }

    static class OrElseThrow
    extends TerminalOperation {
        private final FunctionHelper myFn;

        OrElseThrow(FunctionHelper fn) {
            this.myFn = fn;
        }

        @Override
        @Nullable
        public String generate(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull String code, @NotNull OptionalToIfContext context) {
            if (this.myFn == null) {
                context.setElseBranch("throw new java.util.NoSuchElementException(\"No value present\");");
            } else {
                this.myFn.transform(context, new String[0]);
                context.setElseBranch("throw " + this.myFn.getStatementText());
            }
            return context.createResult(outVar.getName());
        }
    }

    static class OrElseGet
    extends TerminalOperation {
        private final FunctionHelper myFn;

        OrElseGet(FunctionHelper fn) {
            this.myFn = fn;
        }

        @Override
        @NotNull
        public ChainVariable getOutVar(@NotNull ChainVariable inVar) {
            return new ChainVariable(inVar.getType());
        }

        @Override
        public void preprocessVariables(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull OptionalToIfContext context) {
            outVar.addBestNameCandidate("result");
        }

        @Override
        @Nullable
        public String generate(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull String code, @NotNull OptionalToIfContext context) {
            this.myFn.transform(context, new String[0]);
            if (!SideEffectChecker.mayHaveSideEffects(this.myFn.getExpression())) {
                context.setInitializer(this.myFn.getText());
                return context.createResult(inVar.getName());
            }
            context.addBeforeStep(outVar.getDeclaration("null"));
            context.addAfterStep("if(" + outVar.getName() + "==null){\n" + outVar.getName() + "=" + this.myFn.getStatementText() + "\n}" + context.createResult(outVar.getName()));
            return outVar.getName() + "=" + inVar.getName() + ";";
        }
    }

    static class IsPresent
    extends TerminalOperation {
        private final boolean myIsInverted;

        IsPresent(boolean isInverted) {
            this.myIsInverted = isInverted;
        }

        @Override
        @Nullable
        public String generate(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull String code, @NotNull OptionalToIfContext context) {
            context.setInitializer(String.valueOf(this.myIsInverted));
            return context.createResult(String.valueOf(!this.myIsInverted));
        }
    }

    static class IfPresentOrElse
    extends TerminalOperation {
        private final FunctionHelper myIfPresentFn;
        private final FunctionHelper myElseFn;

        @Contract(pure=true)
        IfPresentOrElse(FunctionHelper ifPresentFn, FunctionHelper elseFn) {
            this.myIfPresentFn = ifPresentFn;
            this.myElseFn = elseFn;
        }

        @Override
        public void preprocessVariables(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull OptionalToIfContext context) {
            this.myIfPresentFn.preprocessVariable(context, outVar, 0);
            outVar.addBestNameCandidate("result");
        }

        @Override
        @NotNull
        public ChainVariable getOutVar(@NotNull ChainVariable inVar) {
            return new ChainVariable(inVar.getType());
        }

        @Override
        @Nullable
        public String generate(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull String code, @NotNull OptionalToIfContext context) {
            this.myElseFn.transform(context, new String[0]);
            this.myIfPresentFn.transform(context, outVar.getName());
            context.addBeforeStep(outVar.getDeclaration("null"));
            context.addAfterStep("if(" + outVar.getName() + "==null){\n{\n" + this.myElseFn.getStatementText() + "\n}}else{\n{\n" + this.myIfPresentFn.getStatementText() + "\n}}\n");
            return outVar.getName() + "=" + inVar.getName() + ";";
        }
    }

    static class IfPresent
    extends TerminalOperation {
        private final FunctionHelper myFn;

        IfPresent(FunctionHelper fn) {
            this.myFn = fn;
        }

        @Override
        public void preprocessVariables(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull OptionalToIfContext context) {
            this.myFn.preprocessVariable(context, inVar, 0);
        }

        @Override
        @Nullable
        public String generate(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull String code, @NotNull OptionalToIfContext context) {
            this.myFn.transform(context, inVar.getName());
            return "{\n" + this.myFn.getStatementText() + "\n}\n";
        }
    }

    static class OrElse
    extends TerminalOperation {
        private final String myArg;

        @Contract(pure=true)
        OrElse(String arg) {
            this.myArg = arg;
        }

        @Override
        @Nullable
        public String generate(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull String code, @NotNull OptionalToIfContext context) {
            context.setInitializer(this.myArg);
            return context.createResult(outVar.getName());
        }
    }

    static class Get
    extends TerminalOperation {
        Get() {
        }

        @Override
        @Nullable
        public String generate(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull String code, @NotNull OptionalToIfContext context) {
            context.setElseBranch("throw new java.util.NoSuchElementException(\"No value present\");");
            return context.createResult(outVar.getName());
        }
    }
}

