/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.optionalToIf;

import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.optionalToIf.Instruction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiVariable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

interface Simplifier {
    public static final Simplifier[] SIMPLIFIERS = new Simplifier[]{new RemoveChecks(), new MergeChecks(), new RemoveAfterReturnOrThrow(), new MergeImmediateReturn(), new MergeImmediateAssignment()};

    public List<Instruction> run(@NotNull List<Instruction> var1);

    @NotNull
    public static String simplify(@NotNull List<Instruction> instructions) {
        return ((List)StreamEx.of((Object[])SIMPLIFIERS).foldLeft(instructions, (acc, s) -> s.run((List<Instruction>)acc))).stream().map(Instruction::generate).collect(Collectors.joining());
    }

    public static class MergeImmediateAssignment
    implements Simplifier {
        @Override
        public List<Instruction> run(@NotNull List<Instruction> instructions) {
            ArrayList<Instruction> simplified = new ArrayList<Instruction>();
            Instruction prev = null;
            for (Instruction instruction : instructions) {
                Instruction.Assignment assignment = (Instruction.Assignment)ObjectUtils.tryCast((Object)instruction, Instruction.Assignment.class);
                if (assignment != null) {
                    Instruction.Declaration declaration2 = (Instruction.Declaration)ObjectUtils.tryCast(prev, Instruction.Declaration.class);
                    if (declaration2 != null && declaration2.myLhs == assignment.myLhs) {
                        Instruction.Declaration merged = new Instruction.Declaration(declaration2.myLhs, assignment.myRhs);
                        simplified.set(simplified.size() - 1, merged);
                        prev = merged;
                        continue;
                    }
                } else {
                    Instruction.Check check = (Instruction.Check)ObjectUtils.tryCast((Object)instruction, Instruction.Check.class);
                    if (check != null && !check.hasElseBranch()) {
                        check.myInstructions = this.run(check.myInstructions);
                    }
                }
                simplified.add(instruction);
                prev = instruction;
            }
            return simplified;
        }
    }

    public static class MergeImmediateReturn
    implements Simplifier {
        @Override
        public List<Instruction> run(@NotNull List<Instruction> instructions) {
            ArrayList<Instruction> simplified = new ArrayList<Instruction>();
            Instruction prev = null;
            for (Instruction instruction : instructions) {
                Instruction.Return ret = (Instruction.Return)ObjectUtils.tryCast((Object)instruction, Instruction.Return.class);
                if (ret != null) {
                    Instruction.Return merged = this.mergeReturn(ret, prev);
                    if (merged != null) {
                        simplified.set(simplified.size() - 1, merged);
                        prev = merged;
                        continue;
                    }
                } else {
                    Instruction.Check check = (Instruction.Check)ObjectUtils.tryCast((Object)instruction, Instruction.Check.class);
                    if (check != null && !check.hasElseBranch()) {
                        check.myInstructions = this.run(check.myInstructions);
                    }
                }
                simplified.add(instruction);
                prev = instruction;
            }
            return simplified;
        }

        @Nullable
        private Instruction.Return mergeReturn(@NotNull Instruction.Return ret, @Nullable Instruction prev) {
            PsiVariable retVariable = this.getReturnVariable(ret);
            if (retVariable == null) {
                return null;
            }
            Instruction.Declaration declaration2 = (Instruction.Declaration)ObjectUtils.tryCast((Object)prev, Instruction.Declaration.class);
            if (declaration2 != null) {
                return MergeImmediateReturn.mergeReturn(retVariable, declaration2.myLhs, declaration2.myRhs);
            }
            Instruction.Assignment assignment = (Instruction.Assignment)ObjectUtils.tryCast((Object)prev, Instruction.Assignment.class);
            if (assignment != null) {
                return MergeImmediateReturn.mergeReturn(retVariable, assignment.myLhs, assignment.myRhs);
            }
            return null;
        }

        @Nullable
        PsiVariable getReturnVariable(@NotNull Instruction.Return ret) {
            PsiReference reference = (PsiReference)ObjectUtils.tryCast((Object)ret.myExpression, PsiReference.class);
            if (reference == null) {
                return null;
            }
            return (PsiVariable)ObjectUtils.tryCast((Object)reference.resolve(), PsiVariable.class);
        }

        @Nullable
        @Contract(pure=true)
        private static Instruction.Return mergeReturn(@NotNull PsiVariable retVariable, @NotNull PsiVariable lhs, @NotNull PsiExpression rhs) {
            return retVariable != lhs ? null : new Instruction.Return(rhs);
        }
    }

    public static class RemoveAfterReturnOrThrow
    implements Simplifier {
        @Override
        public List<Instruction> run(@NotNull List<Instruction> instructions) {
            ArrayList<Instruction> simplified = new ArrayList<Instruction>();
            for (Instruction instruction : instructions) {
                Instruction.Check check = (Instruction.Check)ObjectUtils.tryCast((Object)instruction, Instruction.Check.class);
                if (check != null && !check.hasElseBranch()) {
                    check.myInstructions = this.run(check.myInstructions);
                }
                simplified.add(instruction);
                if (!(instruction instanceof Instruction.Return) && !(instruction instanceof Instruction.Throw)) continue;
                return simplified;
            }
            return simplified;
        }
    }

    public static class MergeChecks
    implements Simplifier {
        @Override
        @NotNull
        public List<Instruction> run(@NotNull List<Instruction> instructions) {
            ArrayList<Instruction> simplified = new ArrayList<Instruction>();
            Instruction prev = null;
            for (Instruction instruction : instructions) {
                Instruction.Check check = (Instruction.Check)ObjectUtils.tryCast((Object)instruction, Instruction.Check.class);
                if (check != null && !check.hasElseBranch()) {
                    Instruction.Check merged;
                    check.myInstructions = this.run(check.myInstructions);
                    check = MergeChecks.mergeWithInner(check);
                    instruction = check;
                    Instruction.Check prevCheck = (Instruction.Check)ObjectUtils.tryCast((Object)prev, Instruction.Check.class);
                    if (prevCheck != null && !prevCheck.hasElseBranch() && (merged = MergeChecks.mergeChecks(prevCheck, check)) != null) {
                        prev = merged;
                        simplified.set(simplified.size() - 1, prev);
                        continue;
                    }
                }
                prev = instruction;
                simplified.add(instruction);
            }
            return simplified;
        }

        @NotNull
        private static Instruction.Check mergeWithInner(@NotNull Instruction.Check check) {
            Instruction.Check innerCheck = (Instruction.Check)ObjectUtils.tryCast((Object)MergeChecks.getSingleInstruction(check), Instruction.Check.class);
            if (innerCheck == null) {
                return check;
            }
            List<Instruction> checkInstructions = innerCheck.myInstructions;
            PsiExpression conjunction = MergeChecks.mergeConditions(check, innerCheck, "&&");
            return new Instruction.Check(conjunction, checkInstructions, null);
        }

        @NotNull
        private static PsiExpression mergeConditions(@NotNull Instruction.Check c1, @NotNull Instruction.Check c2, @NotNull String operator2) {
            PsiExpression cond1 = c1.myCondition;
            PsiExpression cond2 = c2.myCondition;
            PsiElementFactory factory = PsiElementFactory.getInstance((Project)cond1.getProject());
            return factory.createExpressionFromText(ParenthesesUtils.getText(cond1, 14) + operator2 + ParenthesesUtils.getText(cond2, 14), (PsiElement)cond1);
        }

        @Nullable
        private static Instruction.Check mergeChecks(@NotNull Instruction prev, @NotNull Instruction.Check check) {
            Instruction.Check prevCheck = (Instruction.Check)ObjectUtils.tryCast((Object)prev, Instruction.Check.class);
            if (prevCheck == null) {
                return null;
            }
            Instruction.Throw prevThrow = (Instruction.Throw)ObjectUtils.tryCast((Object)MergeChecks.getSingleInstruction(prevCheck), Instruction.Throw.class);
            if (prevThrow == null) {
                return null;
            }
            Instruction.Throw curThrow = (Instruction.Throw)ObjectUtils.tryCast((Object)MergeChecks.getSingleInstruction(check), Instruction.Throw.class);
            if (curThrow == null) {
                return null;
            }
            boolean isSameException = EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(prevThrow.myException, curThrow.myException);
            if (!isSameException) {
                return null;
            }
            PsiExpression disjunction = MergeChecks.mergeConditions(prevCheck, check, "||");
            return new Instruction.Check(disjunction, check.myInstructions, null);
        }

        private static Instruction getSingleInstruction(@NotNull Instruction.Check check) {
            return (Instruction)ContainerUtil.getOnlyItem(check.myInstructions);
        }
    }

    public static class RemoveChecks
    implements Simplifier {
        @Override
        public List<Instruction> run(@NotNull List<Instruction> instructions) {
            ArrayList<Instruction> simplified = new ArrayList<Instruction>();
            for (Instruction instruction : instructions) {
                Instruction.Check check = (Instruction.Check)ObjectUtils.tryCast((Object)instruction, Instruction.Check.class);
                if (check != null && !check.hasElseBranch()) {
                    Boolean res;
                    Boolean bl = res = check.myInstructions.isEmpty() ? Boolean.FALSE : DfaUtil.evaluateCondition(check.myCondition);
                    if (Boolean.FALSE.equals(res)) continue;
                    check.myInstructions = this.run(check.myInstructions);
                    if (check.myInstructions.isEmpty() || Boolean.TRUE.equals(res)) {
                        simplified.addAll(check.myInstructions);
                        continue;
                    }
                }
                simplified.add(instruction);
            }
            return simplified;
        }
    }
}

