/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.numeric;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import org.jetbrains.annotations.NotNull;

final class ConvertNumericLiteralQuickFix
implements LocalQuickFix {
    @NotNull
    private final String myConvertedValue;
    @NotNull
    private final @IntentionName String myName;
    @NotNull
    private final @IntentionFamilyName String myFamilyName;

    ConvertNumericLiteralQuickFix(@NotNull String convertedValue, @NotNull @IntentionName String name2, @NotNull @IntentionFamilyName String familyName) {
        this.myConvertedValue = convertedValue;
        this.myName = name2;
        this.myFamilyName = familyName;
    }

    public @IntentionFamilyName @NotNull String getFamilyName() {
        return this.myFamilyName;
    }

    public @IntentionName @NotNull String getName() {
        return this.myName;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        if (element == null) {
            return;
        }
        PsiExpression replacement = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(this.myConvertedValue, null);
        element.replace((PsiElement)replacement);
    }
}

