/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.nullable;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ChangeNullableDefaultsFix
implements LocalQuickFix {
    private final NullableNotNullManager myManager;
    private final String myNotNullName;
    private final String myNullableName;

    ChangeNullableDefaultsFix(@Nullable PsiAnnotation notNull, @Nullable PsiAnnotation nullable, @NotNull NullableNotNullManager manager) {
        this.myNotNullName = notNull != null ? notNull.getQualifiedName() : null;
        this.myNullableName = nullable != null ? nullable.getQualifiedName() : null;
        this.myManager = manager;
    }

    ChangeNullableDefaultsFix(String notNull, String nullable, NullableNotNullManager manager) {
        this.myManager = manager;
        this.myNotNullName = notNull;
        this.myNullableName = nullable;
    }

    @NotNull
    public String getFamilyName() {
        return JavaAnalysisBundle.message((String)"make.0.default.annotation", (Object[])new Object[]{this.myNotNullName != null ? this.myNotNullName : this.myNullableName});
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (this.myNotNullName != null) {
            this.myManager.setDefaultNotNull(this.myNotNullName);
        } else {
            this.myManager.setDefaultNullable(this.myNullableName);
        }
    }
}

