/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.miscGenerics;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.miscGenerics.SuspiciousMethodCallUtil;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuspiciousCollectionsMethodCallsInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean REPORT_CONVERTIBLE_METHOD_CALLS = true;

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JavaAnalysisBundle.message((String)"report.suspicious.but.possibly.correct.method.calls", (Object[])new Object[0]), (InspectionProfileEntry)this, "REPORT_CONVERTIBLE_METHOD_CALLS");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        final ArrayList patternMethods = new ArrayList();
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression methodCall) {
                PsiExpression[] args = methodCall.getArgumentList().getExpressions();
                if (args.length < 1) {
                    return;
                }
                for (int idx = 0; idx < Math.min(2, args.length); ++idx) {
                    String message2 = SuspiciousCollectionsMethodCallsInspection.getSuspiciousMethodCallMessage(methodCall, SuspiciousCollectionsMethodCallsInspection.this.REPORT_CONVERTIBLE_METHOD_CALLS, patternMethods, args[idx], idx);
                    if (message2 == null) continue;
                    holder.registerProblem((PsiElement)methodCall.getArgumentList().getExpressions()[idx], message2, new LocalQuickFix[0]);
                }
            }

            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
                PsiSubstitutor psiSubstitutor;
                MethodSignature signature;
                String message2;
                PsiType functionalInterfaceType = expression2.getFunctionalInterfaceType();
                PsiClassType.ClassResolveResult functionalInterfaceResolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType);
                PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
                if (interfaceMethod != null && interfaceMethod.getParameterList().getParametersCount() == 1 && (message2 = SuspiciousMethodCallUtil.getSuspiciousMethodCallMessage((PsiReferenceExpression)expression2, (signature = interfaceMethod.getSignature(psiSubstitutor = LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)functionalInterfaceResolveResult))).getParameterTypes()[0], SuspiciousCollectionsMethodCallsInspection.this.REPORT_CONVERTIBLE_METHOD_CALLS, patternMethods, 0)) != null) {
                    holder.registerProblem((PsiElement)ObjectUtils.notNull((Object)expression2.getReferenceNameElement(), (Object)expression2), message2, new LocalQuickFix[0]);
                }
            }
        };
    }

    @NotNull
    public String getGroupDisplayName() {
        return InspectionsBundle.message((String)"group.names.probable.bugs", (Object[])new Object[0]);
    }

    @NotNull
    public String getShortName() {
        return "SuspiciousMethodCalls";
    }

    private static String getSuspiciousMethodCallMessage(PsiMethodCallExpression methodCall, boolean reportConvertibleMethodCalls, List<SuspiciousMethodCallUtil.PatternMethod> patternMethods, PsiExpression arg, int i) {
        TypeConstraint constraint;
        PsiType type2;
        boolean exactType;
        PsiType argType = arg.getType();
        String plainMessage = SuspiciousMethodCallUtil.getSuspiciousMethodCallMessage(methodCall, arg, argType, (exactType = arg instanceof PsiNewExpression) || reportConvertibleMethodCalls, patternMethods, i);
        if (plainMessage != null && !exactType && (type2 = (constraint = TypeConstraint.fromDfType(CommonDataflow.getDfType(arg))).getPsiType(methodCall.getProject())) != null && SuspiciousMethodCallUtil.getSuspiciousMethodCallMessage(methodCall, arg, type2, reportConvertibleMethodCalls, patternMethods, i) == null) {
            return null;
        }
        return plainMessage;
    }
}

