/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.magicConstant;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.magicConstant.MagicConstantUtils;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.java.JavaBundle;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.impl.JavaSdkImpl;
import com.intellij.openapi.roots.JdkUtils;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.slicer.DuplicateMap;
import com.intellij.slicer.LanguageSlicing;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceRootNode;
import com.intellij.slicer.SliceUsage;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import one.util.streamex.Joining;
import one.util.streamex.StreamEx;
import org.intellij.lang.annotations.MagicConstant;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MagicConstantInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Key<Boolean> ANNOTATIONS_BEING_ATTACHED = Key.create((String)"REPORTED_NO_ANNOTATIONS_FOUND");
    private static final CallMapper<MagicConstantUtils.AllowedValues> SPECIAL_CASES = new CallMapper<Function<PsiMethodCallExpression, MagicConstantUtils.AllowedValues>>().register((CallMatcher)CallMatcher.instanceCall("java.util.Calendar", "get").parameterTypes("int"), MagicConstantInspection::getCalendarGetValues);
    private static final Key<Map<String, PsiExpression>> LITERAL_EXPRESSION_CACHE = Key.create((String)"LITERAL_EXPRESSION_CACHE");

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return InspectionsBundle.message((String)"group.names.probable.bugs", (Object[])new Object[0]);
    }

    @NotNull
    public String getShortName() {
        return "MagicConstant";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        return new JavaElementVisitor(){

            public void visitJavaFile(PsiJavaFile file) {
                Runnable fix;
                if (!InjectedLanguageManager.getInstance((Project)file.getProject()).isInjectedFragment((PsiFile)file) && (fix = MagicConstantInspection.getAttachAnnotationsJarFix(file.getProject())) != null) {
                    fix.run();
                }
            }

            public void visitCallExpression(PsiCallExpression callExpression) {
                MagicConstantInspection.checkCall(callExpression, holder);
            }

            public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
                PsiExpression r = expression2.getRExpression();
                if (r == null) {
                    return;
                }
                PsiExpression l = expression2.getLExpression();
                if (!(l instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiElement resolved = ((PsiReferenceExpression)l).resolve();
                if (!(resolved instanceof PsiModifierListOwner)) {
                    return;
                }
                PsiModifierListOwner owner2 = (PsiModifierListOwner)resolved;
                PsiType type2 = expression2.getType();
                MagicConstantInspection.checkExpression(r, owner2, type2, holder);
            }

            public void visitReturnStatement(PsiReturnStatement statement) {
                PsiMethod method;
                PsiExpression value2 = statement.getReturnValue();
                if (value2 == null) {
                    return;
                }
                PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
                PsiMethod psiMethod = method = element instanceof PsiMethod ? (PsiMethod)element : LambdaUtil.getFunctionalInterfaceMethod((PsiElement)element);
                if (method == null) {
                    return;
                }
                MagicConstantInspection.checkExpression(value2, (PsiModifierListOwner)method, value2.getType(), holder);
            }

            public void visitNameValuePair(PsiNameValuePair pair2) {
                PsiAnnotationMemberValue value2 = pair2.getValue();
                if (!(value2 instanceof PsiExpression)) {
                    return;
                }
                PsiReference ref = pair2.getReference();
                if (ref == null) {
                    return;
                }
                PsiMethod method = (PsiMethod)ref.resolve();
                if (method == null) {
                    return;
                }
                MagicConstantInspection.checkExpression((PsiExpression)value2, (PsiModifierListOwner)method, method.getReturnType(), holder);
            }

            public void visitBinaryExpression(PsiBinaryExpression expression2) {
                IElementType tokenType = expression2.getOperationTokenType();
                if (tokenType != JavaTokenType.EQEQ && tokenType != JavaTokenType.NE) {
                    return;
                }
                PsiExpression l = expression2.getLOperand();
                PsiExpression r = expression2.getROperand();
                if (r == null) {
                    return;
                }
                this.checkBinary(l, r);
                this.checkBinary(r, l);
            }

            private void checkBinary(@NotNull PsiExpression l, @NotNull PsiExpression r) {
                PsiMethodCallExpression call;
                PsiMethod method;
                if (l instanceof PsiReference) {
                    PsiElement resolved = ((PsiReference)l).resolve();
                    if (resolved instanceof PsiModifierListOwner) {
                        MagicConstantInspection.checkExpression(r, (PsiModifierListOwner)resolved, MagicConstantInspection.getType((PsiModifierListOwner)resolved), holder);
                    }
                } else if (l instanceof PsiMethodCallExpression && (method = (call = (PsiMethodCallExpression)l).resolveMethod()) != null) {
                    MagicConstantInspection.checkExpression(r, (PsiModifierListOwner)method, method.getReturnType(), holder);
                    MagicConstantInspection.checkExpression(r, holder, (MagicConstantUtils.AllowedValues)SPECIAL_CASES.mapFirst(call));
                }
            }
        };
    }

    public void cleanup(@NotNull Project project) {
        super.cleanup(project);
        project.putUserData(ANNOTATIONS_BEING_ATTACHED, null);
    }

    public static Runnable getAttachAnnotationsJarFix(@NotNull Project project) {
        Boolean found = (Boolean)project.getUserData(ANNOTATIONS_BEING_ATTACHED);
        if (found != null) {
            return null;
        }
        Sdk jdk = MagicConstantInspection.getJDKToAnnotate(project);
        return jdk == null ? null : () -> MagicConstantInspection.attachAnnotationsLaterTo(project, jdk);
    }

    private static Sdk getJDKToAnnotate(@NotNull Project project) {
        PsiClass awtInputEvent = JavaPsiFacade.getInstance((Project)project).findClass("java.awt.event.InputEvent", GlobalSearchScope.allScope((Project)project));
        if (awtInputEvent == null) {
            return null;
        }
        PsiMethod[] methods = awtInputEvent.findMethodsByName("getModifiers", false);
        if (methods.length != 1) {
            return null;
        }
        PsiMethod getModifiers = methods[0];
        Sdk jdk = JdkUtils.getJdkForElement((PsiElement)getModifiers);
        if (jdk == null) {
            return null;
        }
        PsiAnnotation annotation = ExternalAnnotationsManager.getInstance((Project)project).findExternalAnnotation((PsiModifierListOwner)getModifiers, MagicConstant.class.getName());
        return annotation == null ? jdk : null;
    }

    private static void attachAnnotationsLaterTo(@NotNull Project project, @NotNull Sdk sdk) {
        project.putUserData(ANNOTATIONS_BEING_ATTACHED, (Object)Boolean.TRUE);
        ApplicationManager.getApplication().invokeLater(() -> {
            SdkModificator modificator = sdk.getSdkModificator();
            boolean success = JavaSdkImpl.attachIDEAAnnotationsToJdk(modificator);
            if (success) {
                modificator.commitChanges();
            }
            if (success &= MagicConstantInspection.getJDKToAnnotate(project) == null) {
                project.putUserData(ANNOTATIONS_BEING_ATTACHED, null);
            }
        }, project.getDisposed());
    }

    private static void checkExpression(@NotNull PsiExpression expression2, @NotNull PsiModifierListOwner owner2, @Nullable PsiType type2, @NotNull ProblemsHolder holder) {
        MagicConstantUtils.AllowedValues allowed = MagicConstantUtils.getAllowedValues(owner2, type2);
        MagicConstantInspection.checkExpression(expression2, holder, allowed);
    }

    private static void checkExpression(@NotNull PsiExpression expression2, @NotNull ProblemsHolder holder, MagicConstantUtils.AllowedValues allowed) {
        if (allowed == null) {
            return;
        }
        PsiElement scope = PsiUtil.getTopLevelEnclosingCodeBlock((PsiElement)expression2, null);
        if (scope == null) {
            scope = expression2;
        }
        if (!MagicConstantInspection.isAllowed(expression2, scope, allowed, expression2.getManager(), null)) {
            MagicConstantInspection.registerProblem(expression2, allowed, holder);
        }
    }

    private static void checkCall(@NotNull PsiCallExpression methodCall, @NotNull ProblemsHolder holder) {
        PsiExpressionList argumentList = methodCall.getArgumentList();
        if (argumentList == null) {
            return;
        }
        PsiMethod method = methodCall.resolveMethod();
        if (method == null) {
            return;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        PsiExpression[] arguments = argumentList.getExpressions();
        for (int i = 0; i < parameters2.length; ++i) {
            PsiParameter parameter2 = parameters2[i];
            MagicConstantUtils.AllowedValues values = MagicConstantUtils.getAllowedValues((PsiModifierListOwner)parameter2, parameter2.getType());
            if (values == null) continue;
            if (i >= arguments.length) break;
            PsiExpression argument = arguments[i];
            if ((argument = PsiUtil.deparenthesizeExpression((PsiExpression)argument)) == null) continue;
            MagicConstantInspection.checkMagicParameterArgument(parameter2, argument, values, holder);
        }
    }

    private static MagicConstantUtils.AllowedValues getCalendarGetValues(PsiMethodCallExpression call) {
        Integer argument = (Integer)ObjectUtils.tryCast((Object)ExpressionUtils.computeConstantExpression(call.getArgumentList().getExpressions()[0]), Integer.class);
        PsiMethod method = call.resolveMethod();
        if (method == null || argument == null) {
            return null;
        }
        return (MagicConstantUtils.AllowedValues)((Map)CachedValuesManager.getCachedValue((PsiElement)method, () -> {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)method.getProject());
            Function<String[], MagicConstantUtils.AllowedValues> converter = strings -> {
                String expression2 = StreamEx.of((Object[])strings).map("java.util.Calendar."::concat).joining((CharSequence)",", (CharSequence)"{", (CharSequence)"}");
                PsiArrayInitializerExpression initializer = (PsiArrayInitializerExpression)factory.createExpressionFromText(expression2, (PsiElement)method);
                return new MagicConstantUtils.AllowedValues((PsiAnnotationMemberValue[])initializer.getInitializers(), false);
            };
            HashMap<Integer, MagicConstantUtils.AllowedValues> map2 = new HashMap<Integer, MagicConstantUtils.AllowedValues>();
            String[] days = new String[]{"SUNDAY", "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY"};
            map2.put(7, converter.apply(days));
            String[] months = new String[]{"JANUARY", "FEBRUARY", "MARCH", "APRIL", "MAY", "JUNE", "JULY", "AUGUST", "SEPTEMBER", "OCTOBER", "NOVEMBER", "DECEMBER"};
            map2.put(2, converter.apply(months));
            String[] amPm = new String[]{"AM", "PM"};
            map2.put(9, converter.apply(amPm));
            return CachedValueProvider.Result.create(map2, (Object[])new Object[]{method});
        })).get(argument);
    }

    private static PsiType getType(@NotNull PsiModifierListOwner element) {
        return element instanceof PsiVariable ? ((PsiVariable)element).getType() : (element instanceof PsiMethod ? ((PsiMethod)element).getReturnType() : null);
    }

    private static void checkMagicParameterArgument(@NotNull PsiParameter parameter2, @NotNull PsiExpression argument, @NotNull MagicConstantUtils.AllowedValues allowedValues, @NotNull ProblemsHolder holder) {
        PsiManager manager = PsiManager.getInstance((Project)holder.getProject());
        if (!argument.getTextRange().isEmpty() && !MagicConstantInspection.isAllowed(argument, parameter2.getDeclarationScope(), allowedValues, manager, null)) {
            MagicConstantInspection.registerProblem(argument, allowedValues, holder);
        }
    }

    private static void registerProblem(@NotNull PsiExpression argument, @NotNull MagicConstantUtils.AllowedValues allowedValues, @NotNull ProblemsHolder holder) {
        Function<PsiAnnotationMemberValue, String> formatter = value2 -> {
            PsiElement resolved;
            if (value2 instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)value2).resolve()) instanceof PsiVariable) {
                return PsiFormatUtil.formatVariable((PsiVariable)((PsiVariable)resolved), (int)4097, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            }
            return value2.getText();
        };
        String values = (String)StreamEx.of((Object[])allowedValues.getValues()).map(formatter).collect((Collector)Joining.with((CharSequence)", ").cutAfterDelimiter().maxCodePoints(100));
        String message2 = JavaBundle.message((String)"inspection.magic.constants.should.be.one.of.values", (Object[])new Object[]{values, allowedValues.isFlagSet() ? 1 : 0});
        holder.registerProblem((PsiElement)argument, message2, new LocalQuickFix[]{MagicConstantInspection.suggestMagicConstant(argument, allowedValues)});
    }

    @Nullable
    private static LocalQuickFix suggestMagicConstant(@NotNull PsiExpression argument, @NotNull MagicConstantUtils.AllowedValues allowedValues) {
        Object argumentValue = JavaConstantExpressionEvaluator.computeConstantExpression(argument, null, false);
        if (argumentValue == null) {
            return null;
        }
        if (!allowedValues.isFlagSet()) {
            for (PsiAnnotationMemberValue value2 : allowedValues.getValues()) {
                Object constantValue;
                if (!(value2 instanceof PsiExpression) || !argumentValue.equals(constantValue = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)value2, null, false))) continue;
                return new ReplaceWithMagicConstantFix(argument, value2);
            }
        } else {
            Long longArgument = MagicConstantInspection.evaluateLongConstant(argument);
            if (longArgument == null) {
                return null;
            }
            long remainingFlags = longArgument;
            ArrayList<PsiAnnotationMemberValue> flags = new ArrayList<PsiAnnotationMemberValue>();
            for (PsiAnnotationMemberValue value3 : allowedValues.getValues()) {
                Long constantValue;
                if (!(value3 instanceof PsiExpression) || (constantValue = MagicConstantInspection.evaluateLongConstant((PsiExpression)value3)) == null || (remainingFlags & constantValue) != constantValue) continue;
                flags.add(value3);
                remainingFlags &= constantValue ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if (remainingFlags == 0L) {
                if (flags.size() > 1) {
                    for (int i = flags.size() - 1; i >= 0; --i) {
                        PsiAnnotationMemberValue flag = (PsiAnnotationMemberValue)flags.get(i);
                        Long flagValue = MagicConstantInspection.evaluateLongConstant((PsiExpression)flag);
                        if (flagValue == null || flagValue != 0L) continue;
                        flags.remove(i);
                    }
                }
                if (!flags.isEmpty()) {
                    return new ReplaceWithMagicConstantFix(argument, flags.toArray(PsiAnnotationMemberValue.EMPTY_ARRAY));
                }
            }
        }
        return null;
    }

    private static Long evaluateLongConstant(@NotNull PsiExpression expression2) {
        Object constantValue = JavaConstantExpressionEvaluator.computeConstantExpression(expression2, null, false);
        if (constantValue instanceof Long || constantValue instanceof Integer || constantValue instanceof Short || constantValue instanceof Byte) {
            return ((Number)constantValue).longValue();
        }
        return null;
    }

    private static boolean isAllowed(@NotNull PsiExpression argument, @NotNull PsiElement scope, @NotNull MagicConstantUtils.AllowedValues allowedValues, @NotNull PsiManager manager, @Nullable Set<PsiExpression> visited) {
        if (MagicConstantInspection.isGoodExpression(argument, allowedValues, scope, manager, visited)) {
            return true;
        }
        return MagicConstantInspection.processValuesFlownTo(argument, scope, manager, (Processor<? super PsiExpression>)((Processor)expression2 -> MagicConstantInspection.isGoodExpression(expression2, allowedValues, scope, manager, visited)));
    }

    private static boolean isGoodExpression(@NotNull PsiExpression argument, @NotNull MagicConstantUtils.AllowedValues allowedValues, @NotNull PsiElement scope, @NotNull PsiManager manager, @Nullable Set<PsiExpression> visited) {
        PsiExpression expression2 = PsiUtil.deparenthesizeExpression((PsiExpression)argument);
        if (expression2 == null) {
            return true;
        }
        if (visited == null) {
            visited = new THashSet();
        }
        if (!visited.add((PsiExpression)expression2)) {
            return true;
        }
        if (expression2 instanceof PsiConditionalExpression) {
            boolean thenAllowed;
            PsiExpression thenExpression2 = ((PsiConditionalExpression)expression2).getThenExpression();
            boolean bl = thenAllowed = thenExpression2 == null || MagicConstantInspection.isAllowed(thenExpression2, scope, allowedValues, manager, (Set<PsiExpression>)visited);
            if (!thenAllowed) {
                return false;
            }
            PsiExpression elseExpression2 = ((PsiConditionalExpression)expression2).getElseExpression();
            return elseExpression2 == null || MagicConstantInspection.isAllowed(elseExpression2, scope, allowedValues, manager, (Set<PsiExpression>)visited);
        }
        if (MagicConstantInspection.isOneOf(expression2, allowedValues, manager)) {
            return true;
        }
        if (allowedValues.isFlagSet()) {
            IElementType tokenType;
            PsiExpression zero = MagicConstantInspection.getLiteralExpression(expression2, manager, "0");
            if (MagicConstantUtils.same((PsiElement)expression2, (PsiElement)zero, manager) && !allowedValues.hasZeroValue()) {
                return true;
            }
            PsiExpression minusOne = MagicConstantInspection.getLiteralExpression(expression2, manager, "-1");
            if (MagicConstantUtils.same((PsiElement)expression2, (PsiElement)minusOne, manager)) {
                return true;
            }
            if (expression2 instanceof PsiPolyadicExpression && (JavaTokenType.OR.equals(tokenType = ((PsiPolyadicExpression)expression2).getOperationTokenType()) || JavaTokenType.XOR.equals(tokenType) || JavaTokenType.AND.equals(tokenType) || JavaTokenType.PLUS.equals(tokenType))) {
                for (PsiExpression operand2 : ((PsiPolyadicExpression)expression2).getOperands()) {
                    if (MagicConstantInspection.isAllowed(operand2, scope, allowedValues, manager, (Set<PsiExpression>)visited)) continue;
                    return false;
                }
                return true;
            }
            if (expression2 instanceof PsiPrefixExpression && JavaTokenType.TILDE.equals(((PsiPrefixExpression)expression2).getOperationTokenType())) {
                PsiExpression operand3 = ((PsiPrefixExpression)expression2).getOperand();
                return operand3 == null || MagicConstantInspection.isAllowed(operand3, scope, allowedValues, manager, (Set<PsiExpression>)visited);
            }
        }
        PsiElement resolved = null;
        MagicConstantUtils.AllowedValues allowedForRef = null;
        if (expression2 instanceof PsiReference) {
            resolved = ((PsiReference)expression2).resolve();
        } else if (expression2 instanceof PsiMethodCallExpression) {
            allowedForRef = SPECIAL_CASES.mapFirst((PsiMethodCallExpression)expression2);
            resolved = ((PsiCallExpression)expression2).resolveMethod();
        }
        if (allowedForRef == null && resolved instanceof PsiModifierListOwner) {
            allowedForRef = MagicConstantUtils.getAllowedValues((PsiModifierListOwner)resolved, MagicConstantInspection.getType((PsiModifierListOwner)resolved));
        }
        if (allowedForRef != null && allowedForRef.isSubsetOf(allowedValues, manager)) {
            return true;
        }
        return PsiType.NULL.equals((Object)expression2.getType());
    }

    @NotNull
    private static PsiExpression getLiteralExpression(@NotNull PsiExpression context, @NotNull PsiManager manager, @NotNull String text2) {
        PsiExpression expression2;
        Map cache = (Map)LITERAL_EXPRESSION_CACHE.get((UserDataHolder)manager);
        if (cache == null) {
            cache = ContainerUtil.createConcurrentSoftValueMap();
            cache = (Map)manager.putUserDataIfAbsent(LITERAL_EXPRESSION_CACHE, (Object)cache);
        }
        if ((expression2 = (PsiExpression)cache.get(text2)) == null) {
            expression2 = JavaPsiFacade.getElementFactory((Project)manager.getProject()).createExpressionFromText(text2, (PsiElement)context);
            cache.put(text2, expression2);
        }
        return expression2;
    }

    private static boolean isOneOf(@NotNull PsiExpression expression2, @NotNull MagicConstantUtils.AllowedValues allowedValues, @NotNull PsiManager manager) {
        for (PsiAnnotationMemberValue allowedValue : allowedValues.getValues()) {
            if (!MagicConstantUtils.same((PsiElement)allowedValue, (PsiElement)expression2, manager)) continue;
            return true;
        }
        return false;
    }

    static boolean processValuesFlownTo(@NotNull PsiExpression argument, @NotNull PsiElement scope, @NotNull PsiManager manager, @NotNull Processor<? super PsiExpression> processor2) {
        SliceAnalysisParams params = new SliceAnalysisParams();
        params.dataFlowToThis = true;
        params.scope = new AnalysisScope((SearchScope)new LocalSearchScope(scope), manager.getProject());
        SliceRootNode rootNode = new SliceRootNode(manager.getProject(), new DuplicateMap(), LanguageSlicing.getProvider((PsiElement)argument).createRootUsage((PsiElement)argument, params));
        Collection children = (Collection)ProgressManager.getInstance().runProcess(() -> ((SliceNode)rootNode.getChildren().iterator().next()).getChildren(), (ProgressIndicator)new ProgressIndicatorBase());
        for (AbstractTreeNode child : children) {
            SliceUsage usage = (SliceUsage)child.getValue();
            PsiElement element = usage != null ? usage.getElement() : null;
            if (!(element instanceof PsiExpression) || processor2.process((Object)((PsiExpression)element))) continue;
            return false;
        }
        return !children.isEmpty();
    }

    private static class ReplaceWithMagicConstantFix
    extends LocalQuickFixOnPsiElement {
        private final List<SmartPsiElementPointer<PsiAnnotationMemberValue>> myMemberValuePointers;

        ReplaceWithMagicConstantFix(@NotNull PsiExpression argument, PsiAnnotationMemberValue ... values) {
            super((PsiElement)argument);
            this.myMemberValuePointers = ContainerUtil.map((Object[])values, arg_0 -> ((SmartPointerManager)SmartPointerManager.getInstance((Project)argument.getProject())).createSmartPsiElementPointer(arg_0));
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"quickfix.family.replace.with.magic.constant", (Object[])new Object[0]);
        }

        @NotNull
        public String getText() {
            List names2 = this.myMemberValuePointers.stream().map(SmartPsiElementPointer::getElement).filter(Objects::nonNull).map(PsiElement::getText).collect(Collectors.toList());
            String expression2 = StringUtil.join(names2, (String)" | ");
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{expression2});
        }

        public void invoke(final @NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            List values = ContainerUtil.map(this.myMemberValuePointers, SmartPsiElementPointer::getElement);
            String text2 = StringUtil.join(Collections.nCopies(values.size(), "0"), (String)" | ");
            PsiExpression concatExp = PsiElementFactory.getInstance((Project)project).createExpressionFromText(text2, startElement);
            final ArrayList expressionsToReplace = new ArrayList(values.size());
            concatExp.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitLiteralExpression(PsiLiteralExpression expression2) {
                    super.visitLiteralExpression(expression2);
                    if (Integer.valueOf(0).equals(expression2.getValue())) {
                        expressionsToReplace.add(expression2);
                    }
                }
            });
            Iterator iterator = values.iterator();
            ArrayList<PsiElement> resolved = new ArrayList<PsiElement>();
            for (PsiLiteralExpression toReplace : expressionsToReplace) {
                PsiAnnotationMemberValue value2 = (PsiAnnotationMemberValue)iterator.next();
                resolved.add(((PsiReference)value2).resolve());
                PsiExpression replaced = (PsiExpression)toReplace.replace((PsiElement)value2);
                if (toReplace != concatExp) continue;
                concatExp = replaced;
            }
            PsiElement newStartElement = startElement.replace((PsiElement)concatExp);
            final Iterator resolvedValuesIterator = resolved.iterator();
            newStartElement.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(PsiReferenceExpression expression2) {
                    PsiElement bound = expression2.bindToElement((PsiElement)resolvedValuesIterator.next());
                    JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(bound);
                }
            });
        }

        public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            boolean allValid = this.myMemberValuePointers.stream().map(SmartPsiElementPointer::getElement).allMatch(p -> p != null && p.isValid());
            return allValid && super.isAvailable(project, file, startElement, endElement);
        }
    }
}

