/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.lambdaToExplicit;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtilRt;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LambdaAndExplicitMethodPair {
    static final LambdaAndExplicitMethodPair[] INFOS = new LambdaAndExplicitMethodPair[]{new LambdaAndExplicitMethodPair("java.util.Map", "computeIfAbsent", "putIfAbsent", 1, "V", new String[]{"k"}){

        @Override
        boolean isLambdaCall(PsiMethodCallExpression lambdaCall, PsiLambdaExpression lambda2) {
            return ExpressionUtils.isVoidContext((PsiExpression)lambdaCall) && super.isLambdaCall(lambdaCall, lambda2) && DfaUtil.inferLambdaNullability(lambda2) == Nullability.NOT_NULL;
        }

        @Override
        PsiExpression getLambdaCandidateFromExplicitCall(PsiMethodCallExpression explicitCall) {
            if (!ExpressionUtils.isVoidContext((PsiExpression)explicitCall)) {
                return null;
            }
            PsiExpression expr2 = super.getLambdaCandidateFromExplicitCall(explicitCall);
            if (expr2 != null && NullabilityUtil.getExpressionNullability(expr2, true) != Nullability.NOT_NULL) {
                return null;
            }
            return expr2;
        }
    }, new LambdaAndExplicitMethodPair("java.util.Optional", "orElseGet", "orElse", 0, "T", new String[0]), new LambdaAndExplicitMethodPair("java.util.OptionalInt", "orElseGet", "orElse", 0, "int", new String[0]), new LambdaAndExplicitMethodPair("java.util.OptionalLong", "orElseGet", "orElse", 0, "long", new String[0]), new LambdaAndExplicitMethodPair("java.util.OptionalDouble", "orElseGet", "orElse", 0, "double", new String[0]), new LambdaAndExplicitMethodPair("com.google.common.base.Optional", "or", "*", 0, "T", new String[0]), new LambdaAndExplicitMethodPair("java.util.Objects", "requireNonNull", "*", 1, "java.lang.String", new String[0]), new LambdaAndExplicitMethodPair("java.util.Objects", "requireNonNullElseGet", "requireNonNullElse", 1, "T", new String[0]), new LambdaAndExplicitMethodPair("org.junit.jupiter.api.Assertions", "assert(?!Timeout).*|fail", "*", -1, "java.lang.String", new String[0]), new LambdaAndExplicitMethodPair("org.junit.jupiter.api.Assertions", "assert(True|False)", "*", 0, "java.lang.String", new String[0]), new LambdaAndExplicitMethodPair("java.util.Arrays", "setAll", "fill", 1, null, "i")};
    @NotNull
    private final String myClass;
    @NotNull
    private final Pattern myLambdaMethod;
    @NotNull
    private final String myExplicitMethod;
    private final int myParameterIndex;
    @Nullable
    private final String myExplicitParameterType;
    private final String @NotNull [] myDefaultLambdaParameters;

    LambdaAndExplicitMethodPair(@NotNull String aClass, @NotNull @RegExp String lambdaMethod, @NotNull String explicitMethod, int index, @Nullable String explicitParameterType, String ... defaultLambdaParameters) {
        this.myClass = aClass;
        this.myLambdaMethod = Pattern.compile(lambdaMethod);
        this.myExplicitMethod = explicitMethod;
        this.myParameterIndex = index;
        this.myExplicitParameterType = explicitParameterType;
        this.myDefaultLambdaParameters = defaultLambdaParameters.length == 0 ? ArrayUtilRt.EMPTY_STRING_ARRAY : defaultLambdaParameters;
    }

    boolean isLambdaCall(PsiMethodCallExpression lambdaCall, PsiLambdaExpression lambda2) {
        int index;
        String name2 = lambdaCall.getMethodExpression().getReferenceName();
        if (name2 == null || !this.myLambdaMethod.matcher(name2).matches()) {
            return false;
        }
        PsiExpression[] args = lambdaCall.getArgumentList().getExpressions();
        if (args.length == 0) {
            return false;
        }
        int n = index = this.myParameterIndex == -1 ? args.length - 1 : this.myParameterIndex;
        if (args.length <= index || args[index] != lambda2) {
            return false;
        }
        PsiMethod method = lambdaCall.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length <= index) {
            return false;
        }
        PsiClass fnClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)parameters2[index].getType());
        return fnClass != null && LambdaUtil.getFunction((PsiClass)fnClass) != null && InheritanceUtil.isInheritor((PsiClass)method.getContainingClass(), (boolean)false, (String)this.myClass);
    }

    PsiExpression getLambdaCandidateFromExplicitCall(PsiMethodCallExpression explicitCall) {
        int index;
        if (this.myExplicitParameterType == null) {
            return null;
        }
        String name2 = explicitCall.getMethodExpression().getReferenceName();
        if (name2 == null) {
            return null;
        }
        if (this.myExplicitMethod.equals("*") ? !this.myLambdaMethod.matcher(name2).matches() : !this.myExplicitMethod.equals(name2)) {
            return null;
        }
        PsiExpression[] args = explicitCall.getArgumentList().getExpressions();
        if (args.length == 0) {
            return null;
        }
        int n = index = this.myParameterIndex == -1 ? args.length - 1 : this.myParameterIndex;
        if (args.length <= index) {
            return null;
        }
        PsiExpression arg = args[index];
        if (arg instanceof PsiFunctionalExpression) {
            return null;
        }
        if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)arg)) {
            return null;
        }
        PsiMethod method = explicitCall.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length <= index) {
            return null;
        }
        PsiType type2 = parameters2[index].getType();
        if (!type2.equalsToText(this.myExplicitParameterType)) {
            return null;
        }
        if (!InheritanceUtil.isInheritor((PsiClass)method.getContainingClass(), (boolean)false, (String)this.myClass)) {
            return null;
        }
        return arg;
    }

    public String getExplicitMethodName(PsiMethodCallExpression lambdaCall) {
        if (this.myExplicitMethod.equals("*")) {
            return lambdaCall.getMethodExpression().getReferenceName();
        }
        return this.myExplicitMethod;
    }

    public String getLambdaMethodName(PsiMethodCallExpression explicitCall) {
        if (this.myExplicitMethod.equals("*")) {
            return explicitCall.getMethodExpression().getReferenceName();
        }
        return this.myLambdaMethod.pattern();
    }

    @NotNull
    public String makeLambda(@NotNull PsiExpression expression2) {
        if (this.myDefaultLambdaParameters.length == 0) {
            return "()->" + expression2.getText();
        }
        JavaCodeStyleManager manager = JavaCodeStyleManager.getInstance((Project)expression2.getProject());
        String params = StreamEx.of((Object[])this.myDefaultLambdaParameters).map(param -> manager.suggestUniqueVariableName(param, (PsiElement)expression2, true)).joining((CharSequence)",");
        if (this.myDefaultLambdaParameters.length != 1) {
            params = "(" + params + ")";
        }
        return params + "->" + expression2.getText();
    }
}

