/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.javaDoc;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.impl.AddJavadocIntention;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.javaDoc.JavadocHighlightUtil;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.pom.Navigatable;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.javadoc.JavadocManager;
import com.intellij.psi.javadoc.JavadocTagInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.Gray;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDocLocalInspection
extends LocalInspectionTool {
    private static final ExtensionPointName<Condition<PsiMember>> EP_NAME = new ExtensionPointName("com.intellij.javaDocNotNecessary");
    public static final String SHORT_NAME = "JavaDoc";
    protected static final String NONE = "none";
    protected static final String PACKAGE_LOCAL = "package";
    protected static final String PUBLIC = "public";
    protected static final String PROTECTED = "protected";
    protected static final String PRIVATE = "private";
    private static final String IGNORE_ACCESSORS_ATTR_NAME = "IGNORE_ACCESSORS";
    private static final String IGNORE_DUPLICATED_THROWS_TAGS_ATTR_NAME = "IGNORE_DUPLICATED_THROWS_TAGS";
    private static final String MODULE_OPTIONS_TAG_NAME = "MODULE_OPTIONS";
    protected final Options PACKAGE_OPTIONS = new Options("none", "");
    protected final Options MODULE_OPTIONS = new Options("none", "");
    public Options TOP_LEVEL_CLASS_OPTIONS = new Options("none", "");
    public Options INNER_CLASS_OPTIONS = new Options("none", "");
    public Options METHOD_OPTIONS = new Options("none", "@return@param@throws or @exception");
    public Options FIELD_OPTIONS = new Options("none", "");
    public boolean IGNORE_DEPRECATED;
    public boolean IGNORE_JAVADOC_PERIOD = true;
    @Deprecated
    public boolean IGNORE_DUPLICATED_THROWS;
    public boolean IGNORE_POINT_TO_ITSELF;
    public String myAdditionalJavadocTags = "";
    private boolean myIgnoreDuplicatedThrows = true;
    private boolean myIgnoreEmptyDescriptions;
    private boolean myIgnoreSimpleAccessors;

    public JComponent createOptionsPanel() {
        return new OptionsPanel();
    }

    private static LocalQuickFix createAddJavadocFix(@NotNull PsiElement nameIdentifier, boolean isOnTheFly) {
        return isOnTheFly ? new AddJavadocFix(nameIdentifier) : null;
    }

    private static LocalQuickFix createAddMissingTagFix(@NotNull String tag, @NotNull String value2) {
        return new AddMissingTagFix(tag, value2);
    }

    private static LocalQuickFix createAddMissingParamTagFix(@NotNull String name2) {
        return new AddMissingParamTagFix(name2);
    }

    protected LocalQuickFix createRegisterTagFix(@NotNull String tag) {
        return new AddUnknownTagToCustoms(this, tag);
    }

    public void setPackageOption(String modifier, String tags) {
        this.PACKAGE_OPTIONS.ACCESS_JAVADOC_REQUIRED_FOR = modifier;
        this.PACKAGE_OPTIONS.REQUIRED_TAGS = tags;
    }

    public void registerAdditionalTag(@NotNull String tag) {
        this.myAdditionalJavadocTags = !this.myAdditionalJavadocTags.isEmpty() ? this.myAdditionalJavadocTags + "," + tag : tag;
    }

    public boolean isIgnoreDuplicatedThrows() {
        return this.myIgnoreDuplicatedThrows;
    }

    public void setIgnoreDuplicatedThrows(boolean ignoreDuplicatedThrows) {
        this.myIgnoreDuplicatedThrows = ignoreDuplicatedThrows;
    }

    public void setIgnoreEmptyDescriptions(boolean ignoreEmptyDescriptions) {
        this.myIgnoreEmptyDescriptions = ignoreEmptyDescriptions;
    }

    public boolean isIgnoreSimpleAccessors() {
        return this.myIgnoreSimpleAccessors;
    }

    public void setIgnoreSimpleAccessors(boolean ignoreSimpleAccessors) {
        this.myIgnoreSimpleAccessors = ignoreSimpleAccessors;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        super.writeSettings(node);
        if (this.myIgnoreSimpleAccessors) {
            JDOMExternalizerUtil.writeCustomField((Element)node, (String)IGNORE_ACCESSORS_ATTR_NAME, (String)String.valueOf(true));
        }
        if (!this.myIgnoreDuplicatedThrows) {
            JDOMExternalizerUtil.writeCustomField((Element)node, (String)IGNORE_DUPLICATED_THROWS_TAGS_ATTR_NAME, (String)String.valueOf(false));
        }
        if (this.MODULE_OPTIONS.isModified()) {
            this.MODULE_OPTIONS.writeExternal(JDOMExternalizerUtil.writeOption((Element)node, (String)MODULE_OPTIONS_TAG_NAME));
        }
        if (this.PACKAGE_OPTIONS.isModified()) {
            this.PACKAGE_OPTIONS.writeExternal(node);
        }
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        Element moduleOptions;
        String ignoreDuplicatedThrows;
        super.readSettings(node);
        String ignoreAccessors = JDOMExternalizerUtil.readCustomField((Element)node, (String)IGNORE_ACCESSORS_ATTR_NAME);
        if (ignoreAccessors != null) {
            this.myIgnoreSimpleAccessors = Boolean.parseBoolean(ignoreAccessors);
        }
        if ((ignoreDuplicatedThrows = JDOMExternalizerUtil.readCustomField((Element)node, (String)IGNORE_DUPLICATED_THROWS_TAGS_ATTR_NAME)) != null) {
            this.myIgnoreDuplicatedThrows = Boolean.parseBoolean(ignoreDuplicatedThrows);
        }
        if ((moduleOptions = JDOMExternalizerUtil.readOption((Element)node, (String)MODULE_OPTIONS_TAG_NAME)) != null) {
            this.MODULE_OPTIONS.readExternal(moduleOptions);
        }
        this.PACKAGE_OPTIONS.readExternal(node);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitJavaFile(PsiJavaFile file) {
                if ("package-info.java".equals(file.getName())) {
                    JavaDocLocalInspection.this.checkFile(file, holder, isOnTheFly);
                }
            }

            public void visitModule(PsiJavaModule module) {
                JavaDocLocalInspection.this.checkModule(module, holder, isOnTheFly);
            }

            public void visitClass(PsiClass aClass) {
                JavaDocLocalInspection.this.checkClass(aClass, holder, isOnTheFly);
            }

            public void visitField(PsiField field) {
                JavaDocLocalInspection.this.checkField(field, holder, isOnTheFly);
            }

            public void visitMethod(PsiMethod method) {
                JavaDocLocalInspection.this.checkMethod(method, holder, isOnTheFly);
            }
        };
    }

    private void checkFile(PsiJavaFile file, ProblemsHolder delegate, boolean isOnTheFly) {
        PsiPackage pkg = JavaDirectoryService.getInstance().getPackage(file.getContainingDirectory());
        if (pkg == null) {
            return;
        }
        PsiDocComment docComment = (PsiDocComment)PsiTreeUtil.getChildOfType((PsiElement)file, PsiDocComment.class);
        if (this.IGNORE_DEPRECATED && JavaDocLocalInspection.isDeprecated((PsiModifierListOwner)pkg, docComment)) {
            return;
        }
        boolean required = JavadocHighlightUtil.isJavaDocRequired(this, (PsiModifierListOwner)pkg);
        ProblemHolderImpl holder = new ProblemHolderImpl(delegate, isOnTheFly);
        if (docComment != null) {
            PsiDocTag[] tags = docComment.getTags();
            this.checkBasics(docComment, tags, (PsiElement)pkg, required, this.PACKAGE_OPTIONS, holder);
        } else if (required) {
            PsiElement toHighlight = (PsiElement)ObjectUtils.notNull((Object)file.getPackageStatement(), (Object)file);
            JavadocHighlightUtil.reportMissingTag(toHighlight, holder);
        }
    }

    private void checkModule(PsiJavaModule module, ProblemsHolder delegate, boolean isOnTheFly) {
        PsiDocComment docComment = module.getDocComment();
        if (this.IGNORE_DEPRECATED && JavaDocLocalInspection.isDeprecated((PsiModifierListOwner)module, docComment)) {
            return;
        }
        boolean required = JavadocHighlightUtil.isJavaDocRequired(this, (PsiModifierListOwner)module);
        ProblemHolderImpl holder = new ProblemHolderImpl(delegate, isOnTheFly);
        if (docComment != null) {
            this.checkBasics(docComment, docComment.getTags(), (PsiElement)module, required, this.MODULE_OPTIONS, holder);
        } else if (required) {
            JavadocHighlightUtil.reportMissingTag((PsiElement)module.getNameIdentifier(), holder);
        }
    }

    private void checkClass(PsiClass aClass, ProblemsHolder delegate, boolean isOnTheFly) {
        if (aClass instanceof PsiAnonymousClass || aClass instanceof PsiSyntheticClass || aClass instanceof PsiTypeParameter) {
            return;
        }
        if (this.IGNORE_DEPRECATED && aClass.isDeprecated()) {
            return;
        }
        PsiDocComment docComment = aClass.getDocComment();
        boolean required = JavadocHighlightUtil.isJavaDocRequired(this, (PsiModifierListOwner)aClass);
        ProblemHolderImpl holder = new ProblemHolderImpl(delegate, isOnTheFly);
        if (docComment != null) {
            PsiDocTag[] tags = docComment.getTags();
            Options options = ClassUtil.isTopLevelClass((PsiClass)aClass) ? this.TOP_LEVEL_CLASS_OPTIONS : this.INNER_CLASS_OPTIONS;
            this.checkBasics(docComment, tags, (PsiElement)aClass, required, options, holder);
            if (required && JavaDocLocalInspection.isTagRequired(options, "param")) {
                JavadocHighlightUtil.checkMissingTypeParamTags((PsiTypeParameterListOwner)aClass, tags, docComment.getFirstChild(), holder);
            }
        } else if (required) {
            PsiElement toHighlight = (PsiElement)ObjectUtils.notNull((Object)aClass.getNameIdentifier(), (Object)aClass);
            JavadocHighlightUtil.reportMissingTag(toHighlight, holder);
        }
    }

    private void checkField(PsiField field, ProblemsHolder delegate, boolean isOnTheFly) {
        if (this.IGNORE_DEPRECATED && JavaDocLocalInspection.isDeprecated((PsiDocCommentOwner)field)) {
            return;
        }
        PsiDocComment docComment = field.getDocComment();
        boolean required = JavadocHighlightUtil.isJavaDocRequired(this, (PsiModifierListOwner)field);
        ProblemHolderImpl holder = new ProblemHolderImpl(delegate, isOnTheFly);
        if (docComment != null) {
            this.checkBasics(docComment, docComment.getTags(), (PsiElement)field, required, this.FIELD_OPTIONS, holder);
        } else if (required) {
            JavadocHighlightUtil.reportMissingTag((PsiElement)field.getNameIdentifier(), holder);
        }
    }

    private void checkMethod(PsiMethod method, ProblemsHolder delegate, boolean isOnTheFly) {
        PsiIdentifier nameIdentifier;
        if (method instanceof SyntheticElement) {
            return;
        }
        if (this.IGNORE_DEPRECATED && JavaDocLocalInspection.isDeprecated((PsiDocCommentOwner)method)) {
            return;
        }
        if (this.myIgnoreSimpleAccessors && PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)method)) {
            return;
        }
        PsiDocComment docComment = method.getDocComment();
        boolean hasSupers = method.findSuperMethods().length > 0;
        boolean required = JavadocHighlightUtil.isJavaDocRequired(this, (PsiModifierListOwner)method);
        ProblemHolderImpl holder = new ProblemHolderImpl(delegate, isOnTheFly);
        if (docComment != null) {
            if (!JavaDocLocalInspection.isInherited(docComment, method)) {
                PsiDocTag[] tags = docComment.getTags();
                if (required && !hasSupers) {
                    if (JavaDocLocalInspection.isTagRequired(this.METHOD_OPTIONS, "return")) {
                        JavadocHighlightUtil.checkMissingReturnTag(tags, method, docComment.getFirstChild(), holder);
                    }
                    if (JavaDocLocalInspection.isTagRequired(this.METHOD_OPTIONS, "param")) {
                        JavadocHighlightUtil.checkMissingParamTags(tags, method, docComment.getFirstChild(), holder);
                        JavadocHighlightUtil.checkMissingTypeParamTags((PsiTypeParameterListOwner)method, tags, docComment.getFirstChild(), holder);
                    }
                    if (JavaDocLocalInspection.isTagRequired(this.METHOD_OPTIONS, "throws")) {
                        JavadocHighlightUtil.checkMissingThrowsTags(tags, method, docComment.getFirstChild(), holder);
                    }
                }
                if (!this.myIgnoreEmptyDescriptions) {
                    JavadocHighlightUtil.checkEmptyMethodTagsDescription(tags, holder);
                }
                this.checkBasics(docComment, tags, (PsiElement)method, false, this.METHOD_OPTIONS, holder);
            }
        } else if (required && !hasSupers && (nameIdentifier = method.getNameIdentifier()) != null && EP_NAME.extensions().noneMatch(condition2 -> condition2.value((Object)method))) {
            JavadocHighlightUtil.reportMissingTag((PsiElement)nameIdentifier, holder);
        }
    }

    private void checkBasics(PsiDocComment docComment, PsiDocTag[] tags, PsiElement context, boolean required, Options options, ProblemHolderImpl holder) {
        if (required) {
            JavadocHighlightUtil.checkRequiredTags(tags, options, docComment.getFirstChild(), holder);
        }
        JavadocHighlightUtil.checkRequiredTagDescriptions(tags, holder);
        JavadocHighlightUtil.checkTagValues(tags, context, holder);
        if (!this.IGNORE_JAVADOC_PERIOD) {
            JavadocHighlightUtil.checkForPeriod(docComment, context, holder);
        }
        JavadocHighlightUtil.checkInlineTags(docComment.getDescriptionElements(), holder);
        JavadocHighlightUtil.checkForBadCharacters(docComment, holder);
        JavadocHighlightUtil.checkDuplicateTags(tags, holder);
    }

    @NotNull
    public String getGroupDisplayName() {
        return InspectionsBundle.message((String)"group.names.javadoc.issues", (Object[])new Object[0]);
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    @Nullable
    public String getAlternativeID() {
        return "javadoc";
    }

    private static boolean isDeprecated(PsiModifierListOwner element, PsiDocComment docComment) {
        return PsiImplUtil.isDeprecatedByAnnotation(element) || docComment != null && docComment.findTagByName("deprecated") != null;
    }

    protected static boolean isTagRequired(Options options, String tag) {
        return options.REQUIRED_TAGS.contains(tag);
    }

    private static boolean isDeprecated(PsiDocCommentOwner element) {
        return element.isDeprecated() || element.getContainingClass() != null && element.getContainingClass().isDeprecated();
    }

    private static boolean isInherited(PsiDocComment docComment, PsiMethod psiMethod) {
        JavadocTagInfo tagInfo;
        for (PsiElement descriptionElement : docComment.getDescriptionElements()) {
            if (!(descriptionElement instanceof PsiInlineDocTag) || !"inheritDoc".equals(((PsiInlineDocTag)descriptionElement).getName())) continue;
            return true;
        }
        return docComment.findTagByName("inheritDoc") != null && (tagInfo = JavadocManager.SERVICE.getInstance((Project)psiMethod.getProject()).getTagInfo("inheritDoc")) != null && tagInfo.isValidInContext((PsiElement)psiMethod);
    }

    private class ProblemHolderImpl
    implements JavadocHighlightUtil.ProblemHolder {
        private final ProblemsHolder myHolder;
        private final boolean myOnTheFly;

        private ProblemHolderImpl(ProblemsHolder holder, boolean onTheFly) {
            this.myHolder = holder;
            this.myOnTheFly = onTheFly;
        }

        @Override
        public Project project() {
            return this.myHolder.getManager().getProject();
        }

        @Override
        public JavaDocLocalInspection inspection() {
            return JavaDocLocalInspection.this;
        }

        @Override
        public void problem(@NotNull PsiElement toHighlight, @NotNull @Nls String message2, @Nullable LocalQuickFix fix) {
            this.myHolder.registerProblem(this.myHolder.getManager().createProblemDescriptor(toHighlight, message2, fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly));
        }

        @Override
        public void eolProblem(@NotNull PsiElement toHighlight, @NotNull @Nls String message2, @Nullable LocalQuickFix fix) {
            LocalQuickFix[] localQuickFixArray;
            if (fix != null) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = fix;
            } else {
                localQuickFixArray = null;
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            this.myHolder.registerProblem(this.myHolder.getManager().createProblemDescriptor(toHighlight, message2, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, true));
        }

        @Override
        public LocalQuickFix addJavadocFix(@NotNull PsiElement nameIdentifier) {
            return JavaDocLocalInspection.createAddJavadocFix(nameIdentifier, this.myOnTheFly);
        }

        @Override
        public LocalQuickFix addMissingTagFix(@NotNull String tag, @NotNull String value2) {
            return JavaDocLocalInspection.createAddMissingTagFix(tag, value2);
        }

        @Override
        public LocalQuickFix addMissingParamTagFix(@NotNull String name2) {
            return JavaDocLocalInspection.createAddMissingParamTagFix(name2);
        }

        @Override
        public LocalQuickFix registerTagFix(@NotNull String tag) {
            return JavaDocLocalInspection.this.createRegisterTagFix(tag);
        }
    }

    private static class AddUnknownTagToCustoms
    implements LocalQuickFix {
        private final JavaDocLocalInspection myInspection;
        private final String myTag;

        AddUnknownTagToCustoms(@NotNull JavaDocLocalInspection inspection, @NotNull String tag) {
            this.myInspection = inspection;
            this.myTag = tag;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            this.myInspection.registerAdditionalTag(this.myTag);
            ProjectInspectionProfileManager.getInstance((Project)project).fireProfileChanged();
        }

        @NotNull
        public String getName() {
            return QuickFixBundle.message("add.docTag.to.custom.tags", this.myTag);
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public String getFamilyName() {
            return QuickFixBundle.message("fix.javadoc.family", new Object[0]);
        }
    }

    private static class AddMissingParamTagFix
    extends AddMissingTagFix {
        private final String myName;

        AddMissingParamTagFix(String name2) {
            super("param", name2);
            this.myName = name2;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"inspection.javadoc.problem.add.param.tag.family", (Object[])new Object[0]);
        }

        @Override
        @Nullable
        protected PsiElement getAnchor(ProblemDescriptor descriptor) {
            PsiElement parent;
            PsiElement element = descriptor.getPsiElement();
            PsiElement psiElement = parent = element == null ? null : element.getParent();
            if (!(parent instanceof PsiDocComment)) {
                return null;
            }
            PsiDocComment docComment = (PsiDocComment)parent;
            PsiJavaDocumentedElement owner2 = docComment.getOwner();
            if (!(owner2 instanceof PsiMethod)) {
                return null;
            }
            Object[] parameters2 = ((PsiMethod)owner2).getParameterList().getParameters();
            PsiParameter myParam = (PsiParameter)ContainerUtil.find((Object[])parameters2, psiParameter -> this.myName.equals(psiParameter.getName()));
            if (myParam == null) {
                return null;
            }
            PsiDocTag[] tags = docComment.findTagsByName("param");
            if (tags.length == 0) {
                tags = docComment.getTags();
                if (tags.length == 0) {
                    return null;
                }
                return tags[0];
            }
            PsiParameter nextParam = (PsiParameter)PsiTreeUtil.getNextSiblingOfType((PsiElement)myParam, PsiParameter.class);
            while (nextParam != null) {
                for (PsiDocTag tag : tags) {
                    if (!AddMissingParamTagFix.matches(nextParam, tag)) continue;
                    return tag;
                }
                nextParam = (PsiParameter)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextParam, PsiParameter.class);
            }
            PsiParameter prevParam = (PsiParameter)PsiTreeUtil.getPrevSiblingOfType((PsiElement)myParam, PsiParameter.class);
            while (prevParam != null) {
                for (PsiDocTag tag : tags) {
                    if (!AddMissingParamTagFix.matches(prevParam, tag)) continue;
                    return PsiTreeUtil.getNextSiblingOfType((PsiElement)tag, PsiDocTag.class);
                }
                prevParam = (PsiParameter)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prevParam, PsiParameter.class);
            }
            return null;
        }

        private static boolean matches(PsiParameter param, PsiDocTag tag) {
            PsiDocTagValue valueElement = tag.getValueElement();
            String name2 = param.getName();
            return valueElement != null && valueElement.getText().trim().startsWith(name2);
        }

        @Override
        @NotNull
        public String getName() {
            return JavaBundle.message((String)"inspection.javadoc.problem.add.param.tag", (Object[])new Object[]{this.myName});
        }
    }

    private static class AddMissingTagFix
    implements LocalQuickFix {
        private final String myTag;
        private final String myValue;

        AddMissingTagFix(@NotNull String tag, @NotNull String value2) {
            this.myTag = tag;
            this.myValue = value2;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiDocComment docComment = (PsiDocComment)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getEndElement(), PsiDocComment.class);
            if (docComment != null) {
                PsiDocTag tag = JavaPsiFacade.getElementFactory((Project)project).createDocTagFromText("@" + this.myTag + " " + this.myValue);
                PsiElement anchor = this.getAnchor(descriptor);
                PsiElement addedTag = anchor != null ? docComment.addBefore((PsiElement)tag, anchor) : docComment.add((PsiElement)tag);
                AddMissingTagFix.moveCaretAfter(addedTag);
            }
        }

        @Nullable
        protected PsiElement getAnchor(ProblemDescriptor descriptor) {
            return null;
        }

        private static void moveCaretAfter(PsiElement newCaretPosition) {
            PsiElement sibling = newCaretPosition.getNextSibling();
            if (sibling != null) {
                ((Navigatable)sibling).navigate(true);
            }
        }

        @NotNull
        public String getName() {
            return JavaBundle.message((String)"inspection.javadoc.problem.add.tag", (Object[])new Object[]{this.myTag, this.myValue});
        }

        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"inspection.javadoc.problem.add.tag.family", (Object[])new Object[0]);
        }
    }

    private static class AddJavadocFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private final AddJavadocIntention myIntention = new AddJavadocIntention();

        AddJavadocFix(PsiElement nameIdentifier) {
            super(nameIdentifier);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            this.myIntention.invoke(project, editor, startElement);
        }

        @NotNull
        public String getText() {
            return this.myIntention.getText();
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return this.myIntention.getFamilyName();
        }
    }

    private class OptionsPanel
    extends JPanel {
        OptionsPanel() {
            super(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 11, 2, (Insets)JBUI.emptyInsets(), 0, 0);
            String title = JavaBundle.message((String)"inspection.javadoc.dialog.title", (Object[])new Object[0]);
            FieldPanel additionalTagsPanel = new FieldPanel(JavaBundle.message((String)"inspection.javadoc.label.text", (Object[])new Object[0]), title, null, null);
            additionalTagsPanel.setPreferredSize(new Dimension(150, additionalTagsPanel.getPreferredSize().height));
            additionalTagsPanel.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    Document document = e.getDocument();
                    try {
                        String text2 = document.getText(0, document.getLength());
                        if (text2 != null) {
                            JavaDocLocalInspection.this.myAdditionalJavadocTags = text2.trim();
                        }
                    }
                    catch (BadLocationException ex) {
                        Logger.getInstance(JavaDocLocalInspection.class).error((Throwable)ex);
                    }
                }
            });
            additionalTagsPanel.setText(JavaDocLocalInspection.this.myAdditionalJavadocTags);
            this.add((Component)additionalTagsPanel, gc);
            JBTabbedPane tabs = new JBTabbedPane(3, 1);
            String[] tags = new String[]{"@author", "@version", "@since"};
            tabs.add(JavaBundle.message((String)"inspection.javadoc.option.tab.title.package", (Object[])new Object[0]), this.createOptionsPanel(new String[]{JavaDocLocalInspection.NONE, JavaDocLocalInspection.PUBLIC}, tags, JavaDocLocalInspection.this.PACKAGE_OPTIONS));
            tabs.add(JavaBundle.message((String)"inspection.javadoc.option.tab.title.module", (Object[])new Object[0]), this.createOptionsPanel(new String[]{JavaDocLocalInspection.NONE, JavaDocLocalInspection.PUBLIC}, tags, JavaDocLocalInspection.this.MODULE_OPTIONS));
            tags = new String[]{"@author", "@version", "@since", "@param"};
            tabs.add(JavaBundle.message((String)"inspection.javadoc.option.tab.title", (Object[])new Object[0]), this.createOptionsPanel(new String[]{JavaDocLocalInspection.NONE, JavaDocLocalInspection.PUBLIC, JavaDocLocalInspection.PACKAGE_LOCAL}, tags, JavaDocLocalInspection.this.TOP_LEVEL_CLASS_OPTIONS));
            tags = new String[]{"@return", "@param", JavaBundle.message((String)"inspection.javadoc.throws.or.exception.option", (Object[])new Object[0])};
            tabs.add(JavaBundle.message((String)"inspection.javadoc.option.tab.title.method", (Object[])new Object[0]), this.createOptionsPanel(new String[]{JavaDocLocalInspection.NONE, JavaDocLocalInspection.PUBLIC, JavaDocLocalInspection.PROTECTED, JavaDocLocalInspection.PACKAGE_LOCAL, JavaDocLocalInspection.PRIVATE}, tags, JavaDocLocalInspection.this.METHOD_OPTIONS));
            tabs.add(JavaBundle.message((String)"inspection.javadoc.option.tab.title.field", (Object[])new Object[0]), this.createOptionsPanel(new String[]{JavaDocLocalInspection.NONE, JavaDocLocalInspection.PUBLIC, JavaDocLocalInspection.PROTECTED, JavaDocLocalInspection.PACKAGE_LOCAL, JavaDocLocalInspection.PRIVATE}, null, JavaDocLocalInspection.this.FIELD_OPTIONS));
            tabs.add(JavaBundle.message((String)"inspection.javadoc.option.tab.title.inner.class", (Object[])new Object[0]), this.createOptionsPanel(new String[]{JavaDocLocalInspection.NONE, JavaDocLocalInspection.PUBLIC, JavaDocLocalInspection.PROTECTED, JavaDocLocalInspection.PACKAGE_LOCAL, JavaDocLocalInspection.PRIVATE}, null, JavaDocLocalInspection.this.INNER_CLASS_OPTIONS));
            this.add((Component)tabs, gc);
            JCheckBox checkBox = new JCheckBox(JavaBundle.message((String)"inspection.javadoc.option.ignore.deprecated", (Object[])new Object[0]), JavaDocLocalInspection.this.IGNORE_DEPRECATED);
            checkBox.addActionListener(e -> {
                JavaDocLocalInspection.this.IGNORE_DEPRECATED = checkBox.isSelected();
            });
            gc.gridwidth = 1;
            this.add((Component)checkBox, gc);
            JCheckBox periodCheckBox = new JCheckBox(JavaBundle.message((String)"inspection.javadoc.option.ignore.period", (Object[])new Object[0]), JavaDocLocalInspection.this.IGNORE_JAVADOC_PERIOD);
            periodCheckBox.addActionListener(e -> {
                JavaDocLocalInspection.this.IGNORE_JAVADOC_PERIOD = periodCheckBox.isSelected();
            });
            this.add((Component)periodCheckBox, gc);
            JCheckBox ignoreDuplicateThrowsCheckBox = new JCheckBox(JavaBundle.message((String)"inspection.javadoc.option.ignore.throws", (Object[])new Object[0]), JavaDocLocalInspection.this.isIgnoreDuplicatedThrows());
            ignoreDuplicateThrowsCheckBox.addActionListener(e -> JavaDocLocalInspection.this.setIgnoreDuplicatedThrows(ignoreDuplicateThrowsCheckBox.isSelected()));
            this.add((Component)ignoreDuplicateThrowsCheckBox, gc);
            JCheckBox ignorePointToItselfCheckBox = new JCheckBox(JavaBundle.message((String)"inspection.javadoc.option.ignore.self.ref", (Object[])new Object[0]), JavaDocLocalInspection.this.IGNORE_POINT_TO_ITSELF);
            ignorePointToItselfCheckBox.addActionListener(e -> {
                JavaDocLocalInspection.this.IGNORE_POINT_TO_ITSELF = ignorePointToItselfCheckBox.isSelected();
            });
            this.add((Component)ignorePointToItselfCheckBox, gc);
            JCheckBox ignoreSimpleAccessorsCheckBox = new JCheckBox(JavaBundle.message((String)"inspection.javadoc.option.ignore.simple", (Object[])new Object[0]), JavaDocLocalInspection.this.isIgnoreSimpleAccessors());
            ignoreSimpleAccessorsCheckBox.addActionListener(e -> JavaDocLocalInspection.this.setIgnoreSimpleAccessors(ignoreSimpleAccessorsCheckBox.isSelected()));
            this.add((Component)ignoreSimpleAccessorsCheckBox, gc);
        }

        private JPanel createOptionsPanel(String[] modifiers, String[] tags, Options options) {
            JPanel pane = new JPanel(new GridLayout(1, tags == null ? 1 : 2));
            pane.add(this.createScopePanel(modifiers, options));
            if (tags != null) {
                pane.add(this.createTagsPanel(tags, options));
            }
            pane.validate();
            return pane;
        }

        private JPanel createScopePanel(String[] modifiers, Options options) {
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.setBorder(BorderFactory.createCompoundBorder(IdeBorderFactory.createTitledBorder((String)JavaBundle.message((String)"inspection.scope.for.title", (Object[])new Object[0])), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
            Hashtable<Integer, JLabel> sliderLabels = new Hashtable<Integer, JLabel>();
            for (int i = 0; i < modifiers.length; ++i) {
                sliderLabels.put(i + 1, new JLabel(modifiers[i]));
            }
            JSlider slider = new JSlider(1, 1, modifiers.length, 1);
            slider.setLabelTable(sliderLabels);
            slider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
            slider.setPreferredSize((Dimension)JBUI.size((int)80, (int)50));
            slider.setPaintLabels(true);
            slider.setSnapToTicks(true);
            slider.addChangeListener(e -> {
                int value2 = slider.getValue();
                options.ACCESS_JAVADOC_REQUIRED_FOR = modifiers[value2 - 1];
                for (Integer key2 : sliderLabels.keySet()) {
                    ((JComponent)sliderLabels.get(key2)).setForeground((Color)(key2 <= value2 ? JBColor.BLACK : Gray._100));
                }
            });
            JBColor fore = JBColor.BLACK;
            for (int i = 0; i < modifiers.length; ++i) {
                ((JComponent)sliderLabels.get(i + 1)).setForeground((Color)fore);
                if (!modifiers[i].equals(options.ACCESS_JAVADOC_REQUIRED_FOR)) continue;
                slider.setValue(i + 1);
                fore = Gray._100;
            }
            panel2.add((Component)slider, "West");
            return panel2;
        }

        private JPanel createTagsPanel(String[] tags, Options options) {
            JPanel panel2 = new JPanel(new GridBagLayout());
            panel2.setBorder(BorderFactory.createCompoundBorder(IdeBorderFactory.createTitledBorder((String)JavaBundle.message((String)"inspection.javadoc.required.tags.option.title", (Object[])new Object[0])), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
            GridBagConstraints gc = new GridBagConstraints();
            gc.weightx = 1.0;
            gc.weighty = 0.0;
            gc.fill = 2;
            gc.anchor = 18;
            for (int i = 0; i < tags.length; ++i) {
                JCheckBox box = new JCheckBox(tags[i]);
                gc.gridy = i;
                if (i == tags.length - 1) {
                    gc.weighty = 1.0;
                }
                panel2.add((Component)box, gc);
                box.setSelected(JavaDocLocalInspection.isTagRequired(options, tags[i]));
                box.addChangeListener(new MyChangeListener(box, options, tags[i]));
            }
            return panel2;
        }

        private class MyChangeListener
        implements ChangeListener {
            private final JCheckBox myCheckBox;
            private final Options myOptions;
            private final String myTagName;

            MyChangeListener(JCheckBox checkBox, Options options, String tagName) {
                this.myCheckBox = checkBox;
                this.myOptions = options;
                this.myTagName = tagName;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                if (this.myCheckBox.isSelected()) {
                    if (!JavaDocLocalInspection.isTagRequired(this.myOptions, this.myTagName)) {
                        this.myOptions.REQUIRED_TAGS = this.myOptions.REQUIRED_TAGS + this.myTagName;
                    }
                } else {
                    this.myOptions.REQUIRED_TAGS = this.myOptions.REQUIRED_TAGS.replaceAll(this.myTagName, "");
                }
            }
        }
    }

    public static class Options
    implements JDOMExternalizable {
        public String ACCESS_JAVADOC_REQUIRED_FOR = "none";
        public String REQUIRED_TAGS = "";

        public Options() {
        }

        public Options(String accessJavadocRequiredFor, String requiredTags) {
            this.ACCESS_JAVADOC_REQUIRED_FOR = accessJavadocRequiredFor;
            this.REQUIRED_TAGS = requiredTags;
        }

        public void readExternal(Element element) throws InvalidDataException {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        }

        public void writeExternal(Element element) throws WriteExternalException {
            DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        }

        private boolean isModified() {
            return !this.ACCESS_JAVADOC_REQUIRED_FOR.equals(JavaDocLocalInspection.NONE) || !this.REQUIRED_TAGS.isEmpty();
        }
    }
}

