/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19api;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.swing.JComponent;
import one.util.streamex.EntryStream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Java9CollectionFactoryInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher UNMODIFIABLE_SET = CallMatcher.staticCall("java.util.Collections", "unmodifiableSet").parameterCount(1);
    private static final CallMatcher UNMODIFIABLE_MAP = CallMatcher.staticCall("java.util.Collections", "unmodifiableMap").parameterCount(1);
    private static final CallMatcher UNMODIFIABLE_LIST = CallMatcher.staticCall("java.util.Collections", "unmodifiableList").parameterCount(1);
    private static final CallMatcher ARRAYS_AS_LIST = CallMatcher.staticCall("java.util.Arrays", "asList");
    private static final CallMatcher COLLECTION_ADD = CallMatcher.instanceCall("java.util.Collection", "add").parameterCount(1);
    private static final CallMatcher MAP_PUT = CallMatcher.instanceCall("java.util.Map", "put").parameterCount(2);
    private static final CallMatcher STREAM_COLLECT = CallMatcher.instanceCall("java.util.stream.Stream", "collect").parameterCount(1);
    private static final CallMatcher STREAM_OF = CallMatcher.staticCall("java.util.stream.Stream", "of");
    private static final CallMatcher COLLECTORS_TO_SET = CallMatcher.staticCall("java.util.stream.Collectors", "toSet").parameterCount(0);
    private static final CallMatcher COLLECTORS_TO_LIST = CallMatcher.staticCall("java.util.stream.Collectors", "toList").parameterCount(0);
    private static final CallMapper<PrepopulatedCollectionModel> MAPPER = new CallMapper<Function<PsiMethodCallExpression, PrepopulatedCollectionModel>>().register(UNMODIFIABLE_SET, call -> PrepopulatedCollectionModel.fromSet(call.getArgumentList().getExpressions()[0])).register(UNMODIFIABLE_MAP, call -> PrepopulatedCollectionModel.fromMap(call.getArgumentList().getExpressions()[0])).register(UNMODIFIABLE_LIST, call -> PrepopulatedCollectionModel.fromList(call.getArgumentList().getExpressions()[0]));
    public boolean IGNORE_NON_CONSTANT = false;
    public boolean SUGGEST_MAP_OF_ENTRIES = true;

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(JavaBundle.message((String)"inspection.collection.factories.option.ignore.non.constant", (Object[])new Object[0]), "IGNORE_NON_CONSTANT");
        panel2.addCheckbox(JavaBundle.message((String)"inspection.collection.factories.option.suggest.ofentries", (Object[])new Object[0]), "SUGGEST_MAP_OF_ENTRIES");
        return panel2;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (!PsiUtil.isLanguageLevel9OrHigher((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                PrepopulatedCollectionModel model = (PrepopulatedCollectionModel)MAPPER.mapFirst(call);
                if (model != null && model.isValid(Java9CollectionFactoryInspection.this.SUGGEST_MAP_OF_ENTRIES)) {
                    PsiMethodCallExpression element;
                    ProblemHighlightType type2;
                    ProblemHighlightType problemHighlightType = type2 = model.myConstantContent || !Java9CollectionFactoryInspection.this.IGNORE_NON_CONSTANT ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
                    if (type2 == ProblemHighlightType.INFORMATION && !isOnTheFly) {
                        return;
                    }
                    boolean wholeStatement = isOnTheFly && (type2 == ProblemHighlightType.INFORMATION || InspectionProjectProfileManager.isInformationLevel((String)Java9CollectionFactoryInspection.this.getShortName(), (PsiElement)call));
                    Object object = element = wholeStatement ? call : call.getMethodExpression().getReferenceNameElement();
                    if (element != null) {
                        String replacementMethod = model.hasTooManyMapEntries() ? "ofEntries" : (model.myCopy ? "copyOf" : "of");
                        String fixMessage = JavaBundle.message((String)"inspection.collection.factories.fix.name", (Object[])new Object[]{model.myType, replacementMethod});
                        String inspectionMessage = JavaBundle.message((String)"inspection.collection.factories.message", (Object[])new Object[]{model.myType, replacementMethod});
                        holder.registerProblem((PsiElement)element, inspectionMessage, type2, new LocalQuickFix[]{new ReplaceWithCollectionFactoryFix(fixMessage)});
                    }
                }
            }
        };
    }

    private static class ReplaceWithCollectionFactoryFix
    implements LocalQuickFix {
        private final String myMessage;

        ReplaceWithCollectionFactoryFix(String message2) {
            this.myMessage = message2;
        }

        @Nls
        @NotNull
        public String getName() {
            return this.myMessage;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"inspection.collection.factories.fix.family.name", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            String replacementText;
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiMethodCallExpression.class, (boolean)false);
            if (call == null) {
                return;
            }
            PrepopulatedCollectionModel model = (PrepopulatedCollectionModel)MAPPER.mapFirst(call);
            if (model == null) {
                return;
            }
            String typeArgument = ReplaceWithCollectionFactoryFix.getTypeArguments(call.getType(), model.myType);
            CommentTracker ct = new CommentTracker();
            if (model.myCopy) {
                assert (model.myContent.size() == 1);
                replacementText = "java.util." + model.myType + "." + typeArgument + "copyOf(" + model.myContent.get(0).getText() + ")";
            } else {
                replacementText = model.hasTooManyMapEntries() ? StreamEx.ofSubLists(model.myContent, (int)2).map(expr2 -> ct.commentsBefore((PsiElement)expr2.get(0)) + "java.util.Map.entry(" + ct.text((PsiElement)expr2.get(0)) + "," + ct.textWithComments((PsiElement)expr2.get(1)) + ")").joining((CharSequence)",", (CharSequence)("java.util.Map." + typeArgument + "ofEntries("), (CharSequence)")") : StreamEx.of(model.myContent).map(ct::textWithComments).joining((CharSequence)",", (CharSequence)("java.util." + model.myType + "." + typeArgument + "of("), (CharSequence)")");
            }
            List vars = StreamEx.of(model.myElementsToDelete).map(PsiElement::getParent).select(PsiLocalVariable.class).toList();
            model.myElementsToDelete.forEach(ct::delete);
            PsiElement replacement = ct.replaceAndRestoreComments((PsiElement)call, replacementText);
            vars.stream().filter(var -> ReferencesSearch.search((PsiElement)var).findFirst() == null).forEach(PsiElement::delete);
            RemoveRedundantTypeArgumentsUtil.removeRedundantTypeArguments(replacement);
        }

        @NotNull
        private static String getTypeArguments(PsiType type2, String typeName) {
            if (typeName.equals("Map")) {
                PsiType keyType = PsiUtil.substituteTypeParameter((PsiType)type2, (String)"java.util.Map", (int)0, (boolean)false);
                PsiType valueType = PsiUtil.substituteTypeParameter((PsiType)type2, (String)"java.util.Map", (int)1, (boolean)false);
                if (keyType != null && valueType != null) {
                    return "<" + keyType.getCanonicalText() + "," + valueType.getCanonicalText() + ">";
                }
            } else {
                PsiType elementType = PsiUtil.substituteTypeParameter((PsiType)type2, (String)"java.util.Collection", (int)0, (boolean)false);
                if (elementType != null) {
                    return "<" + elementType.getCanonicalText() + ">";
                }
            }
            return "";
        }
    }

    static class PrepopulatedCollectionModel {
        final List<PsiExpression> myContent;
        final List<PsiElement> myElementsToDelete;
        final String myType;
        final boolean myCopy;
        final boolean myConstantContent;
        final boolean myRepeatingKeys;
        final boolean myHasNulls;

        PrepopulatedCollectionModel(List<PsiExpression> content, List<PsiElement> delete, String type2) {
            this(content, delete, type2, false);
        }

        PrepopulatedCollectionModel(List<PsiExpression> content, List<PsiElement> delete, String type2, boolean copy) {
            this.myContent = content;
            this.myElementsToDelete = delete;
            this.myType = type2;
            this.myCopy = copy;
            Map constants = ((EntryStream)StreamEx.of(this.myContent).cross(ExpressionUtils::nonStructuralChildren).mapValues(ExpressionUtils::computeConstantExpression).distinct()).grouping();
            this.myConstantContent = !copy && StreamEx.ofValues((Map)constants).flatCollection(Function.identity()).allMatch(Objects::nonNull);
            this.myRepeatingKeys = ((StreamEx)this.keyExpressions().flatCollection(constants::get).nonNull().distinct(2L)).findAny().isPresent();
            this.myHasNulls = StreamEx.of(this.myContent).flatMap(ExpressionUtils::nonStructuralChildren).map(PsiExpression::getType).has((Object)PsiType.NULL);
        }

        boolean isValid(boolean suggestMapOfEntries) {
            return !this.myHasNulls && !this.myRepeatingKeys && (suggestMapOfEntries || !this.hasTooManyMapEntries());
        }

        private boolean hasTooManyMapEntries() {
            return this.myType.equals("Map") && this.myContent.size() > 20;
        }

        private StreamEx<PsiExpression> keyExpressions() {
            switch (this.myType) {
                case "Set": {
                    return StreamEx.of(this.myContent);
                }
                case "Map": {
                    return IntStreamEx.range((int)0, (int)this.myContent.size(), (int)2).elements(this.myContent);
                }
            }
            return StreamEx.empty();
        }

        public static PrepopulatedCollectionModel fromList(PsiExpression listDefinition) {
            if ((listDefinition = PsiUtil.skipParenthesizedExprDown((PsiExpression)listDefinition)) instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)listDefinition;
                if (ARRAYS_AS_LIST.test(call)) {
                    return new PrepopulatedCollectionModel(Arrays.asList(call.getArgumentList().getExpressions()), Collections.emptyList(), "List");
                }
                return PrepopulatedCollectionModel.fromCollect(call, "List", COLLECTORS_TO_LIST);
            }
            if (listDefinition instanceof PsiNewExpression) {
                return PrepopulatedCollectionModel.fromNewExpression((PsiNewExpression)listDefinition, "List", "java.util.ArrayList");
            }
            if (listDefinition instanceof PsiReferenceExpression) {
                return PrepopulatedCollectionModel.fromVariable((PsiReferenceExpression)listDefinition, "List", "java.util.ArrayList", COLLECTION_ADD);
            }
            return null;
        }

        public static PrepopulatedCollectionModel fromSet(PsiExpression setDefinition) {
            if ((setDefinition = PsiUtil.skipParenthesizedExprDown((PsiExpression)setDefinition)) instanceof PsiMethodCallExpression) {
                return PrepopulatedCollectionModel.fromCollect((PsiMethodCallExpression)setDefinition, "Set", COLLECTORS_TO_SET);
            }
            if (setDefinition instanceof PsiNewExpression) {
                return PrepopulatedCollectionModel.fromNewExpression((PsiNewExpression)setDefinition, "Set", "java.util.HashSet");
            }
            if (setDefinition instanceof PsiReferenceExpression) {
                return PrepopulatedCollectionModel.fromVariable((PsiReferenceExpression)setDefinition, "Set", "java.util.HashSet", COLLECTION_ADD);
            }
            return null;
        }

        public static PrepopulatedCollectionModel fromMap(PsiExpression mapDefinition) {
            if ((mapDefinition = PsiUtil.skipParenthesizedExprDown((PsiExpression)mapDefinition)) instanceof PsiReferenceExpression) {
                return PrepopulatedCollectionModel.fromVariable((PsiReferenceExpression)mapDefinition, "Map", "java.util.HashMap", MAP_PUT);
            }
            if (mapDefinition instanceof PsiNewExpression) {
                PsiNewExpression newExpression = (PsiNewExpression)mapDefinition;
                PsiAnonymousClass anonymousClass = newExpression.getAnonymousClass();
                PsiExpressionList argumentList = newExpression.getArgumentList();
                if (argumentList != null) {
                    PsiJavaCodeReferenceElement baseClassReference;
                    PsiExpression arg;
                    PsiExpression[] args = argumentList.getExpressions();
                    PsiJavaCodeReferenceElement classReference2 = newExpression.getClassReference();
                    if (classReference2 != null && PsiUtil.isLanguageLevel10OrHigher((PsiElement)mapDefinition) && "java.util.HashMap".equals(classReference2.getQualifiedName()) && args.length == 1 && (arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)args[0])) != null) {
                        PsiType sourceType = arg.getType();
                        PsiType targetType = newExpression.getType();
                        if (targetType != null && sourceType != null && sourceType.isAssignableFrom(targetType)) {
                            return new PrepopulatedCollectionModel(Collections.singletonList(arg), Collections.emptyList(), "Map", true);
                        }
                    }
                    if (anonymousClass != null && argumentList.isEmpty() && "java.util.HashMap".equals((baseClassReference = anonymousClass.getBaseClassReference()).getQualifiedName())) {
                        return PrepopulatedCollectionModel.fromInitializer(anonymousClass, "Map", MAP_PUT);
                    }
                }
            }
            return null;
        }

        @Nullable
        private static PrepopulatedCollectionModel fromCollect(PsiMethodCallExpression call, String typeName, CallMatcher collector) {
            if (STREAM_COLLECT.test(call) && collector.matches(call.getArgumentList().getExpressions()[0])) {
                PsiMethodCallExpression qualifier = MethodCallUtils.getQualifierMethodCall(call);
                if (STREAM_OF.matches((PsiExpression)qualifier)) {
                    return new PrepopulatedCollectionModel(Arrays.asList(qualifier.getArgumentList().getExpressions()), Collections.emptyList(), typeName);
                }
            }
            return null;
        }

        @Nullable
        private static PrepopulatedCollectionModel fromVariable(PsiReferenceExpression expression2, String typeName, String collectionClass, CallMatcher addMethod) {
            PsiLocalVariable variable = (PsiLocalVariable)ObjectUtils.tryCast((Object)expression2.resolve(), PsiLocalVariable.class);
            if (variable == null) {
                return null;
            }
            PsiCodeBlock block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiDeclarationStatement.class);
            if (block == null || declaration2 == null) {
                return null;
            }
            PsiElement[] defs = DefUseUtil.getDefs(block, (PsiVariable)variable, (PsiElement)expression2);
            if (defs.length == 1 && defs[0] == variable) {
                PsiExpression initializer = variable.getInitializer();
                if (!ConstructionUtils.isEmptyCollectionInitializer(initializer)) {
                    return null;
                }
                PsiClassType type2 = (PsiClassType)ObjectUtils.tryCast((Object)initializer.getType(), PsiClassType.class);
                if (type2 == null || !type2.rawType().equalsToText(collectionClass)) {
                    return null;
                }
                Set refs = ContainerUtil.set((Object[])DefUseUtil.getRefs(block, (PsiVariable)variable, (PsiElement)initializer));
                refs.remove(expression2);
                PsiDeclarationStatement cur = declaration2;
                ArrayList<PsiExpression> contents = new ArrayList<PsiExpression>();
                ArrayList<PsiElement> elementsToRemove = new ArrayList<PsiElement>();
                elementsToRemove.add((PsiElement)initializer);
                while (!PsiTreeUtil.isAncestor((PsiElement)(cur = (PsiStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)cur), PsiStatement.class)), (PsiElement)expression2, (boolean)false)) {
                    if (!(cur instanceof PsiExpressionStatement)) {
                        return null;
                    }
                    PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)((PsiExpressionStatement)cur).getExpression(), PsiMethodCallExpression.class);
                    if (!addMethod.test(call)) {
                        return null;
                    }
                    if (!refs.remove(call.getMethodExpression().getQualifierExpression())) {
                        return null;
                    }
                    contents.addAll(Arrays.asList(call.getArgumentList().getExpressions()));
                    elementsToRemove.add((PsiElement)cur);
                }
                if (!refs.isEmpty()) {
                    return null;
                }
                return new PrepopulatedCollectionModel(contents, elementsToRemove, typeName);
            }
            return null;
        }

        @Nullable
        private static PrepopulatedCollectionModel fromNewExpression(PsiNewExpression newExpression, String type2, String className2) {
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList != null) {
                PsiJavaCodeReferenceElement baseClassReference;
                PsiExpression[] args = argumentList.getExpressions();
                PsiJavaCodeReferenceElement classReference2 = newExpression.getClassReference();
                if (classReference2 != null && className2.equals(classReference2.getQualifiedName())) {
                    return PrepopulatedCollectionModel.fromCopyConstructor(args, type2);
                }
                PsiAnonymousClass anonymousClass = newExpression.getAnonymousClass();
                if (anonymousClass != null && args.length == 0 && className2.equals((baseClassReference = anonymousClass.getBaseClassReference()).getQualifiedName())) {
                    return PrepopulatedCollectionModel.fromInitializer(anonymousClass, type2, COLLECTION_ADD);
                }
            }
            return null;
        }

        @Nullable
        private static PrepopulatedCollectionModel fromCopyConstructor(PsiExpression[] args, String type2) {
            if (args.length == 1) {
                PsiExpression arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)args[0]);
                PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)arg, PsiMethodCallExpression.class);
                if (ARRAYS_AS_LIST.test(call)) {
                    return new PrepopulatedCollectionModel(Arrays.asList(call.getArgumentList().getExpressions()), Collections.emptyList(), type2);
                }
                if (arg != null && PsiUtil.isLanguageLevel10OrHigher((PsiElement)arg) && InheritanceUtil.isInheritor((PsiType)arg.getType(), (String)"java.util.Collection")) {
                    return new PrepopulatedCollectionModel(Collections.singletonList(arg), Collections.emptyList(), type2, true);
                }
            }
            return null;
        }

        @Nullable
        private static PrepopulatedCollectionModel fromInitializer(PsiAnonymousClass anonymousClass, String type2, CallMatcher addMethod) {
            PsiClassInitializer initializer = ClassUtils.getDoubleBraceInitializer(anonymousClass);
            if (initializer != null) {
                ArrayList<PsiExpression> contents = new ArrayList<PsiExpression>();
                for (PsiStatement statement : initializer.getBody().getStatements()) {
                    if (!(statement instanceof PsiExpressionStatement)) {
                        return null;
                    }
                    PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)((PsiExpressionStatement)statement).getExpression(), PsiMethodCallExpression.class);
                    if (!addMethod.test(call)) {
                        return null;
                    }
                    PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
                    if (qualifier != null && !qualifier.getText().equals("this")) {
                        return null;
                    }
                    contents.addAll(Arrays.asList(call.getArgumentList().getExpressions()));
                }
                return new PrepopulatedCollectionModel(contents, Collections.emptyList(), type2);
            }
            return null;
        }
    }
}

