/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deadCode;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.deadCode.DeadHTMLComposer;
import com.intellij.codeInspection.deadCode.RefEntryPointFilter;
import com.intellij.codeInspection.deadCode.UnusedDeclarationPresentation;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeModel;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.codeInspection.util.RefFilter;
import com.intellij.openapi.actionSystem.AnActionEvent;
import gnu.trove.TObjectIntHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DummyEntryPointsPresentation
extends UnusedDeclarationPresentation {
    private static final RefEntryPointFilter myFilter = new RefEntryPointFilter();
    private QuickFixAction[] myQuickFixActions;

    public DummyEntryPointsPresentation(@NotNull InspectionToolWrapper toolWrapper, @NotNull GlobalInspectionContextImpl context) {
        super(toolWrapper, context);
    }

    @Override
    @NotNull
    public RefFilter getFilter() {
        return myFilter;
    }

    @Override
    public QuickFixAction @NotNull [] getQuickFixes(RefEntity ... refElements) {
        if (this.myQuickFixActions == null) {
            this.myQuickFixActions = new QuickFixAction[]{new MoveEntriesToSuspicious(this.getToolWrapper())};
        }
        return this.myQuickFixActions;
    }

    @Override
    @NotNull
    public RefElementNode createRefNode(@Nullable RefEntity entity, @NotNull InspectionTreeModel model, @NotNull InspectionTreeNode parent) {
        return new UnusedDeclarationPresentation.UnusedDeclarationRefElementNode(entity, this, parent){

            @Override
            protected void visitProblemSeverities(@NotNull TObjectIntHashMap<HighlightDisplayLevel> counter) {
            }
        };
    }

    protected String getSeverityDelegateName() {
        return "unused";
    }

    @Override
    public void patchToolNode(@NotNull InspectionTreeNode node, @NotNull InspectionRVContentProvider provider, boolean showStructure, boolean groupByStructure) {
    }

    @Override
    protected boolean skipEntryPoints(RefJavaElement refElement) {
        return false;
    }

    @Override
    @NotNull
    public DeadHTMLComposer getComposer() {
        return new DeadHTMLComposer((InspectionToolPresentation)this);
    }

    public boolean isDummy() {
        return true;
    }

    private class MoveEntriesToSuspicious
    extends QuickFixAction {
        private MoveEntriesToSuspicious(InspectionToolWrapper toolWrapper) {
            super(AnalysisBundle.message((String)"inspection.dead.code.remove.user.defined.entry.point.quickfix", (Object[])new Object[0]), null, null, toolWrapper);
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            if (e.getPresentation().isEnabled()) {
                InspectionResultsView view = MoveEntriesToSuspicious.getInvoker((AnActionEvent)e);
                boolean permanentFound = false;
                for (RefEntity point : view.getTree().getSelectedElements()) {
                    if (!(point instanceof RefJavaElement) || !((RefJavaElement)point).isEntry() || !((RefJavaElement)point).isPermanentEntry()) continue;
                    permanentFound = true;
                    break;
                }
                if (!permanentFound) {
                    e.getPresentation().setEnabled(false);
                }
            }
        }

        protected boolean applyFix(RefEntity @NotNull [] refElements) {
            EntryPointsManager entryPointsManager = ((GlobalJavaInspectionContext)DummyEntryPointsPresentation.this.getContext().getExtension(GlobalJavaInspectionContext.CONTEXT)).getEntryPointsManager(DummyEntryPointsPresentation.this.getContext().getRefManager());
            for (RefEntity refElement : refElements) {
                if (!(refElement instanceof RefJavaElement) || !((RefJavaElement)refElement).isEntry() || !((RefJavaElement)refElement).isPermanentEntry()) continue;
                entryPointsManager.removeEntryPoint((RefElement)refElement);
            }
            return true;
        }
    }
}

