/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.SmartList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DfaVariableValue
extends DfaValue {
    @NotNull
    private final VariableDescriptor myDescriptor;
    private final PsiType myVarType;
    @Nullable
    private final DfaVariableValue myQualifier;
    private DfType myInherentType;
    private final List<DfaVariableValue> myDependents = new SmartList();

    private DfaVariableValue(@NotNull VariableDescriptor descriptor, @NotNull DfaValueFactory factory, @Nullable DfaVariableValue qualifier) {
        super(factory);
        this.myDescriptor = descriptor;
        this.myQualifier = qualifier;
        this.myVarType = descriptor.getType(qualifier);
        if (this.myDescriptor instanceof DfaExpressionFactory.AssertionDisabledDescriptor) {
            this.myFactory.setAssertionDisabled(this);
        }
    }

    @Nullable
    public PsiModifierListOwner getPsiVariable() {
        return this.myDescriptor.getPsiElement();
    }

    @NotNull
    public VariableDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    @Override
    @Nullable
    public PsiType getType() {
        return this.myVarType;
    }

    @Override
    public boolean dependsOn(DfaVariableValue other) {
        return other == this || this.myQualifier != null && this.myQualifier.dependsOn(other);
    }

    @NotNull
    public List<DfaVariableValue> getDependentVariables() {
        return this.myDependents;
    }

    public int getDepth() {
        int depth = 0;
        for (DfaVariableValue qualifier = this.getQualifier(); qualifier != null; qualifier = qualifier.getQualifier()) {
            ++depth;
        }
        return depth;
    }

    @NotNull
    @Contract(pure=true)
    public DfaVariableValue withQualifier(DfaVariableValue newQualifier) {
        return newQualifier == this.myQualifier ? this : this.myFactory.getVarFactory().createVariableValue(this.myDescriptor, newQualifier);
    }

    public String toString() {
        return (this.myQualifier == null ? "" : this.myQualifier + ".") + this.myDescriptor;
    }

    @Nullable
    public DfaVariableValue getQualifier() {
        return this.myQualifier;
    }

    public DfType getInherentType() {
        if (this.myInherentType == null) {
            this.myInherentType = this.calcInherentType();
        }
        return this.myInherentType;
    }

    private DfType calcInherentType() {
        LongRangeSet fromType;
        PsiType type2 = this.getType();
        DfType dfType = DfTypes.typedObject(type2, Nullability.UNKNOWN);
        if (this.myDescriptor instanceof SpecialField) {
            return dfType.meet(((SpecialField)this.myDescriptor).getDefaultValue(false));
        }
        PsiModifierListOwner psi = this.getPsiVariable();
        if (type2 instanceof PsiPrimitiveType && TypeConversionUtil.isIntegralNumberType((PsiType)type2) && (fromType = LongRangeSet.fromType(type2)) != null) {
            LongRangeSet range = LongRangeSet.fromPsiElement(psi).intersect(fromType);
            return type2.equals(PsiType.LONG) ? DfTypes.longRange(range) : DfTypes.intRange(range);
        }
        if (dfType instanceof DfReferenceType) {
            if (psi != null) {
                dfType = dfType.meet(Mutability.getMutability(psi).asDfType());
            }
            dfType = dfType.meet(NullabilityUtil.calcCanBeNull(this).asDfType());
        }
        return dfType;
    }

    @NotNull
    public Nullability getInherentNullability() {
        return DfaNullability.toNullability(DfaNullability.fromDfType(this.getInherentType()));
    }

    public boolean isFlushableByCalls() {
        return !this.myDescriptor.isStable() || this.myQualifier != null && this.myQualifier.isFlushableByCalls();
    }

    public boolean containsCalls() {
        return this.myDescriptor.isCall() || this.myQualifier != null && this.myQualifier.containsCalls();
    }

    public static class Factory {
        private final Map<Pair<VariableDescriptor, DfaVariableValue>, DfaVariableValue> myExistingVars = new HashMap<Pair<VariableDescriptor, DfaVariableValue>, DfaVariableValue>();
        private final DfaValueFactory myFactory;

        Factory(DfaValueFactory factory) {
            this.myFactory = factory;
        }

        @NotNull
        public DfaVariableValue createVariableValue(PsiVariable variable) {
            DfaVariableValue qualifier = null;
            if (variable instanceof PsiField && !variable.hasModifierProperty("static")) {
                qualifier = this.createThisValue(((PsiField)variable).getContainingClass());
            }
            return this.createVariableValue(new DfaExpressionFactory.PlainDescriptor(variable), qualifier);
        }

        @Contract(value="null -> null; !null -> !null")
        public DfaVariableValue createThisValue(@Nullable PsiClass aClass) {
            if (aClass == null) {
                return null;
            }
            return this.createVariableValue(new DfaExpressionFactory.ThisDescriptor(aClass));
        }

        @NotNull
        public DfaVariableValue createVariableValue(@NotNull VariableDescriptor descriptor) {
            return this.createVariableValue(descriptor, null);
        }

        @NotNull
        DfaVariableValue createVariableValue(@NotNull VariableDescriptor descriptor, @Nullable DfaVariableValue qualifier) {
            Pair key2 = Pair.create((Object)descriptor, (Object)qualifier);
            DfaVariableValue var = this.myExistingVars.get(key2);
            if (var == null) {
                var = new DfaVariableValue(descriptor, this.myFactory, qualifier);
                this.myExistingVars.put((Pair<VariableDescriptor, DfaVariableValue>)key2, var);
                while (qualifier != null) {
                    qualifier.myDependents.add(var);
                    qualifier = qualifier.getQualifier();
                }
            }
            return var;
        }
    }
}

