/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.dataFlow.TransferTarget;
import com.intellij.codeInspection.dataFlow.Trap;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaBinOpValue;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.PsiFieldImpl;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.containers.FactoryMap;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaValueFactory {
    @NotNull
    private final List<DfaValue> myValues = new ArrayList<DfaValue>();
    private final boolean myUnknownMembersAreNullable;
    @NotNull
    private final FieldChecker myFieldChecker;
    @NotNull
    private final Project myProject;
    @Nullable
    private DfaVariableValue myAssertionDisabled;
    private static final ElementPattern<? extends PsiModifierListOwner> MEMBER_OR_METHOD_PARAMETER = StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiMember(), PsiJavaPatterns.psiParameter().withSuperParent(2, (ElementPattern)PsiJavaPatterns.psiMember())});
    private final Map<Pair<TransferTarget, FList<Trap>>, DfaControlTransferValue> myControlTransfers = FactoryMap.create(p -> new DfaControlTransferValue(this, (TransferTarget)p.first, (FList<Trap>)((FList)p.second)));
    private final DfaVariableValue.Factory myVarFactory;
    private final DfaBoxedValue.Factory myBoxedFactory;
    private final DfaBinOpValue.Factory myBinOpFactory;
    private final DfaExpressionFactory myExpressionFactory;
    private final DfaTypeValue.Factory myTypeValueFactory;
    private final DfaValue mySentinelValue = new DfaValue(this){

        public String toString() {
            return "SENTINEL";
        }
    };

    public DfaValueFactory(@NotNull Project project, @Nullable PsiElement context, boolean unknownMembersAreNullable) {
        this.myProject = project;
        this.myFieldChecker = new FieldChecker(context);
        this.myUnknownMembersAreNullable = unknownMembersAreNullable;
        this.myValues.add(null);
        this.myVarFactory = new DfaVariableValue.Factory(this);
        this.myBoxedFactory = new DfaBoxedValue.Factory(this);
        this.myExpressionFactory = new DfaExpressionFactory(this);
        this.myBinOpFactory = new DfaBinOpValue.Factory(this);
        this.myTypeValueFactory = new DfaTypeValue.Factory(this);
    }

    public boolean canTrustFieldInitializer(PsiField field) {
        return this.myFieldChecker.canTrustFieldInitializer(field);
    }

    @NotNull
    public Nullability suggestNullabilityForNonAnnotatedMember(@NotNull PsiModifierListOwner member) {
        if (this.myUnknownMembersAreNullable && MEMBER_OR_METHOD_PARAMETER.accepts((Object)member) && AnnotationUtil.getSuperAnnotationOwners((PsiModifierListOwner)member).isEmpty()) {
            return Nullability.NULLABLE;
        }
        return Nullability.UNKNOWN;
    }

    @NotNull
    public DfaTypeValue getObjectType(@Nullable PsiType type2, @NotNull Nullability nullability) {
        return this.fromDfType(DfTypes.typedObject(type2, nullability));
    }

    @Nullable
    public DfaVariableValue getAssertionDisabled() {
        return this.myAssertionDisabled;
    }

    void setAssertionDisabled(@NotNull DfaVariableValue value2) {
        assert (this.myAssertionDisabled == null);
        this.myAssertionDisabled = value2;
    }

    int registerValue(DfaValue value2) {
        this.myValues.add(value2);
        return this.myValues.size() - 1;
    }

    public DfaValue getValue(int id) {
        return this.myValues.get(id);
    }

    @Nullable
    @Contract(value="null -> null")
    public DfaValue createValue(PsiExpression psiExpression) {
        return this.myExpressionFactory.getExpressionDfaValue(psiExpression);
    }

    @NotNull
    public DfaTypeValue getInt(int value2) {
        return this.fromDfType(DfTypes.intValue(value2));
    }

    @NotNull
    public DfaTypeValue getUnknown() {
        return this.fromDfType(DfTypes.TOP);
    }

    @NotNull
    public DfaValue getSentinel() {
        return this.mySentinelValue;
    }

    @NotNull
    public DfaTypeValue getBoolean(boolean value2) {
        return this.fromDfType(DfTypes.booleanValue(value2));
    }

    @NotNull
    public DfaTypeValue getNull() {
        return this.fromDfType(DfTypes.NULL);
    }

    public DfaTypeValue getConstant(Object value2, @NotNull PsiType type2) {
        return this.fromDfType(DfTypes.constant(value2, type2));
    }

    @Nullable
    public DfaValue getConstantFromVariable(PsiVariable variable) {
        if (!variable.hasModifierProperty("final") || DfaUtil.ignoreInitializer(variable)) {
            return null;
        }
        Object value2 = variable.computeConstantValue();
        PsiType type2 = variable.getType();
        if (value2 == null) {
            Boolean boo = DfaValueFactory.computeJavaLangBooleanFieldReference(variable);
            if (boo != null) {
                DfaTypeValue unboxed = this.getConstant(boo, (PsiType)PsiType.BOOLEAN);
                return this.getBoxedFactory().createBoxed(unboxed, (PsiType)PsiType.BOOLEAN.getBoxedType((PsiElement)variable));
            }
            if (DfaUtil.isEmptyCollectionConstantField(variable)) {
                return this.getConstant(variable, type2);
            }
            PsiExpression initializer = PsiFieldImpl.getDetachedInitializer(variable);
            if ((initializer = PsiUtil.skipParenthesizedExprDown((PsiExpression)initializer)) instanceof PsiLiteralExpression && initializer.textMatches((CharSequence)"null")) {
                return this.getNull();
            }
            if (variable instanceof PsiField && variable.hasModifierProperty("static") && ExpressionUtils.isNewObject(initializer)) {
                return this.getConstant(variable, type2);
            }
            return null;
        }
        return this.getConstant(value2, type2);
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    private static Boolean computeJavaLangBooleanFieldReference(PsiVariable variable) {
        if (!(variable instanceof PsiField)) {
            return null;
        }
        PsiClass psiClass = ((PsiField)variable).getContainingClass();
        if (psiClass == null || !"java.lang.Boolean".equals(psiClass.getQualifiedName())) {
            return null;
        }
        String name2 = variable.getName();
        return "TRUE".equals(name2) ? Boolean.TRUE : ("FALSE".equals(name2) ? Boolean.FALSE : null);
    }

    @NotNull
    public DfaTypeValue fromDfType(@NotNull DfType dfType) {
        return this.myTypeValueFactory.create(dfType);
    }

    public Collection<DfaValue> getValues() {
        return Collections.unmodifiableCollection(this.myValues);
    }

    @NotNull
    public DfaControlTransferValue controlTransfer(TransferTarget kind2, FList<Trap> traps) {
        return this.myControlTransfers.get(Pair.create((Object)kind2, traps));
    }

    @NotNull
    public DfaVariableValue.Factory getVarFactory() {
        return this.myVarFactory;
    }

    @NotNull
    public DfaBoxedValue.Factory getBoxedFactory() {
        return this.myBoxedFactory;
    }

    @NotNull
    public DfaExpressionFactory getExpressionFactory() {
        return this.myExpressionFactory;
    }

    @NotNull
    public DfaBinOpValue.Factory getBinOpFactory() {
        return this.myBinOpFactory;
    }

    @NotNull
    public DfaValue createCommonValue(PsiExpression @NotNull [] expressions2, PsiType targetType) {
        DfaValue loopElement = null;
        for (PsiExpression expression2 : expressions2) {
            DfaValue expressionValue = this.createValue(expression2);
            if (expressionValue == null) {
                expressionValue = this.getObjectType(expression2.getType(), NullabilityUtil.getExpressionNullability(expression2));
            }
            DfaValue dfaValue = loopElement = loopElement == null ? expressionValue : loopElement.unite(expressionValue);
            if (DfaTypeValue.isUnknown(loopElement)) break;
        }
        return loopElement == null ? this.getUnknown() : DfaUtil.boxUnbox(loopElement, targetType);
    }

    private static class FieldChecker {
        private final boolean myTrustDirectFieldInitializers;
        private final boolean myTrustFieldInitializersInConstructors;
        private final boolean myCanInstantiateItself;
        private final PsiClass myClass;

        FieldChecker(PsiElement context) {
            PsiClass contextClass;
            PsiMethod method;
            PsiMethod psiMethod = method = context instanceof PsiClass ? null : (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)context, PsiMethod.class);
            this.myClass = contextClass = method != null ? method.getContainingClass() : (context instanceof PsiClass ? (PsiClass)context : null);
            if (method == null || this.myClass == null) {
                this.myCanInstantiateItself = false;
                this.myTrustFieldInitializersInConstructors = false;
                this.myTrustDirectFieldInitializers = false;
                return;
            }
            ClassInitializationInfo info = (ClassInitializationInfo)CachedValuesManager.getCachedValue((PsiElement)contextClass, () -> CachedValueProvider.Result.create((Object)new ClassInitializationInfo(contextClass), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
            this.myCanInstantiateItself = info.myCanInstantiateItself;
            if (method.hasModifierProperty("static") || method.isConstructor()) {
                this.myTrustDirectFieldInitializers = true;
                this.myTrustFieldInitializersInConstructors = false;
                return;
            }
            this.myTrustFieldInitializersInConstructors = !info.mySuperCtorsCallMethods && !info.myCtorsCallMethods;
            this.myTrustDirectFieldInitializers = !info.mySuperCtorsCallMethods;
        }

        boolean canTrustFieldInitializer(PsiField field) {
            if (field.hasInitializer()) {
                boolean staticField = field.hasModifierProperty("static");
                if (staticField && this.myClass != null && field.getContainingClass() != this.myClass) {
                    return true;
                }
                return this.myTrustDirectFieldInitializers && (!this.myCanInstantiateItself || !staticField);
            }
            return this.myTrustFieldInitializersInConstructors;
        }
    }

    private static class ClassInitializationInfo {
        private static final CallMatcher SAFE_CALLS = CallMatcher.staticCall("java.util.Objects", "requireNonNull");
        final boolean myCanInstantiateItself;
        final boolean myCtorsCallMethods;
        final boolean mySuperCtorsCallMethods;

        ClassInitializationInfo(@NotNull PsiClass psiClass) {
            boolean canInstantiateItself = false;
            for (PsiElement child = psiClass.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!(child instanceof PsiMember) || !((PsiMember)child).hasModifierProperty("static") || SyntaxTraverser.psiTraverser((PsiElement)child).filter(PsiNewExpression.class).filterMap(PsiNewExpression::getClassReference).find(classRef -> classRef.isReferenceTo((PsiElement)psiClass)) == null) continue;
                canInstantiateItself = true;
                break;
            }
            this.myCanInstantiateItself = canInstantiateItself;
            this.mySuperCtorsCallMethods = !InheritanceUtil.processSupers((PsiClass)psiClass, (boolean)false, superClass -> !ClassInitializationInfo.canCallMethodsInConstructors(superClass, true));
            this.myCtorsCallMethods = ClassInitializationInfo.canCallMethodsInConstructors(psiClass, false);
        }

        private static boolean canCallMethodsInConstructors(@NotNull PsiClass aClass, boolean virtual) {
            boolean inByteCode = false;
            if (aClass instanceof PsiCompiledElement) {
                inByteCode = true;
                PsiElement navigationElement = aClass.getNavigationElement();
                if (navigationElement instanceof PsiClass) {
                    aClass = (PsiClass)navigationElement;
                }
            }
            for (PsiMethod constructor : aClass.getConstructors()) {
                if (inByteCode && JavaMethodContractUtil.isPure(constructor) && !JavaMethodContractUtil.hasExplicitContractAnnotation(constructor)) continue;
                if (!constructor.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
                    return true;
                }
                PsiCodeBlock body2 = constructor.getBody();
                if (body2 == null) continue;
                for (PsiMethodCallExpression call : ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)body2)).filter(PsiMethodCallExpression.class)) {
                    PsiReferenceExpression methodExpression = call.getMethodExpression();
                    if (methodExpression.textMatches((CharSequence)"this") || methodExpression.textMatches((CharSequence)"super") || SAFE_CALLS.test(call)) continue;
                    if (!virtual) {
                        return true;
                    }
                    PsiMethod target = call.resolveMethod();
                    if (target == null || !PsiUtil.canBeOverridden((PsiMethod)target)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

