/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaBinOpValue;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaCondition;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class DfaRelation
extends DfaCondition {
    @NotNull
    private final DfaValue myLeftOperand;
    @NotNull
    private final DfaValue myRightOperand;
    @NotNull
    private final RelationType myRelation;

    @Override
    @NotNull
    public DfaRelation negate() {
        return new DfaRelation(this.myLeftOperand, this.myRightOperand, this.myRelation.getNegated());
    }

    private DfaRelation(@NotNull DfaValue leftOperand2, @NotNull DfaValue rightOperand2, @NotNull RelationType relationType) {
        this.myLeftOperand = leftOperand2;
        this.myRightOperand = rightOperand2;
        this.myRelation = relationType;
    }

    @NotNull
    public DfaValue getLeftOperand() {
        return this.myLeftOperand;
    }

    @NotNull
    public DfaValue getRightOperand() {
        return this.myRightOperand;
    }

    public static DfaRelation createRelation(@NotNull DfaValue dfaLeft, @NotNull RelationType relationType, @NotNull DfaValue dfaRight) {
        if ((relationType == RelationType.IS || relationType == RelationType.IS_NOT) && dfaRight instanceof DfaTypeValue && !(dfaLeft instanceof DfaTypeValue)) {
            return new DfaRelation(dfaLeft, dfaRight, relationType);
        }
        if (dfaLeft instanceof DfaVariableValue || dfaLeft instanceof DfaBoxedValue || dfaLeft instanceof DfaBinOpValue || dfaRight instanceof DfaVariableValue || dfaRight instanceof DfaBoxedValue || dfaRight instanceof DfaBinOpValue) {
            if (!(dfaLeft instanceof DfaVariableValue) && !(dfaLeft instanceof DfaBoxedValue) && !(dfaLeft instanceof DfaBinOpValue) || dfaRight instanceof DfaBinOpValue && !(dfaLeft instanceof DfaBinOpValue)) {
                RelationType flipped = relationType.getFlipped();
                return flipped == null ? null : new DfaRelation(dfaRight, dfaLeft, flipped);
            }
            return new DfaRelation(dfaLeft, dfaRight, relationType);
        }
        if (dfaLeft instanceof DfaTypeValue && dfaRight.getDfType() instanceof DfConstantType) {
            return DfaRelation.createConstBasedRelation((DfaTypeValue)dfaLeft, relationType, dfaRight);
        }
        if (dfaRight instanceof DfaTypeValue && dfaLeft.getDfType() instanceof DfConstantType) {
            return DfaRelation.createConstBasedRelation((DfaTypeValue)dfaRight, relationType, dfaLeft);
        }
        return null;
    }

    @NotNull
    private static DfaRelation createConstBasedRelation(DfaTypeValue dfaLeft, RelationType relationType, DfaValue dfaRight) {
        if (dfaRight.getDfType() == DfTypes.NULL && DfaNullability.fromDfType(dfaLeft.getDfType()) == DfaNullability.NULLABLE) {
            return new DfaRelation(dfaLeft.getFactory().fromDfType(DfaNullability.NULLABLE.asDfType()), dfaRight, relationType);
        }
        return new DfaRelation(dfaLeft.getFactory().getUnknown(), dfaRight, relationType);
    }

    public boolean isEquality() {
        return this.myRelation == RelationType.EQ;
    }

    public boolean isNonEquality() {
        return this.myRelation == RelationType.NE || this.myRelation == RelationType.GT || this.myRelation == RelationType.LT;
    }

    @NotNull
    public RelationType getRelation() {
        return this.myRelation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DfaRelation relation = (DfaRelation)o;
        return this.myLeftOperand == relation.myLeftOperand && this.myRightOperand == relation.myRightOperand && this.myRelation == relation.myRelation;
    }

    public int hashCode() {
        int result = 31 + this.myLeftOperand.hashCode();
        result = 31 * result + this.myRightOperand.hashCode();
        result = 31 * result + this.myRelation.hashCode();
        return result;
    }

    @NonNls
    public String toString() {
        return this.myLeftOperand + " " + (Object)((Object)this.myRelation) + " " + this.myRightOperand;
    }
}

