/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ConcurrencyAnnotationsManager;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.impl.light.LightRecordMethod;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.LongStream;
import one.util.streamex.LongStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaExpressionFactory {
    private final DfaValueFactory myFactory;
    private final Map<Integer, ArrayElementDescriptor> myArrayIndices = new HashMap<Integer, ArrayElementDescriptor>();

    DfaExpressionFactory(DfaValueFactory factory) {
        this.myFactory = factory;
    }

    @Nullable
    @Contract(value="null -> null")
    DfaValue getExpressionDfaValue(@Nullable PsiExpression expression2) {
        PsiType type2;
        DfaValue qualifier;
        if (expression2 == null) {
            return null;
        }
        if (expression2 instanceof PsiParenthesizedExpression) {
            return this.getExpressionDfaValue(((PsiParenthesizedExpression)expression2).getExpression());
        }
        if (expression2 instanceof PsiArrayAccessExpression) {
            DfaValue arrayElementValue;
            Object index;
            PsiExpression arrayExpression = ((PsiArrayAccessExpression)expression2).getArrayExpression();
            qualifier = this.getQualifierValue(arrayExpression);
            if (qualifier != null && (index = ExpressionUtils.computeConstantExpression(((PsiArrayAccessExpression)expression2).getIndexExpression())) instanceof Integer && (arrayElementValue = this.getArrayElementValue(qualifier, (Integer)index)) != null) {
                return arrayElementValue;
            }
            PsiType type3 = expression2.getType();
            if (type3 != null) {
                return this.myFactory.getObjectType(type3, DfaPsiUtil.getElementNullability(type3, null));
            }
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            return this.createReferenceValue(((PsiMethodCallExpression)expression2).getMethodExpression());
        }
        if (expression2 instanceof PsiReferenceExpression) {
            return this.createReferenceValue((PsiReferenceExpression)expression2);
        }
        if (expression2 instanceof PsiLiteralExpression) {
            return this.myFactory.fromDfType(DfaPsiUtil.fromLiteral((PsiLiteralExpression)expression2));
        }
        if (expression2 instanceof PsiNewExpression || expression2 instanceof PsiLambdaExpression) {
            return this.myFactory.getObjectType(expression2.getType(), Nullability.NOT_NULL);
        }
        Object value2 = JavaConstantExpressionEvaluator.computeConstantExpression(expression2, false);
        if (value2 != null && (type2 = expression2.getType()) != null) {
            return this.myFactory.getConstant(value2, type2);
        }
        if (expression2 instanceof PsiThisExpression || expression2 instanceof PsiSuperExpression) {
            qualifier = ((PsiQualifiedExpression)expression2).getQualifier();
            PsiClass target = qualifier != null ? (PsiClass)ObjectUtils.tryCast((Object)qualifier.resolve(), PsiClass.class) : ClassUtils.getContainingClass((PsiElement)expression2);
            return target == null ? this.myFactory.getObjectType(expression2.getType(), Nullability.NOT_NULL) : this.myFactory.getVarFactory().createThisValue(target);
        }
        return null;
    }

    private DfaValue createReferenceValue(@NotNull PsiReferenceExpression refExpr) {
        VariableDescriptor var;
        PsiElement target = refExpr.resolve();
        if (target instanceof PsiVariable) {
            DfaValue constValue;
            PsiVariable variable = (PsiVariable)target;
            if (!PsiUtil.isAccessedForWriting((PsiExpression)refExpr) && (constValue = this.myFactory.getConstantFromVariable(variable)) != null && !DfaExpressionFactory.maybeUninitializedConstant(constValue, refExpr, (PsiModifierListOwner)variable)) {
                return constValue;
            }
        }
        if ((var = DfaExpressionFactory.getAccessedVariableOrGetter(target)) == null) {
            return null;
        }
        DfaValue qualifier = this.getQualifierOrThisValue(refExpr);
        DfaValue result = var.createValue(this.myFactory, qualifier, true);
        if (var instanceof SpecialField) {
            PsiType wantedType = refExpr.getType();
            result = DfaUtil.boxUnbox(result, wantedType);
        }
        return result;
    }

    @Nullable
    public DfaValue getQualifierOrThisValue(PsiReferenceExpression refExpr) {
        PsiElement element;
        PsiExpression qualifierExpression2 = refExpr.getQualifierExpression();
        if (qualifierExpression2 == null && (element = refExpr.resolve()) instanceof PsiMember && !((PsiMember)element).hasModifierProperty("static")) {
            PsiClass currentClass = ClassUtils.getContainingClass((PsiElement)refExpr);
            PsiClass memberClass = ((PsiMember)element).getContainingClass();
            if (memberClass != null && currentClass != null) {
                PsiClass target = currentClass == memberClass || InheritanceUtil.isInheritorOrSelf((PsiClass)currentClass, (PsiClass)memberClass, (boolean)true) ? currentClass : memberClass;
                return this.myFactory.getVarFactory().createThisValue(target);
            }
        }
        return this.getQualifierValue(qualifierExpression2);
    }

    @Nullable
    private DfaValue getQualifierValue(PsiExpression qualifierExpression2) {
        DfaValue qualifierValue = this.getExpressionDfaValue(qualifierExpression2);
        if (qualifierValue == null) {
            return null;
        }
        PsiVariable constVar = DfConstantType.getConstantOfType(qualifierValue.getDfType(), PsiVariable.class);
        if (constVar != null) {
            return this.myFactory.getVarFactory().createVariableValue(constVar);
        }
        return qualifierValue;
    }

    private static boolean maybeUninitializedConstant(DfaValue constValue, @NotNull PsiReferenceExpression refExpr, PsiModifierListOwner var) {
        if (!DfConstantType.isConst(constValue.getDfType(), var)) {
            return false;
        }
        if (!(var instanceof PsiField) || var instanceof PsiEnumConstant) {
            return false;
        }
        return PsiTreeUtil.getTopmostParentOfType((PsiElement)refExpr, PsiClass.class) == PsiTreeUtil.getTopmostParentOfType((PsiElement)var, PsiClass.class);
    }

    @Contract(value="null -> null")
    @Nullable
    public static VariableDescriptor getAccessedVariableOrGetter(PsiElement target) {
        PsiMethod method;
        SpecialField sf = SpecialField.findSpecialField(target);
        if (sf != null) {
            return sf;
        }
        if (target instanceof PsiVariable) {
            return new PlainDescriptor((PsiVariable)target);
        }
        if (target instanceof PsiMethod && (method = (PsiMethod)target).getParameterList().isEmpty() && (PropertyUtilBase.isSimplePropertyGetter((PsiMethod)method) || JavaMethodContractUtil.isPure(method) || DfaExpressionFactory.isClassAnnotatedImmutable(method)) && DfaExpressionFactory.isContractAllowedForGetter(method)) {
            return new GetterDescriptor(method);
        }
        return null;
    }

    private static boolean isClassAnnotatedImmutable(PsiMethod method) {
        List annotations = ConcurrencyAnnotationsManager.getInstance((Project)method.getProject()).getImmutableAnnotations();
        return AnnotationUtil.findAnnotation((PsiModifierListOwner)method.getContainingClass(), (Collection)annotations) != null;
    }

    private static boolean isContractAllowedForGetter(PsiMethod method) {
        List<? extends MethodContract> contracts2 = JavaMethodContractUtil.getMethodCallContracts(method, null);
        if (contracts2.size() == 1) {
            MethodContract contract = contracts2.get(0);
            return contract.isTrivial() && contract.getReturnValue().equals(ContractReturnValue.returnNew());
        }
        return contracts2.isEmpty();
    }

    @NotNull
    private DfaValue getAdvancedExpressionDfaValue(@Nullable PsiExpression expression2, @Nullable PsiType targetType) {
        if (expression2 == null) {
            return this.myFactory.getUnknown();
        }
        DfaValue value2 = this.getExpressionDfaValue(expression2);
        if (value2 != null) {
            return DfaUtil.boxUnbox(value2, targetType);
        }
        if (expression2 instanceof PsiConditionalExpression) {
            return this.getAdvancedExpressionDfaValue(((PsiConditionalExpression)expression2).getThenExpression(), targetType).unite(this.getAdvancedExpressionDfaValue(((PsiConditionalExpression)expression2).getElseExpression(), targetType));
        }
        PsiType type2 = expression2.getType();
        if (expression2 instanceof PsiArrayInitializerExpression) {
            int length = ((PsiArrayInitializerExpression)expression2).getInitializers().length;
            return this.myFactory.fromDfType(SpecialField.ARRAY_LENGTH.asDfType(DfTypes.intValue(length), type2));
        }
        DfType dfType = DfTypes.typedObject(type2, NullabilityUtil.getExpressionNullability(expression2));
        return DfaUtil.boxUnbox(this.myFactory.fromDfType(dfType), targetType);
    }

    @NotNull
    public DfaValue getArrayElementValue(DfaValue array, LongRangeSet indexSet) {
        long max;
        if (!(array instanceof DfaVariableValue)) {
            return this.myFactory.getUnknown();
        }
        if (indexSet.isEmpty()) {
            return this.myFactory.getUnknown();
        }
        long min = indexSet.min();
        if (min == (max = indexSet.max()) && min >= 0L && min < Integer.MAX_VALUE) {
            DfaValue value3 = this.getArrayElementValue(array, (int)min);
            return value3 == null ? this.myFactory.getUnknown() : value3;
        }
        DfaVariableValue arrayDfaVar = (DfaVariableValue)array;
        PsiModifierListOwner arrayPsiVar = arrayDfaVar.getPsiVariable();
        if (!(arrayPsiVar instanceof PsiVariable)) {
            return this.myFactory.getUnknown();
        }
        PsiType arrayType = ((PsiVariable)arrayPsiVar).getType();
        PsiType targetType = arrayType instanceof PsiArrayType ? ((PsiArrayType)arrayType).getComponentType() : null;
        PsiExpression[] elements = ExpressionUtils.getConstantArrayElements((PsiVariable)arrayPsiVar);
        if (elements == null || elements.length == 0) {
            return this.myFactory.getUnknown();
        }
        if ((indexSet = indexSet.intersect(LongRangeSet.range(0L, elements.length - 1))).isEmpty() || indexSet.isCardinalityBigger(100L)) {
            return this.myFactory.getUnknown();
        }
        return ((StreamEx)((StreamEx)LongStreamEx.of((LongStream)indexSet.stream()).mapToObj(idx -> this.getAdvancedExpressionDfaValue(elements[(int)idx], targetType)).prefix(DfaValue::unite)).takeWhileInclusive(value2 -> !DfaTypeValue.isUnknown(value2))).reduce((a, b) -> b).orElseGet(this.myFactory::getUnknown);
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public DfaValue getArrayElementValue(DfaValue array, int index) {
        PsiExpression constantArrayElement;
        if (!(array instanceof DfaVariableValue)) {
            return null;
        }
        DfaVariableValue arrayDfaVar = (DfaVariableValue)array;
        PsiType type2 = arrayDfaVar.getType();
        if (!(type2 instanceof PsiArrayType)) {
            return null;
        }
        PsiModifierListOwner arrayPsiVar = arrayDfaVar.getPsiVariable();
        if (arrayPsiVar instanceof PsiVariable && (constantArrayElement = ExpressionUtils.getConstantArrayElement((PsiVariable)arrayPsiVar, index)) != null) {
            return this.getAdvancedExpressionDfaValue(constantArrayElement, ((PsiArrayType)type2).getComponentType());
        }
        ArrayElementDescriptor indexVariable = this.getArrayIndexVariable(index);
        if (indexVariable == null) {
            return null;
        }
        return indexVariable.createValue(this.myFactory, arrayDfaVar);
    }

    @Nullable
    private ArrayElementDescriptor getArrayIndexVariable(int index) {
        if (index >= 0) {
            return this.myArrayIndices.computeIfAbsent(index, ArrayElementDescriptor::new);
        }
        return null;
    }

    @NotNull
    private static PsiSubstitutor getSubstitutor(PsiElement member, @Nullable DfaVariableValue qualifier) {
        if (member instanceof PsiMember && qualifier != null) {
            PsiClass fieldClass = ((PsiMember)member).getContainingClass();
            PsiClassType classType = (PsiClassType)ObjectUtils.tryCast((Object)qualifier.getType(), PsiClassType.class);
            if (classType != null && InheritanceUtil.isInheritorOrSelf((PsiClass)classType.resolve(), (PsiClass)fieldClass, (boolean)true)) {
                return TypeConversionUtil.getSuperClassSubstitutor((PsiClass)fieldClass, (PsiClassType)classType);
            }
        }
        return PsiSubstitutor.EMPTY;
    }

    public DfaVariableValue getAssertionsDisabledVariable() {
        return this.myFactory.getVarFactory().createVariableValue(AssertionDisabledDescriptor.INSTANCE);
    }

    public static final class ThisDescriptor
    implements VariableDescriptor {
        @NotNull
        private final PsiClass myQualifier;

        ThisDescriptor(@NotNull PsiClass qualifier) {
            this.myQualifier = qualifier;
        }

        @NotNull
        public String toString() {
            return this.myQualifier.getName() + ".this";
        }

        @Override
        @NotNull
        public PsiType getType(@Nullable DfaVariableValue qualifier) {
            return new PsiImmediateClassType(this.myQualifier, PsiSubstitutor.EMPTY);
        }

        public PsiClass getPsiElement() {
            return this.myQualifier;
        }

        @Override
        public boolean isStable() {
            return true;
        }

        public int hashCode() {
            return Objects.hashCode(this.myQualifier.getQualifiedName());
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof ThisDescriptor && ((ThisDescriptor)obj).myQualifier == this.myQualifier;
        }
    }

    public static final class ArrayElementDescriptor
    implements VariableDescriptor {
        private final int myIndex;

        ArrayElementDescriptor(int index) {
            this.myIndex = index;
        }

        public int getIndex() {
            return this.myIndex;
        }

        @Override
        @Nullable
        public PsiType getType(@Nullable DfaVariableValue qualifier) {
            if (qualifier == null) {
                return null;
            }
            PsiType qualifierType = qualifier.getType();
            return qualifierType instanceof PsiArrayType ? ((PsiArrayType)qualifierType).getComponentType() : null;
        }

        @NotNull
        public String toString() {
            return "[" + this.myIndex + "]";
        }

        @Override
        public boolean isStable() {
            return false;
        }
    }

    public static final class GetterDescriptor
    implements VariableDescriptor {
        private static final CallMatcher STABLE_METHODS = CallMatcher.anyOf(CallMatcher.instanceCall("java.lang.Object", "getClass").parameterCount(0), CallMatcher.instanceCall("java.lang.reflect.Member", "getName", "getModifiers", "getDeclaringClass", "isSynthetic"), CallMatcher.instanceCall("java.lang.reflect.Executable", "getParameterCount", "isVarArgs"), CallMatcher.instanceCall("java.lang.reflect.Field", "getType"), CallMatcher.instanceCall("java.lang.reflect.Method", "getReturnType"), CallMatcher.instanceCall("java.lang.Class", "getName", "isInterface", "isArray", "isPrimitive", "isSynthetic", "isAnonymousClass", "isLocalClass", "isMemberClass", "getDeclaringClass", "getEnclosingClass", "getSimpleName", "getCanonicalName"));
        @NotNull
        private final PsiMethod myGetter;
        private final boolean myStable;

        public GetterDescriptor(@NotNull PsiMethod getter) {
            this.myGetter = getter;
            if (STABLE_METHODS.methodMatches(getter) || getter instanceof LightRecordMethod) {
                this.myStable = true;
            } else {
                PsiField field = PsiUtil.canBeOverridden((PsiMethod)getter) ? null : PropertyUtil.getFieldOfGetter(getter);
                this.myStable = field != null && field.hasModifierProperty("final");
            }
        }

        @NotNull
        public String toString() {
            return this.myGetter.getName();
        }

        @Override
        @Nullable
        public PsiType getType(@Nullable DfaVariableValue qualifier) {
            return DfaExpressionFactory.getSubstitutor((PsiElement)this.myGetter, qualifier).substitute(this.myGetter.getReturnType());
        }

        @NotNull
        public PsiMethod getPsiElement() {
            return this.myGetter;
        }

        @Override
        public boolean isStable() {
            return this.myStable;
        }

        @Override
        public boolean isCall() {
            return true;
        }

        @Override
        @NotNull
        public DfaValue createValue(@NotNull DfaValueFactory factory, @Nullable DfaValue qualifier, boolean forAccessor) {
            if (this.myGetter.hasModifierProperty("static")) {
                return factory.getVarFactory().createVariableValue(this);
            }
            return VariableDescriptor.super.createValue(factory, qualifier, forAccessor);
        }

        public int hashCode() {
            return Objects.hashCode(this.myGetter.getName());
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof GetterDescriptor && ((GetterDescriptor)obj).myGetter == this.myGetter;
        }
    }

    static final class PlainDescriptor
    implements VariableDescriptor {
        @NotNull
        private final PsiVariable myVariable;

        PlainDescriptor(@NotNull PsiVariable variable) {
            this.myVariable = variable;
        }

        @NotNull
        public String toString() {
            return String.valueOf(this.myVariable.getName());
        }

        @Override
        public PsiType getType(@Nullable DfaVariableValue qualifier) {
            PsiType type2 = this.myVariable.getType();
            if (type2 instanceof PsiEllipsisType) {
                type2 = ((PsiEllipsisType)type2).toArrayType();
            }
            return DfaExpressionFactory.getSubstitutor((PsiElement)this.myVariable, qualifier).substitute(type2);
        }

        public PsiVariable getPsiElement() {
            return this.myVariable;
        }

        @Override
        public boolean isStable() {
            return PsiUtil.isJvmLocalVariable((PsiElement)this.myVariable) || this.myVariable.hasModifierProperty("final");
        }

        @Override
        @NotNull
        public DfaValue createValue(@NotNull DfaValueFactory factory, @Nullable DfaValue qualifier, boolean forAccessor) {
            if (this.myVariable.hasModifierProperty("volatile")) {
                PsiType type2 = this.getType((DfaVariableValue)ObjectUtils.tryCast((Object)qualifier, DfaVariableValue.class));
                return factory.getObjectType(type2, DfaPsiUtil.getElementNullability(type2, (PsiModifierListOwner)this.myVariable));
            }
            if (PsiUtil.isJvmLocalVariable((PsiElement)this.myVariable) || this.myVariable instanceof PsiField && this.myVariable.hasModifierProperty("static") && (!this.myVariable.hasModifierProperty("final") || !DfaUtil.hasInitializationHacks((PsiField)this.myVariable))) {
                return factory.getVarFactory().createVariableValue(this);
            }
            return VariableDescriptor.super.createValue(factory, qualifier, forAccessor);
        }

        public int hashCode() {
            return Objects.hashCode(this.myVariable.getName());
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof PlainDescriptor && ((PlainDescriptor)obj).myVariable == this.myVariable;
        }
    }

    public static final class AssertionDisabledDescriptor
    implements VariableDescriptor {
        static final AssertionDisabledDescriptor INSTANCE = new AssertionDisabledDescriptor();

        private AssertionDisabledDescriptor() {
        }

        @Override
        public boolean isStable() {
            return true;
        }

        @Override
        @NotNull
        public PsiType getType(@Nullable DfaVariableValue qualifier) {
            return PsiType.BOOLEAN;
        }

        public String toString() {
            return "$assertionsDisabled";
        }
    }
}

