/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.types;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfBooleanConstantType;
import com.intellij.codeInspection.dataFlow.types.DfBooleanType;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfDoubleConstantType;
import com.intellij.codeInspection.dataFlow.types.DfDoubleType;
import com.intellij.codeInspection.dataFlow.types.DfFloatConstantType;
import com.intellij.codeInspection.dataFlow.types.DfFloatType;
import com.intellij.codeInspection.dataFlow.types.DfGenericObjectType;
import com.intellij.codeInspection.dataFlow.types.DfIntConstantType;
import com.intellij.codeInspection.dataFlow.types.DfIntRangeType;
import com.intellij.codeInspection.dataFlow.types.DfIntType;
import com.intellij.codeInspection.dataFlow.types.DfLongConstantType;
import com.intellij.codeInspection.dataFlow.types.DfLongRangeType;
import com.intellij.codeInspection.dataFlow.types.DfLongType;
import com.intellij.codeInspection.dataFlow.types.DfNullConstantType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceConstantType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfTypes {
    public static final DfType TOP = new DfType(){

        @Override
        public boolean isSuperType(@NotNull DfType other) {
            return true;
        }

        @Override
        @NotNull
        public DfType join(@NotNull DfType other) {
            return this;
        }

        @Override
        @NotNull
        public DfType meet(@NotNull DfType other) {
            return other;
        }

        @Override
        @NotNull
        public DfType tryNegate() {
            return BOTTOM;
        }

        public int hashCode() {
            return 1254215;
        }

        public String toString() {
            return "TOP";
        }
    };
    public static final DfType BOTTOM = new DfType(){

        @Override
        public boolean isSuperType(@NotNull DfType other) {
            return other == this;
        }

        @Override
        @NotNull
        public DfType join(@NotNull DfType other) {
            return other;
        }

        @Override
        @NotNull
        public DfType meet(@NotNull DfType other) {
            return this;
        }

        @Override
        @NotNull
        public DfType tryNegate() {
            return TOP;
        }

        public int hashCode() {
            return 67532141;
        }

        public String toString() {
            return "BOTTOM";
        }
    };
    public static final DfType FAIL = new DfConstantType<Object>(ObjectUtils.sentinel((String)"FAIL")){

        @Override
        @NotNull
        public PsiType getPsiType() {
            return PsiType.VOID;
        }

        @Override
        @NotNull
        public DfType join(@NotNull DfType other) {
            return other == this ? this : TOP;
        }

        @Override
        @NotNull
        public DfType meet(@NotNull DfType other) {
            return other == this ? this : BOTTOM;
        }

        @Override
        public int hashCode() {
            return 5362412;
        }
    };
    public static final DfBooleanType BOOLEAN = new DfBooleanType(){

        @Override
        public boolean isSuperType(@NotNull DfType other) {
            return other == BOTTOM || other instanceof DfBooleanType;
        }

        @Override
        @NotNull
        public DfType join(@NotNull DfType other) {
            if (other instanceof DfBooleanType) {
                return this;
            }
            return TOP;
        }

        @Override
        @NotNull
        public DfType meet(@NotNull DfType other) {
            if (other == TOP) {
                return this;
            }
            if (other instanceof DfBooleanType) {
                return other;
            }
            return BOTTOM;
        }

        @Override
        @NotNull
        public DfType tryNegate() {
            return BOTTOM;
        }

        public int hashCode() {
            return 345661;
        }

        public String toString() {
            return "boolean";
        }
    };
    public static final DfBooleanConstantType TRUE = new DfBooleanConstantType(true);
    public static final DfBooleanConstantType FALSE = new DfBooleanConstantType(false);
    public static final DfIntType INT = new DfIntRangeType(LongRangeSet.fromType((PsiType)PsiType.INT));
    public static final DfLongType LONG = new DfLongRangeType(LongRangeSet.all());
    public static final DfFloatType FLOAT = new DfFloatType(){

        @Override
        public boolean isSuperType(@NotNull DfType other) {
            return other == BOTTOM || other instanceof DfFloatType;
        }

        @Override
        @NotNull
        public DfType join(@NotNull DfType other) {
            if (other instanceof DfFloatType) {
                return this;
            }
            return TOP;
        }

        @Override
        @NotNull
        public DfType meet(@NotNull DfType other) {
            if (other == TOP) {
                return this;
            }
            if (other instanceof DfFloatType) {
                return other;
            }
            return BOTTOM;
        }

        @Override
        @NotNull
        public DfType tryNegate() {
            return BOTTOM;
        }

        public int hashCode() {
            return 521441254;
        }

        public String toString() {
            return "float";
        }
    };
    public static final DfDoubleType DOUBLE = new DfDoubleType(){

        @Override
        public boolean isSuperType(@NotNull DfType other) {
            return other == BOTTOM || other instanceof DfDoubleType;
        }

        @Override
        @NotNull
        public DfType join(@NotNull DfType other) {
            if (other instanceof DfDoubleType) {
                return this;
            }
            return TOP;
        }

        @Override
        @NotNull
        public DfType meet(@NotNull DfType other) {
            if (other == TOP) {
                return this;
            }
            if (other instanceof DfDoubleType) {
                return other;
            }
            return BOTTOM;
        }

        @Override
        @NotNull
        public DfType tryNegate() {
            return BOTTOM;
        }

        public int hashCode() {
            return 5645123;
        }

        public String toString() {
            return "double";
        }
    };
    public static final DfNullConstantType NULL = new DfNullConstantType();
    public static final DfReferenceType NOT_NULL_OBJECT = DfTypes.customObject(TypeConstraints.TOP, DfaNullability.NOT_NULL, Mutability.UNKNOWN, null, BOTTOM);
    public static final DfReferenceType OBJECT_OR_NULL = DfTypes.customObject(TypeConstraints.TOP, DfaNullability.UNKNOWN, Mutability.UNKNOWN, null, BOTTOM);
    public static final DfReferenceType LOCAL_OBJECT = new DfGenericObjectType(Collections.emptySet(), TypeConstraints.TOP, DfaNullability.NOT_NULL, Mutability.UNKNOWN, null, BOTTOM, true);

    private DfTypes() {
    }

    public static DfBooleanConstantType booleanValue(boolean value2) {
        return value2 ? TRUE : FALSE;
    }

    @NotNull
    public static DfType intRangeClamped(LongRangeSet range) {
        return DfTypes.intRange(range.intersect(DfIntRangeType.FULL_RANGE));
    }

    @NotNull
    public static DfType intRange(LongRangeSet range) {
        if (range.equals(DfIntRangeType.FULL_RANGE)) {
            return INT;
        }
        if (range.isEmpty()) {
            return BOTTOM;
        }
        Long value2 = range.getConstantValue();
        if (value2 != null) {
            return DfTypes.intValue(Math.toIntExact(value2));
        }
        return new DfIntRangeType(range);
    }

    @NotNull
    public static DfIntConstantType intValue(int value2) {
        return new DfIntConstantType(value2);
    }

    @NotNull
    public static DfType longRange(LongRangeSet range) {
        if (range.equals(LongRangeSet.all())) {
            return LONG;
        }
        if (range.isEmpty()) {
            return BOTTOM;
        }
        Long value2 = range.getConstantValue();
        if (value2 != null) {
            return DfTypes.longValue(value2);
        }
        return new DfLongRangeType(range);
    }

    @NotNull
    public static DfLongConstantType longValue(long value2) {
        return new DfLongConstantType(value2);
    }

    @NotNull
    public static DfType rangeClamped(LongRangeSet range, boolean isLong) {
        return isLong ? DfTypes.longRange(range) : DfTypes.intRangeClamped(range);
    }

    public static DfFloatConstantType floatValue(float value2) {
        return new DfFloatConstantType(value2);
    }

    public static DfDoubleConstantType doubleValue(double value2) {
        return new DfDoubleConstantType(value2);
    }

    @NotNull
    public static DfConstantType<?> constant(@Nullable Object constant, @NotNull PsiType type2) {
        if (constant == null) {
            return NULL;
        }
        if (constant instanceof Boolean) {
            return DfTypes.booleanValue((Boolean)constant);
        }
        if (constant instanceof Integer || constant instanceof Short || constant instanceof Byte) {
            return DfTypes.intValue(((Number)constant).intValue());
        }
        if (constant instanceof Character) {
            return DfTypes.intValue(((Character)constant).charValue());
        }
        if (constant instanceof Long) {
            return DfTypes.longValue((Long)constant);
        }
        if (constant instanceof Float) {
            return DfTypes.floatValue(((Float)constant).floatValue());
        }
        if (constant instanceof Double) {
            return DfTypes.doubleValue((Double)constant);
        }
        return new DfReferenceConstantType(constant, type2, TypeConstraints.instanceOf(type2));
    }

    public static DfConstantType<?> defaultValue(@NotNull PsiType type2) {
        if (type2 instanceof PsiPrimitiveType) {
            switch (type2.getCanonicalText()) {
                case "boolean": {
                    return FALSE;
                }
                case "byte": 
                case "char": 
                case "short": 
                case "int": {
                    return DfTypes.intValue(0);
                }
                case "long": {
                    return DfTypes.longValue(0L);
                }
                case "float": {
                    return DfTypes.floatValue(0.0f);
                }
                case "double": {
                    return DfTypes.doubleValue(0.0);
                }
            }
        }
        return NULL;
    }

    @NotNull
    public static DfType typedObject(@Nullable PsiType type2, @NotNull Nullability nullability) {
        TypeConstraint constraint;
        if (type2 == null) {
            return TOP;
        }
        if (type2 instanceof PsiPrimitiveType) {
            if (type2.equals(PsiType.VOID)) {
                return TOP;
            }
            if (type2.equals(PsiType.BOOLEAN)) {
                return BOOLEAN;
            }
            if (type2.equals(PsiType.INT)) {
                return INT;
            }
            if (type2.equals(PsiType.CHAR) || type2.equals(PsiType.SHORT) || type2.equals(PsiType.BYTE)) {
                return DfTypes.intRange(Objects.requireNonNull(LongRangeSet.fromType(type2)));
            }
            if (type2.equals(PsiType.LONG)) {
                return LONG;
            }
            if (type2.equals(PsiType.DOUBLE)) {
                return DOUBLE;
            }
            if (type2.equals(PsiType.FLOAT)) {
                return FLOAT;
            }
            if (type2.equals(PsiType.NULL)) {
                return NULL;
            }
        }
        if ((constraint = TypeConstraints.instanceOf(type2)) == TypeConstraints.BOTTOM) {
            return nullability == Nullability.NOT_NULL ? BOTTOM : NULL;
        }
        return new DfGenericObjectType(Collections.emptySet(), constraint, DfaNullability.fromNullability(nullability), Mutability.UNKNOWN, null, BOTTOM, false);
    }

    public static DfReferenceType customObject(@NotNull TypeConstraint constraint, @NotNull DfaNullability nullability, @NotNull Mutability mutability, @Nullable SpecialField specialField, @NotNull DfType sfType) {
        if (nullability == DfaNullability.NULL) {
            throw new IllegalArgumentException();
        }
        return new DfGenericObjectType(Collections.emptySet(), constraint, nullability, mutability, specialField, sfType, false);
    }
}

