/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.types;

import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfGenericObjectType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.psi.PsiType;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class DfNullConstantType
extends DfConstantType<Object>
implements DfReferenceType {
    DfNullConstantType() {
        super(null);
    }

    @Override
    @NotNull
    public DfaNullability getNullability() {
        return DfaNullability.NULL;
    }

    @Override
    @NotNull
    public TypeConstraint getConstraint() {
        return TypeConstraints.TOP;
    }

    @Override
    public DfType tryNegate() {
        return DfTypes.NOT_NULL_OBJECT;
    }

    @Override
    @NotNull
    public PsiType getPsiType() {
        return PsiType.NULL;
    }

    @Override
    @NotNull
    public DfReferenceType dropNullability() {
        return DfTypes.OBJECT_OR_NULL;
    }

    @Override
    @NotNull
    public DfType join(@NotNull DfType other) {
        if (this.isSuperType(other)) {
            return this;
        }
        if (other.isSuperType(this)) {
            return other;
        }
        if (!(other instanceof DfReferenceType)) {
            return DfTypes.TOP;
        }
        DfReferenceType type2 = (DfReferenceType)other;
        return new DfGenericObjectType(Collections.emptySet(), type2.getConstraint(), DfaNullability.NULL.unite(type2.getNullability()), type2.getMutability(), null, DfTypes.BOTTOM, false);
    }
}

