/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.types;

import com.intellij.codeInspection.dataFlow.types.DfAntiConstantType;
import com.intellij.codeInspection.dataFlow.types.DfDoubleConstantType;
import com.intellij.codeInspection.dataFlow.types.DfDoubleType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class DfDoubleNotValueType
extends DfAntiConstantType<Double>
implements DfDoubleType {
    DfDoubleNotValueType(Set<Double> values) {
        super(values);
    }

    @Override
    public boolean isSuperType(@NotNull DfType other) {
        if (other == DfTypes.BOTTOM || other.equals(this)) {
            return true;
        }
        if (other instanceof DfDoubleNotValueType) {
            return ((DfDoubleNotValueType)other).myNotValues.containsAll(this.myNotValues);
        }
        if (other instanceof DfDoubleConstantType) {
            return !this.myNotValues.contains(((DfDoubleConstantType)other).getValue());
        }
        return false;
    }

    @Override
    @NotNull
    public DfType join(@NotNull DfType other) {
        if (this.isSuperType(other)) {
            return this;
        }
        if (other.isSuperType(this)) {
            return other;
        }
        if (other instanceof DfDoubleNotValueType) {
            THashSet notValues = new THashSet((Collection)this.myNotValues);
            notValues.retainAll((Collection)((DfDoubleNotValueType)other).myNotValues);
            return notValues.isEmpty() ? DfTypes.DOUBLE : new DfDoubleNotValueType((Set<Double>)notValues);
        }
        return DfTypes.TOP;
    }

    @Override
    @NotNull
    public DfType meet(@NotNull DfType other) {
        if (this.isSuperType(other)) {
            return other;
        }
        if (other.isSuperType(this)) {
            return this;
        }
        if (other instanceof DfDoubleConstantType && this.myNotValues.contains(((DfDoubleConstantType)other).getValue())) {
            return DfTypes.BOTTOM;
        }
        if (other instanceof DfDoubleNotValueType) {
            THashSet notValues = new THashSet((Collection)this.myNotValues);
            notValues.addAll((Collection)((DfDoubleNotValueType)other).myNotValues);
            return new DfDoubleNotValueType((Set<Double>)notValues);
        }
        return DfTypes.BOTTOM;
    }

    @Override
    public String toString() {
        return "double, not in " + this.myNotValues;
    }
}

