/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.ControlFlow;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.BranchingInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.psi.PsiExpression;
import org.jetbrains.annotations.Nullable;

public class ConditionalGotoInstruction
extends Instruction
implements BranchingInstruction {
    private ControlFlow.ControlFlowOffset myOffset;
    private final boolean myIsNegated;
    private final PsiExpression myExpression;

    public ConditionalGotoInstruction(ControlFlow.ControlFlowOffset offset, boolean isNegated, @Nullable PsiExpression psiAnchor) {
        this.myExpression = psiAnchor;
        this.myOffset = offset;
        this.myIsNegated = isNegated;
    }

    public boolean isNegated() {
        return this.myIsNegated;
    }

    @Nullable
    public PsiExpression getPsiAnchor() {
        return this.myExpression;
    }

    @Override
    public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor2) {
        return visitor2.visitConditionalGoto(this, runner, stateBefore);
    }

    public String toString() {
        return "IF_" + (this.isNegated() ? "NE" : "EQ") + " " + this.getOffset();
    }

    public boolean isTarget(boolean whenTrueOnStack, Instruction target) {
        return target.getIndex() == (whenTrueOnStack == this.myIsNegated ? this.getIndex() + 1 : this.getOffset());
    }

    public int getOffset() {
        return this.myOffset.getInstructionOffset();
    }

    public void setOffset(int offset) {
        this.myOffset = new ControlFlow.FixedOffset(offset);
    }
}

