/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inference;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.inference.ContractInferenceIndexKt;
import com.intellij.codeInspection.dataFlow.inference.MethodData;
import com.intellij.codeInspection.dataFlow.inference.MethodReturnInferenceResult;
import com.intellij.codeInspection.dataFlow.inference.PreContract;
import com.intellij.codeInspection.dataFlow.inference.PurityInferenceResult;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.NotNull;

public class JavaSourceInference {
    public static final int MAX_CONTRACT_COUNT = 10;
    private static final Logger LOG = Logger.getInstance(JavaSourceInference.class);

    @NotNull
    private static MethodInferenceData infer(PsiMethodImpl method) {
        InferenceMode mode = JavaSourceInference.getInferenceMode(method);
        if (mode == InferenceMode.DISABLED || mode == InferenceMode.PARAMETERS && method.getParameterList().isEmpty()) {
            return MethodInferenceData.UNKNOWN;
        }
        MethodData data = ContractInferenceIndexKt.getIndexedData(method);
        if (data == null) {
            return MethodInferenceData.UNKNOWN;
        }
        BitSet notNullParameters = data.getNotNullParameters();
        if (mode == InferenceMode.PARAMETERS) {
            return notNullParameters.isEmpty() ? MethodInferenceData.UNKNOWN : new MethodInferenceData(Mutability.UNKNOWN, Nullability.UNKNOWN, Collections.emptyList(), MutationSignature.unknown(), notNullParameters);
        }
        Nullability nullability = JavaSourceInference.findNullability(method, data);
        Mutability mutability = JavaSourceInference.findMutability(method, data);
        MutationSignature signature = JavaSourceInference.findMutationSignature(method, data);
        IntPredicate isNotNullParameter = i -> {
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)method.getProject());
            NullabilityAnnotationInfo parameterInfo = manager.findExplicitNullability((PsiModifierListOwner)parameters2[i]);
            return parameterInfo != null ? parameterInfo.getNullability() == Nullability.NOT_NULL : notNullParameters.get(i);
        };
        List<StandardMethodContract> contracts2 = JavaSourceInference.findContracts(method, data, nullability, isNotNullParameter);
        if (nullability == Nullability.NULLABLE && ContainerUtil.find(contracts2, c -> c.getReturnValue().isNull()) != null) {
            nullability = Nullability.UNKNOWN;
        }
        return new MethodInferenceData(mutability, nullability, contracts2, signature, notNullParameters);
    }

    @NotNull
    private static Nullability findNullability(PsiMethodImpl method, MethodData data) {
        PsiType type2 = method.getReturnType();
        NullabilityAnnotationInfo info = NullableNotNullManager.getInstance((Project)method.getProject()).findExplicitNullability((PsiModifierListOwner)method);
        if (info != null) {
            return info.getNullability();
        }
        if (type2 == null || type2 instanceof PsiPrimitiveType) {
            return Nullability.UNKNOWN;
        }
        MethodReturnInferenceResult result = data.getMethodReturn();
        if (result == null) {
            return Nullability.UNKNOWN;
        }
        try {
            Nullability nullability = (Nullability)RecursionManager.doPreventingRecursion((Object)((Object)method), (boolean)true, () -> result.getNullability(method, data.methodBody(method)));
            return nullability == null ? Nullability.UNKNOWN : nullability;
        }
        catch (ClassCastException e) {
            throw ContractInferenceIndexKt.handleInconsistency(method, data, e);
        }
    }

    @NotNull
    private static Mutability findMutability(@NotNull PsiMethodImpl method, @NotNull MethodData data) {
        PsiType type2 = method.getReturnType();
        if (type2 == null || ClassUtils.isImmutable(type2, false)) {
            return Mutability.UNKNOWN;
        }
        MethodReturnInferenceResult result = data.getMethodReturn();
        if (result == null) {
            return Mutability.UNKNOWN;
        }
        try {
            Mutability mutability = (Mutability)((Object)RecursionManager.doPreventingRecursion((Object)((Object)method), (boolean)true, () -> result.getMutability(method, data.methodBody(method))));
            return mutability == null ? Mutability.UNKNOWN : mutability;
        }
        catch (ClassCastException e) {
            throw ContractInferenceIndexKt.handleInconsistency(method, data, e);
        }
    }

    @NotNull
    private static MutationSignature findMutationSignature(@NotNull PsiMethodImpl method, @NotNull MethodData data) {
        PurityInferenceResult result = data.getPurity();
        if (result == null) {
            return MutationSignature.unknown();
        }
        MutationSignature signature = (MutationSignature)RecursionManager.doPreventingRecursion((Object)((Object)method), (boolean)true, () -> result.getMutationSignature(method, data.methodBody(method)));
        return signature == null ? MutationSignature.unknown() : signature;
    }

    @NotNull
    private static List<StandardMethodContract> findContracts(@NotNull PsiMethodImpl method, @NotNull MethodData data, @NotNull Nullability nullability, @NotNull IntPredicate notNullParameter) {
        StandardMethodContract collapsed;
        List<StandardMethodContract> contracts2;
        PsiAnnotation explicitContract = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)method, Collections.singleton(JavaMethodContractUtil.ORG_JETBRAINS_ANNOTATIONS_CONTRACT), (boolean)true);
        if (explicitContract != null) {
            return JavaMethodContractUtil.parseContracts(method, explicitContract);
        }
        List<PreContract> preContracts = data.getContracts();
        try {
            contracts2 = (List<StandardMethodContract>)RecursionManager.doPreventingRecursion((Object)((Object)method), (boolean)true, () -> ContainerUtil.concat((Iterable)preContracts, c -> c.toContracts(method, data.methodBody(method))));
        }
        catch (ClassCastException e) {
            throw ContractInferenceIndexKt.handleInconsistency(method, data, e);
        }
        if (contracts2 == null || contracts2.isEmpty()) {
            return Collections.emptyList();
        }
        if (contracts2.size() == 2 && (collapsed = ((StandardMethodContract)contracts2.get(0)).tryCollapse((StandardMethodContract)contracts2.get(1))) != null) {
            contracts2 = Collections.singletonList(collapsed);
        }
        return JavaSourceInference.postProcessContracts(contracts2, method, nullability, notNullParameter);
    }

    @NotNull
    private static List<StandardMethodContract> postProcessContracts(List<StandardMethodContract> contracts2, @NotNull PsiMethod method, @NotNull Nullability nullability, @NotNull IntPredicate notNullParameter) {
        List compatible;
        PsiType returnType = method.getReturnType();
        if (returnType != null && !(returnType instanceof PsiPrimitiveType)) {
            contracts2 = JavaSourceInference.boxReturnValues(contracts2);
        }
        if ((compatible = ContainerUtil.filter(contracts2, contract -> {
            for (int i = 0; i < contract.getParameterCount(); ++i) {
                if (contract.getParameterConstraint(i) != StandardMethodContract.ValueConstraint.NULL_VALUE || !notNullParameter.test(i)) continue;
                return false;
            }
            ContractReturnValue retValue = contract.getReturnValue();
            if (nullability == Nullability.NOT_NULL && (retValue.equals(ContractReturnValue.returnNotNull()) || retValue.isNull())) {
                return false;
            }
            if (nullability == Nullability.NULLABLE && retValue.isNotNull() && contract.isTrivial()) {
                return false;
            }
            return retValue.isMethodCompatible(method);
        })).size() > 10) {
            LOG.debug("Too many contracts for " + PsiUtil.getMemberQualifiedName((PsiMember)method) + ", shrinking the list");
            return compatible.subList(0, 10);
        }
        return compatible;
    }

    @NotNull
    private static MethodInferenceData getInferenceData(PsiMethod method) {
        if (!(method instanceof PsiMethodImpl)) {
            return MethodInferenceData.UNKNOWN;
        }
        return (MethodInferenceData)CachedValuesManager.getCachedValue((PsiElement)method, () -> CachedValueProvider.Result.create((Object)JavaSourceInference.infer((PsiMethodImpl)method), (Object[])new Object[]{method, PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @NotNull
    public static Nullability inferNullability(PsiMethodImpl method) {
        return JavaSourceInference.getInferenceData((PsiMethod)method).myNullability;
    }

    public static Nullability inferNullability(@NotNull PsiParameter parameter2) {
        int index;
        if (!parameter2.isPhysical() || parameter2.getType() instanceof PsiPrimitiveType) {
            return Nullability.UNKNOWN;
        }
        PsiParameterList parent = (PsiParameterList)ObjectUtils.tryCast((Object)parameter2.getParent(), PsiParameterList.class);
        if (parent == null) {
            return Nullability.UNKNOWN;
        }
        PsiMethodImpl method = (PsiMethodImpl)((Object)ObjectUtils.tryCast((Object)parent.getParent(), PsiMethodImpl.class));
        if (method == null) {
            return Nullability.UNKNOWN;
        }
        BitSet notNullParameters = JavaSourceInference.getInferenceData((PsiMethod)method).myNotNullParameters;
        if (!notNullParameters.isEmpty() && notNullParameters.get(index = parent.getParameterIndex(parameter2))) {
            return Nullability.NOT_NULL;
        }
        return Nullability.UNKNOWN;
    }

    @NotNull
    public static Mutability inferMutability(PsiMethodImpl method) {
        return JavaSourceInference.getInferenceData((PsiMethod)method).myMutability;
    }

    @NotNull
    public static List<StandardMethodContract> inferContracts(@NotNull PsiMethodImpl method) {
        return JavaSourceInference.getInferenceData((PsiMethod)method).myContracts;
    }

    public static MutationSignature inferMutationSignature(@NotNull PsiMethodImpl method) {
        return JavaSourceInference.getInferenceData((PsiMethod)method).myMutationSignature;
    }

    @NotNull
    private static List<StandardMethodContract> boxReturnValues(List<StandardMethodContract> contracts2) {
        return ContainerUtil.mapNotNull(contracts2, contract -> {
            if (contract.getReturnValue().isBoolean()) {
                return contract.withReturnValue(ContractReturnValue.returnNotNull());
            }
            return contract;
        });
    }

    private static InferenceMode getInferenceMode(@NotNull PsiMethodImpl method) {
        if (JavaSourceInference.isLibraryCode(method) || method.hasModifierProperty("abstract") || method.hasModifierProperty("native")) {
            return InferenceMode.DISABLED;
        }
        if (method.hasModifierProperty("static")) {
            return InferenceMode.ENABLED;
        }
        if (PsiUtil.canBeOverridden((PsiMethod)method)) {
            return InferenceMode.PARAMETERS;
        }
        if (JavaSourceInference.isUnusedInAnonymousClass(method)) {
            return InferenceMode.DISABLED;
        }
        return InferenceMode.ENABLED;
    }

    private static boolean isUnusedInAnonymousClass(@NotNull PsiMethod method) {
        PsiClass containingClass = method.getContainingClass();
        if (!(containingClass instanceof PsiAnonymousClass)) {
            return false;
        }
        if (containingClass.getParent() instanceof PsiNewExpression && containingClass.getParent().getParent() instanceof PsiVariable && !method.getHierarchicalMethodSignature().getSuperSignatures().isEmpty()) {
            return false;
        }
        return MethodReferencesSearch.search((PsiMethod)method, (SearchScope)new LocalSearchScope((PsiElement)containingClass), (boolean)false).findFirst() == null;
    }

    private static boolean isLibraryCode(@NotNull PsiMethod method) {
        if (method instanceof PsiCompiledElement) {
            return true;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)method);
        return virtualFile != null && FileIndexFacade.getInstance((Project)method.getProject()).isInLibrarySource(virtualFile);
    }

    private static class MethodInferenceData {
        static final MethodInferenceData UNKNOWN = new MethodInferenceData(Mutability.UNKNOWN, Nullability.UNKNOWN, Collections.emptyList(), MutationSignature.unknown(), new BitSet());
        @NotNull
        final Mutability myMutability;
        @NotNull
        final Nullability myNullability;
        @NotNull
        final List<StandardMethodContract> myContracts;
        @NotNull
        final MutationSignature myMutationSignature;
        @NotNull
        final BitSet myNotNullParameters;

        MethodInferenceData(@NotNull Mutability mutability, @NotNull Nullability nullability, @NotNull List<StandardMethodContract> contracts2, @NotNull MutationSignature signature, @NotNull BitSet parameters2) {
            this.myMutability = mutability;
            this.myNullability = nullability;
            this.myContracts = contracts2;
            this.myMutationSignature = signature;
            this.myNotNullParameters = parameters2;
        }
    }

    static enum InferenceMode {
        DISABLED,
        ENABLED,
        PARAMETERS;

    }
}

