/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiType;
import com.intellij.util.ObjectUtils;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import one.util.streamex.EntryStream;
import one.util.streamex.MoreCollectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TypeConstraint {
    @NotNull
    public TypeConstraint join(@NotNull TypeConstraint var1);

    @NotNull
    public TypeConstraint meet(@NotNull TypeConstraint var1);

    public boolean isSuperConstraintOf(@NotNull TypeConstraint var1);

    @Nullable
    default public TypeConstraint tryNegate() {
        return null;
    }

    @Nullable
    default public PsiType getPsiType(Project project) {
        return null;
    }

    @NotNull
    default public String getPresentationText(@Nullable PsiType type2) {
        return this.toShortString();
    }

    default public boolean isExact() {
        return false;
    }

    default public boolean isComparedByEquals() {
        return false;
    }

    default public boolean isResolved() {
        return true;
    }

    @Nullable
    default public String getAssignabilityExplanation(@NotNull TypeConstraint otherType, boolean expectedAssignable) {
        return null;
    }

    default public StreamEx<Exact> instanceOfTypes() {
        return StreamEx.empty();
    }

    default public StreamEx<Exact> notInstanceOfTypes() {
        return StreamEx.empty();
    }

    default public DfType asDfType() {
        return this == TypeConstraints.BOTTOM ? DfTypes.BOTTOM : DfTypes.customObject(this, DfaNullability.UNKNOWN, Mutability.UNKNOWN, null, DfTypes.BOTTOM);
    }

    default public String toShortString() {
        return this.toString();
    }

    @NotNull
    default public TypeConstraint getArrayComponent() {
        return TypeConstraints.BOTTOM;
    }

    @NotNull
    public static TypeConstraint fromDfType(DfType type2) {
        return type2 instanceof DfReferenceType ? ((DfReferenceType)type2).getConstraint() : (type2 == DfTypes.BOTTOM ? TypeConstraints.BOTTOM : TypeConstraints.TOP);
    }

    public static final class Constrained
    implements TypeConstraint {
        @NotNull
        private final Set<Exact> myInstanceOf;
        @NotNull
        private final Set<Exact> myNotInstanceOf;

        Constrained(@NotNull Set<Exact> instanceOf, @NotNull Set<Exact> notInstanceOf) {
            assert (!instanceOf.isEmpty() || !notInstanceOf.isEmpty());
            this.myInstanceOf = instanceOf;
            this.myNotInstanceOf = notInstanceOf;
        }

        @Override
        public boolean isResolved() {
            return this.myInstanceOf.stream().allMatch(TypeConstraint::isResolved);
        }

        @Override
        @Nullable
        public PsiType getPsiType(Project project) {
            PsiType[] conjuncts = (PsiType[])StreamEx.of(this.myInstanceOf).map(exact -> exact.getPsiType(project)).nonNull().toArray((Object[])PsiType.EMPTY_ARRAY);
            return conjuncts.length == 0 ? null : PsiIntersectionType.createIntersection((boolean)true, (PsiType[])conjuncts);
        }

        @Override
        @Nullable
        public TypeConstraint tryNegate() {
            if (this.myInstanceOf.size() == 1 && this.myNotInstanceOf.isEmpty()) {
                return this.myInstanceOf.iterator().next().notInstanceOf();
            }
            if (this.myNotInstanceOf.size() == 1 && this.myInstanceOf.isEmpty()) {
                return this.myNotInstanceOf.iterator().next().instanceOf();
            }
            return null;
        }

        @Override
        @NotNull
        public TypeConstraint join(@NotNull TypeConstraint other) {
            if (this.isSuperConstraintOf(other)) {
                return this;
            }
            if (other.isSuperConstraintOf(this)) {
                return other;
            }
            if (other instanceof Constrained) {
                return this.joinWithConstrained((Constrained)other);
            }
            if (other instanceof Exact) {
                return this.joinWithConstrained(new Constrained(Collections.singleton((Exact)other), Collections.emptySet()));
            }
            return TypeConstraints.TOP;
        }

        @NotNull
        private TypeConstraint joinWithConstrained(@NotNull Constrained other) {
            Set<Exact> instanceOfTypes;
            THashSet notTypes = new THashSet(this.myNotInstanceOf);
            notTypes.retainAll(other.myNotInstanceOf);
            if (this.myInstanceOf.containsAll(other.myInstanceOf)) {
                instanceOfTypes = other.myInstanceOf;
            } else if (other.myInstanceOf.containsAll(this.myInstanceOf)) {
                instanceOfTypes = this.myInstanceOf;
            } else {
                instanceOfTypes = Constrained.withSuper(this.myInstanceOf);
                instanceOfTypes.retainAll(Constrained.withSuper(other.myInstanceOf));
            }
            TypeConstraint constraint = TypeConstraints.TOP;
            for (Exact type2 : instanceOfTypes) {
                constraint = constraint.meet(type2.instanceOf());
            }
            for (Exact type2 : notTypes) {
                constraint = constraint.meet(type2.notInstanceOf());
            }
            return constraint;
        }

        @NotNull
        private static Set<Exact> withSuper(@NotNull Set<Exact> instanceofValues) {
            return StreamEx.of(instanceofValues).flatMap(Exact::superTypes).append(instanceofValues).toSet();
        }

        @Nullable
        private Constrained withInstanceofValue(@NotNull Exact type2) {
            if (this.myInstanceOf.contains(type2)) {
                return this;
            }
            for (Exact exact : this.myNotInstanceOf) {
                if (!exact.isAssignableFrom(type2)) continue;
                return null;
            }
            ArrayList<Exact> moreGeneric = new ArrayList<Exact>();
            for (Exact alreadyInstanceof : this.myInstanceOf) {
                if (type2.isAssignableFrom(alreadyInstanceof)) {
                    return this;
                }
                if (!type2.isConvertibleFrom(alreadyInstanceof)) {
                    return null;
                }
                if (!alreadyInstanceof.isAssignableFrom(type2)) continue;
                moreGeneric.add(alreadyInstanceof);
            }
            THashSet tHashSet = new THashSet(this.myInstanceOf);
            tHashSet.removeAll(moreGeneric);
            tHashSet.add(type2);
            return new Constrained((Set<Exact>)tHashSet, this.myNotInstanceOf);
        }

        @Nullable
        private Constrained withNotInstanceofValue(Exact type2) {
            if (this.myNotInstanceOf.contains(type2)) {
                return this;
            }
            for (Exact exact : this.myInstanceOf) {
                if (!type2.isAssignableFrom(exact)) continue;
                return null;
            }
            ArrayList<Exact> moreSpecific = new ArrayList<Exact>();
            for (Exact alreadyNotInstanceof : this.myNotInstanceOf) {
                if (alreadyNotInstanceof.isAssignableFrom(type2)) {
                    return this;
                }
                if (!type2.isAssignableFrom(alreadyNotInstanceof)) continue;
                moreSpecific.add(alreadyNotInstanceof);
            }
            THashSet tHashSet = new THashSet(this.myNotInstanceOf);
            tHashSet.removeAll(moreSpecific);
            tHashSet.add(type2);
            return new Constrained(this.myInstanceOf, (Set<Exact>)tHashSet);
        }

        @Override
        @NotNull
        public TypeConstraint meet(@NotNull TypeConstraint other) {
            if (this.isSuperConstraintOf(other)) {
                return other;
            }
            if (other.isSuperConstraintOf(this)) {
                return this;
            }
            if (!(other instanceof Constrained)) {
                return TypeConstraints.BOTTOM;
            }
            Constrained right = (Constrained)other;
            Constrained result = this;
            for (Exact type2 : right.myInstanceOf) {
                if ((result = result.withInstanceofValue(type2)) != null) continue;
                return TypeConstraints.BOTTOM;
            }
            for (Exact type2 : right.myNotInstanceOf) {
                if ((result = result.withNotInstanceofValue(type2)) != null) continue;
                return TypeConstraints.BOTTOM;
            }
            return result;
        }

        @Override
        public boolean isSuperConstraintOf(@NotNull TypeConstraint other) {
            if (other == TypeConstraints.BOTTOM) {
                return true;
            }
            if (other instanceof Constrained) {
                Constrained that = (Constrained)other;
                if (!that.myNotInstanceOf.containsAll(this.myNotInstanceOf)) {
                    if (that.myInstanceOf.isEmpty()) {
                        return false;
                    }
                    for (Exact thisNotType : this.myNotInstanceOf) {
                        if (that.myNotInstanceOf.contains(thisNotType)) continue;
                        for (Exact thatType : that.myInstanceOf) {
                            if (!thisNotType.isConvertibleFrom(thatType)) continue;
                            return false;
                        }
                    }
                }
                if (that.myInstanceOf.containsAll(this.myInstanceOf)) {
                    return true;
                }
                if (that.myInstanceOf.isEmpty()) {
                    return this.myInstanceOf.isEmpty();
                }
                for (Exact thatType : that.myInstanceOf) {
                    for (Exact thisType : this.myInstanceOf) {
                        if (thisType.isAssignableFrom(thatType)) continue;
                        return false;
                    }
                }
                return true;
            }
            if (other instanceof Exact) {
                Exact otherType = (Exact)other;
                for (Exact thisInstance : this.myInstanceOf) {
                    if (thisInstance.isAssignableFrom(otherType)) continue;
                    return false;
                }
                for (Exact thisNotInstance : this.myNotInstanceOf) {
                    if (!thisNotInstance.isAssignableFrom(otherType)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public String getAssignabilityExplanation(@NotNull TypeConstraint otherType, boolean expectedAssignable) {
            Exact exact = ((Optional)otherType.instanceOfTypes().collect(MoreCollectors.onlyOne())).orElse(null);
            if (exact == null) {
                return null;
            }
            if (expectedAssignable) {
                for (Exact inst : this.myInstanceOf) {
                    if (!exact.isAssignableFrom(inst)) continue;
                    return "is already known to be " + inst.toShortString() + (exact == inst ? "" : " which is a subtype of " + exact.toShortString());
                }
            } else {
                for (Exact notInst : this.myNotInstanceOf) {
                    if (!notInst.isAssignableFrom(exact)) continue;
                    return "is known to be not " + notInst.toShortString() + (exact == notInst ? "" : " which is a supertype of " + exact.toShortString());
                }
                for (Exact inst : this.myInstanceOf) {
                    if (exact.isConvertibleFrom(inst)) continue;
                    return "is known to be " + inst.toShortString() + " which is definitely incompatible with " + exact.toShortString();
                }
            }
            return null;
        }

        @Override
        public StreamEx<Exact> instanceOfTypes() {
            return StreamEx.of(this.myInstanceOf);
        }

        @Override
        public StreamEx<Exact> notInstanceOfTypes() {
            return StreamEx.of(this.myNotInstanceOf);
        }

        @Override
        @NotNull
        public TypeConstraint getArrayComponent() {
            return this.instanceOfTypes().map(TypeConstraint::getArrayComponent).map(type2 -> type2 instanceof Exact ? ((Exact)type2).instanceOf() : TypeConstraints.BOTTOM).reduce(TypeConstraint::meet).orElse(TypeConstraints.BOTTOM);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Constrained that = (Constrained)o;
            return Objects.equals(this.myInstanceOf, that.myInstanceOf) && Objects.equals(this.myNotInstanceOf, that.myNotInstanceOf);
        }

        public int hashCode() {
            return Objects.hash(this.myInstanceOf, this.myNotInstanceOf);
        }

        @NotNull
        public String toString() {
            return EntryStream.of((Object)"instanceof ", this.myInstanceOf, (Object)"not instanceof ", this.myNotInstanceOf).removeValues(Set::isEmpty).mapKeyValue((prefix, set) -> StreamEx.of((Collection)set).joining((CharSequence)", ", (CharSequence)prefix, (CharSequence)"")).joining((CharSequence)" ");
        }

        @Override
        @NotNull
        public String getPresentationText(@Nullable PsiType type2) {
            Exact exact;
            Set instanceOfTypes = this.myInstanceOf;
            Exact exact2 = exact = type2 == null ? null : (Exact)ObjectUtils.tryCast((Object)TypeConstraints.exact(type2), Exact.class);
            if (exact != null) {
                instanceOfTypes = StreamEx.of(instanceOfTypes).without((Object)exact).toSet();
            }
            return EntryStream.of((Object)"instanceof ", (Object)instanceOfTypes, (Object)"not instanceof ", this.myNotInstanceOf).removeValues(Set::isEmpty).mapKeyValue((prefix, set) -> ((StreamEx)StreamEx.of((Collection)set).map(Exact::toShortString).sorted()).joining((CharSequence)", ", (CharSequence)prefix, (CharSequence)"")).joining((CharSequence)"\n");
        }
    }

    public static interface Exact
    extends TypeConstraint {
        @Override
        @NotNull
        default public TypeConstraint join(@NotNull TypeConstraint other) {
            if (other == TypeConstraints.BOTTOM || this.equals(other)) {
                return this;
            }
            if (other == TypeConstraints.TOP) {
                return other;
            }
            return new Constrained(Collections.singleton(this), Collections.emptySet()).join(other);
        }

        @Override
        @NotNull
        default public TypeConstraint meet(@NotNull TypeConstraint other) {
            if (this.equals(other) || other.isSuperConstraintOf(this)) {
                return this;
            }
            return TypeConstraints.BOTTOM;
        }

        public boolean isFinal();

        @Override
        default public boolean isExact() {
            return true;
        }

        default public boolean canBeInstantiated() {
            return true;
        }

        public StreamEx<Exact> superTypes();

        public boolean isAssignableFrom(@NotNull Exact var1);

        public boolean isConvertibleFrom(@NotNull Exact var1);

        @Override
        default public StreamEx<Exact> instanceOfTypes() {
            return StreamEx.of((Object)this);
        }

        @Override
        default public String getAssignabilityExplanation(@NotNull TypeConstraint otherType, boolean expectedAssignable) {
            Exact exact = ((Optional)otherType.instanceOfTypes().collect(MoreCollectors.onlyOne())).orElse(null);
            if (exact == null) {
                return null;
            }
            boolean actual = exact.isAssignableFrom(this);
            if (actual != expectedAssignable) {
                return null;
            }
            if (expectedAssignable) {
                if (this.equals(exact)) {
                    return "is already known to be " + this.toShortString();
                }
                return "type is exactly " + this.toShortString() + " which is a subtype of " + exact.toShortString();
            }
            return "type is exactly " + this.toShortString() + " which is not a subtype of " + exact.toShortString();
        }

        @Override
        default public boolean isSuperConstraintOf(@NotNull TypeConstraint other) {
            return other == TypeConstraints.BOTTOM || this.equals(other);
        }

        @Override
        default public TypeConstraint tryNegate() {
            return this.isFinal() ? this.notInstanceOf() : null;
        }

        @NotNull
        default public TypeConstraint instanceOf() {
            if (this.isFinal()) {
                return this.canBeInstantiated() ? this : TypeConstraints.BOTTOM;
            }
            return new Constrained(Collections.singleton(this), Collections.emptySet());
        }

        @NotNull
        default public TypeConstraint notInstanceOf() {
            return new Constrained(Collections.emptySet(), Collections.singleton(this));
        }

        @Override
        default public String toShortString() {
            return StringUtil.getShortName((String)this.toString());
        }

        @Override
        @NotNull
        default public String getPresentationText(@Nullable PsiType type2) {
            return type2 != null && TypeConstraints.exact(type2).equals(this) ? "" : "exactly " + this.toShortString();
        }
    }
}

