/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StandardMethodContract
extends MethodContract {
    private final ValueConstraint @NotNull [] myParameters;

    public StandardMethodContract(ValueConstraint @NotNull [] parameters2, @NotNull ContractReturnValue returnValue) {
        super(returnValue);
        this.myParameters = parameters2;
    }

    public int getParameterCount() {
        return this.myParameters.length;
    }

    public ValueConstraint getParameterConstraint(int parameterIndex) {
        return this.myParameters[parameterIndex];
    }

    public List<ValueConstraint> getConstraints() {
        return ContainerUtil.immutableList((Object[])this.myParameters);
    }

    @NotNull
    public StandardMethodContract withReturnValue(@NotNull ContractReturnValue returnValue) {
        return returnValue.equals(this.getReturnValue()) ? this : new StandardMethodContract(this.myParameters, returnValue);
    }

    public static StandardMethodContract trivialContract(int paramCount, @NotNull ContractReturnValue returnValue) {
        return new StandardMethodContract(StandardMethodContract.createConstraintArray(paramCount), returnValue);
    }

    @Nullable
    StandardMethodContract intersect(StandardMethodContract contract) {
        ValueConstraint[] result = (ValueConstraint[])this.myParameters.clone();
        assert (contract.getParameterCount() == result.length);
        for (int i = 0; i < result.length; ++i) {
            ValueConstraint condition2 = result[i];
            ValueConstraint constraint = contract.getParameterConstraint(i);
            if (condition2 == constraint || condition2 == ValueConstraint.ANY_VALUE) {
                result[i] = constraint;
                continue;
            }
            if (constraint == ValueConstraint.ANY_VALUE) {
                result[i] = condition2;
                continue;
            }
            if (condition2 == ValueConstraint.NOT_NULL_VALUE && (constraint == ValueConstraint.TRUE_VALUE || constraint == ValueConstraint.FALSE_VALUE)) {
                result[i] = constraint;
                continue;
            }
            if (constraint == ValueConstraint.NOT_NULL_VALUE && (condition2 == ValueConstraint.TRUE_VALUE || condition2 == ValueConstraint.FALSE_VALUE)) {
                result[i] = condition2;
                continue;
            }
            return null;
        }
        return new StandardMethodContract(result, this.getReturnValue().intersect(contract.getReturnValue()));
    }

    @NotNull
    Stream<StandardMethodContract> excludeContract(StandardMethodContract contract) {
        assert (contract.getParameterCount() == this.myParameters.length);
        List<ValueConstraint> constraints = contract.getConstraints();
        List template = StreamEx.constant((Object)((Object)ValueConstraint.ANY_VALUE), (long)this.myParameters.length).toList();
        ArrayList<StandardMethodContract> antiContracts = new ArrayList<StandardMethodContract>();
        for (int i = 0; i < constraints.size(); ++i) {
            ValueConstraint constraint = constraints.get(i);
            if (constraint == ValueConstraint.ANY_VALUE) continue;
            template.set(i, constraint.negate());
            antiContracts.add(new StandardMethodContract(template.toArray(new ValueConstraint[0]), this.getReturnValue()));
            template.set(i, constraint);
        }
        return StreamEx.of(antiContracts).map(this::intersect).nonNull();
    }

    public StandardMethodContract tryCollapse(StandardMethodContract other) {
        if (!other.getReturnValue().equals(this.getReturnValue())) {
            return null;
        }
        ValueConstraint[] thatParameters = other.myParameters;
        ValueConstraint[] thisParameters = this.myParameters;
        if (thatParameters.length != thisParameters.length) {
            return null;
        }
        ValueConstraint[] result = null;
        for (int i = 0; i < thisParameters.length; ++i) {
            ValueConstraint thisConstraint = thisParameters[i];
            ValueConstraint thatConstraint = thatParameters[i];
            if (thisConstraint == thatConstraint) continue;
            if (result != null || !thisConstraint.canBeNegated() || thisConstraint.negate() != thatConstraint) {
                return null;
            }
            result = (ValueConstraint[])thisParameters.clone();
            result[i] = ValueConstraint.ANY_VALUE;
        }
        return result == null ? null : new StandardMethodContract(result, this.getReturnValue());
    }

    @Nullable(value="When result is too big or contracts are erroneous")
    public static @Nullable(value="When result is too big or contracts are erroneous") List<StandardMethodContract> toNonIntersectingStandardContracts(List<StandardMethodContract> contracts2) {
        if (contracts2.isEmpty()) {
            return contracts2;
        }
        int paramCount = contracts2.get(0).getParameterCount();
        ArrayList<StandardMethodContract> result = new ArrayList<StandardMethodContract>();
        List leftovers = Collections.singletonList(StandardMethodContract.trivialContract(paramCount, ContractReturnValue.returnAny()));
        for (StandardMethodContract contract : contracts2) {
            if (contract.getParameterCount() != paramCount) {
                return null;
            }
            StreamEx.of(leftovers).map(c -> c.intersect(contract)).nonNull().into(result);
            if (result.size() >= 300) {
                return null;
            }
            if (!(leftovers = StreamEx.of(leftovers).flatMap(c -> c.excludeContract(contract)).toList()).isEmpty()) continue;
            break;
        }
        return result;
    }

    public static ValueConstraint @NotNull [] createConstraintArray(int paramCount) {
        ValueConstraint[] args = new ValueConstraint[paramCount];
        Arrays.fill((Object[])args, (Object)ValueConstraint.ANY_VALUE);
        return args;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        StandardMethodContract contract = (StandardMethodContract)o;
        return Arrays.equals((Object[])this.myParameters, (Object[])contract.myParameters) && this.getReturnValue().equals(contract.getReturnValue());
    }

    public int hashCode() {
        int result = 0;
        for (ValueConstraint argument : this.myParameters) {
            result = 31 * result + argument.ordinal();
        }
        result = 31 * result + this.getReturnValue().hashCode();
        return result;
    }

    @Override
    String getArgumentsPresentation() {
        return StringUtil.join((Object[])this.myParameters, ValueConstraint::toString, (String)", ");
    }

    @Override
    public List<ContractValue> getConditions() {
        return IntStreamEx.ofIndices((Object[])this.myParameters).mapToObj(idx -> this.myParameters[idx].getCondition(idx)).without((Object)ContractValue.booleanValue(true)).toList();
    }

    public static List<StandardMethodContract> parseContract(@NotNull String text2) throws ParseException {
        if (StringUtil.isEmptyOrSpaces((String)text2)) {
            return Collections.emptyList();
        }
        ArrayList<StandardMethodContract> result = new ArrayList<StandardMethodContract>();
        String[] split = StringUtil.replace((String)text2, (String)" ", (String)"").split(";");
        for (int clauseIndex = 0; clauseIndex < split.length; ++clauseIndex) {
            String clause = split[clauseIndex];
            result.add(StandardMethodContract.fromText(text2, clauseIndex, clause));
        }
        return result;
    }

    @NotNull
    static StandardMethodContract fromText(@NotNull String clause) {
        try {
            return StandardMethodContract.fromText(clause, 0, clause);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private static StandardMethodContract fromText(@NotNull String text2, int clauseIndex, @NotNull String clause) throws ParseException {
        String returnValueString;
        ContractReturnValue returnValue;
        ValueConstraint[] args;
        String arrow = "->";
        int arrowIndex = clause.indexOf(arrow);
        if (arrowIndex < 0) {
            throw ParseException.forClause(JavaAnalysisBundle.message((String)"inspection.contract.checker.clause.syntax", (Object[])new Object[0]), text2, clauseIndex);
        }
        String beforeArrow = clause.substring(0, arrowIndex);
        if (StringUtil.isNotEmpty((String)beforeArrow)) {
            String[] argStrings = beforeArrow.split(",");
            args = new ValueConstraint[argStrings.length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = StandardMethodContract.parseConstraint(argStrings[i], text2, clauseIndex, i);
            }
        } else {
            args = new ValueConstraint[]{};
        }
        if ((returnValue = ContractReturnValue.valueOf(returnValueString = clause.substring(arrowIndex + arrow.length()))) == null) {
            String possibleValues = "null, !null, true, false, this, new, paramN, fail, _";
            String message2 = JavaAnalysisBundle.message((String)"inspection.contract.checker.unknown.return.value", (Object[])new Object[]{possibleValues, returnValueString});
            throw ParseException.forReturnValue(message2, text2, clauseIndex);
        }
        return new StandardMethodContract(args, returnValue);
    }

    private static ValueConstraint parseConstraint(String name2, String text2, int clauseIndex, int constraintIndex) throws ParseException {
        if (StringUtil.isEmpty((String)name2)) {
            throw new ParseException(JavaAnalysisBundle.message((String)"inspection.contract.checker.empty.constraint", (Object[])new Object[0]));
        }
        for (ValueConstraint constraint : ValueConstraint.values()) {
            if (!constraint.toString().equals(name2)) continue;
            return constraint;
        }
        String allowedClause = StreamEx.of((Object[])ValueConstraint.values()).joining((CharSequence)", ");
        String message2 = JavaAnalysisBundle.message((String)"inspection.contract.checker.unknown.constraint", (Object[])new Object[]{allowedClause, name2});
        throw ParseException.forConstraint(message2, text2, clauseIndex, constraintIndex);
    }

    public static class ParseException
    extends Exception {
        @Nullable
        private final TextRange myRange;

        ParseException(@InspectionMessage String message2) {
            this(message2, (TextRange)null);
        }

        ParseException(@InspectionMessage String message2, @Nullable TextRange range) {
            super(message2);
            this.myRange = range != null && range.isEmpty() ? null : range;
        }

        @Nullable
        public TextRange getRange() {
            return this.myRange;
        }

        static ParseException forConstraint(@InspectionMessage String message2, String text2, int clauseNumber, int constraintNumber) {
            TextRange range = ParseException.findClauseRange(text2, clauseNumber);
            if (range == null) {
                return new ParseException(message2);
            }
            int start = range.getStartOffset();
            while (constraintNumber > 0) {
                if ((start = text2.indexOf(44, start)) == -1) {
                    return new ParseException(message2, range);
                }
                ++start;
                --constraintNumber;
            }
            int end = text2.indexOf(44, start);
            if (!(end != -1 && end <= range.getEndOffset() || (end = text2.indexOf("->", start)) != -1 && end <= range.getEndOffset())) {
                end = range.getEndOffset();
            }
            if (!text2.substring(start, end).trim().isEmpty()) {
                while (text2.charAt(start) == ' ') {
                    ++start;
                }
                while (end > start && text2.charAt(end - 1) == ' ') {
                    --end;
                }
            }
            return new ParseException(message2, new TextRange(start, end));
        }

        static ParseException forReturnValue(@InspectionMessage String message2, String text2, int clauseNumber) {
            TextRange range = ParseException.findClauseRange(text2, clauseNumber);
            if (range == null) {
                return new ParseException(message2);
            }
            int index = text2.indexOf("->", range.getStartOffset());
            if (index == -1 || index > range.getEndOffset()) {
                return new ParseException(message2, range);
            }
            index += "->".length();
            while (index < range.getEndOffset() && text2.charAt(index) == ' ') {
                ++index;
            }
            if (index == range.getEndOffset()) {
                return new ParseException(message2, range);
            }
            return new ParseException(message2, new TextRange(index, range.getEndOffset()));
        }

        static ParseException forClause(@InspectionMessage String message2, String text2, int clauseNumber) {
            TextRange range = ParseException.findClauseRange(text2, clauseNumber);
            return range == null ? new ParseException(message2) : new ParseException(message2, range);
        }

        private static TextRange findClauseRange(String text2, int clauseNumber) {
            int start = 0;
            while (clauseNumber > 0) {
                if ((start = text2.indexOf(59, start)) == -1) {
                    return null;
                }
                ++start;
                --clauseNumber;
            }
            int end = text2.indexOf(59, start);
            if (end == -1) {
                end = text2.length();
            }
            if (text2.substring(start, end).trim().isEmpty()) {
                return new TextRange(start, end);
            }
            while (text2.charAt(start) == ' ') {
                ++start;
            }
            while (end > start && text2.charAt(end - 1) == ' ') {
                --end;
            }
            return new TextRange(start, end);
        }
    }

    public static enum ValueConstraint {
        ANY_VALUE("_", ContractReturnValue.returnAny()),
        NULL_VALUE("null", ContractReturnValue.returnNull()),
        NOT_NULL_VALUE("!null", ContractReturnValue.returnNotNull()),
        TRUE_VALUE("true", ContractReturnValue.returnTrue()),
        FALSE_VALUE("false", ContractReturnValue.returnFalse());

        private final String myPresentableName;
        private final ContractReturnValue myCorrespondingReturnValue;

        private ValueConstraint(String presentableName, ContractReturnValue correspondingReturnValue) {
            this.myPresentableName = presentableName;
            this.myCorrespondingReturnValue = correspondingReturnValue;
        }

        public ContractReturnValue asReturnValue() {
            return this.myCorrespondingReturnValue;
        }

        @Nullable
        DfaValue getComparisonValue(DfaValueFactory factory) {
            if (this == NULL_VALUE || this == NOT_NULL_VALUE) {
                return factory.getNull();
            }
            if (this == TRUE_VALUE || this == FALSE_VALUE) {
                return factory.getBoolean(true);
            }
            return null;
        }

        boolean shouldUseNonEqComparison() {
            return this == NOT_NULL_VALUE || this == FALSE_VALUE;
        }

        public ContractValue getCondition(int argumentIndex) {
            ContractValue left;
            if (this == NULL_VALUE || this == NOT_NULL_VALUE) {
                left = ContractValue.nullValue();
            } else if (this == TRUE_VALUE || this == FALSE_VALUE) {
                left = ContractValue.booleanValue(true);
            } else {
                return ContractValue.booleanValue(true);
            }
            return ContractValue.condition(left, RelationType.equivalence(!this.shouldUseNonEqComparison()), ContractValue.argument(argumentIndex));
        }

        public boolean canBeNegated() {
            return this != ANY_VALUE;
        }

        public ValueConstraint negate() {
            switch (this) {
                case NULL_VALUE: {
                    return NOT_NULL_VALUE;
                }
                case NOT_NULL_VALUE: {
                    return NULL_VALUE;
                }
                case TRUE_VALUE: {
                    return FALSE_VALUE;
                }
                case FALSE_VALUE: {
                    return TRUE_VALUE;
                }
            }
            throw new IllegalStateException("ValueConstraint = " + (Object)((Object)this));
        }

        public String toString() {
            return this.myPresentableName;
        }
    }
}

