/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Stream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MutationSignature {
    public static final String ATTR_MUTATES = "mutates";
    static final MutationSignature UNKNOWN = new MutationSignature(false, new boolean[0]);
    static final MutationSignature PURE = new MutationSignature(false, new boolean[0]);
    private static final MutationSignature MUTATES_THIS_ONLY = new MutationSignature(true, new boolean[0]);
    public static final String INVALID_TOKEN_MESSAGE = "Invalid token: %s; supported are 'this', 'param1', 'param2', etc.";
    private final boolean myThis;
    private final boolean[] myParameters;

    private MutationSignature(boolean mutatesThis, boolean[] params) {
        this.myThis = mutatesThis;
        this.myParameters = params;
    }

    public boolean mutatesThis() {
        return this.myThis;
    }

    public boolean mutatesArg(int n) {
        return n < this.myParameters.length && this.myParameters[n];
    }

    public boolean preservesThis() {
        return this != UNKNOWN && !this.myThis;
    }

    public boolean preservesArg(int n) {
        return this != UNKNOWN && !this.mutatesArg(n);
    }

    public MutationSignature alsoMutatesThis() {
        return this == UNKNOWN || this.myThis ? this : (this.isPure() ? MUTATES_THIS_ONLY : new MutationSignature(true, this.myParameters));
    }

    public MutationSignature alsoMutatesArg(int n) {
        if (this.myParameters.length > n && this.myParameters[n]) {
            return this;
        }
        boolean[] params = Arrays.copyOf(this.myParameters, Math.max(n + 1, this.myParameters.length));
        params[n] = true;
        return new MutationSignature(this.myThis, params);
    }

    public boolean isPure() {
        return this == PURE;
    }

    public int hashCode() {
        return (this.myThis ? 137 : 731) + Arrays.hashCode(this.myParameters);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this == UNKNOWN != (obj == UNKNOWN)) {
            return false;
        }
        return obj instanceof MutationSignature && ((MutationSignature)obj).myThis == this.myThis && Arrays.equals(((MutationSignature)obj).myParameters, this.myParameters);
    }

    public String toString() {
        if (this.isPure()) {
            return "(pure)";
        }
        if (this == UNKNOWN) {
            return "(unknown)";
        }
        return IntStreamEx.range((int)this.myParameters.length).mapToEntry(idx -> "param" + (idx + 1), idx -> this.myParameters[idx]).prepend((Object)"this", (Object)this.myThis).filterValues(b -> b).keys().joining((CharSequence)",");
    }

    public Stream<PsiExpression> mutatedExpressions(PsiMethodCallExpression call) {
        PsiExpression qualifier;
        Object[] args = call.getArgumentList().getExpressions();
        StreamEx elements = IntStreamEx.range((int)Math.min(this.myParameters.length, MethodCallUtils.isVarArgCall((PsiCall)call) ? args.length - 1 : args.length)).filter(idx -> this.myParameters[idx]).elements(args);
        if (this.myThis && (qualifier = ExpressionUtils.getEffectiveQualifier(call.getMethodExpression())) != null) {
            return elements.prepend((Object)qualifier);
        }
        return elements;
    }

    public boolean mutatesAnything() {
        if (this.myThis) {
            return true;
        }
        for (boolean parameter2 : this.myParameters) {
            if (!parameter2) continue;
            return true;
        }
        return false;
    }

    public static MutationSignature parse(@NotNull String signature) {
        if (signature.trim().isEmpty()) {
            return UNKNOWN;
        }
        boolean mutatesThis = false;
        boolean[] args = new boolean[]{};
        for (String part : signature.split(",")) {
            if ((part = part.trim()).equals("this")) {
                mutatesThis = true;
                continue;
            }
            if (part.equals("param")) {
                if (args.length == 0) {
                    args = new boolean[]{true};
                    continue;
                }
                args[0] = true;
                continue;
            }
            if (part.startsWith("param")) {
                int argNum = Integer.parseInt(part.substring("param".length()));
                if (argNum < 0 || argNum > 255) {
                    throw new IllegalArgumentException(String.format(INVALID_TOKEN_MESSAGE, part));
                }
                if (args.length < argNum) {
                    args = Arrays.copyOf(args, argNum);
                }
                args[argNum - 1] = true;
                continue;
            }
            if (part.isEmpty()) continue;
            throw new IllegalArgumentException(String.format(INVALID_TOKEN_MESSAGE, part));
        }
        return new MutationSignature(mutatesThis, args);
    }

    @Nullable
    public static String checkSignature(@NotNull String signature, @NotNull PsiMethod method) {
        try {
            MutationSignature ms = MutationSignature.parse(signature);
            if (ms.myThis && method.hasModifierProperty("static")) {
                return "Static method cannot mutate 'this'";
            }
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            if (ms.myParameters.length > parameters2.length) {
                return "Reference to parameter #" + ms.myParameters.length + " is invalid";
            }
            for (int i = 0; i < ms.myParameters.length; ++i) {
                PsiType type2;
                if (!ms.myParameters[i] || !ClassUtils.isImmutable(type2 = parameters2[i].getType())) continue;
                return "Parameter #" + (i + 1) + " has immutable type '" + type2.getPresentableText() + "'";
            }
        }
        catch (IllegalArgumentException ex) {
            return ex.getMessage();
        }
        return null;
    }

    @NotNull
    public static MutationSignature fromMethod(@Nullable PsiMethod method) {
        if (method == null) {
            return UNKNOWN;
        }
        return JavaMethodContractUtil.getContractInfo(method).getMutationSignature();
    }

    @NotNull
    public static MutationSignature fromCall(@Nullable PsiCall call) {
        if (call == null) {
            return UNKNOWN;
        }
        PsiMethod method = call.resolveMethod();
        if (method != null) {
            if (SpecialField.findSpecialField((PsiElement)method) != null) {
                return PURE;
            }
            return MutationSignature.fromMethod(method);
        }
        if (call instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)call;
            if (newExpression.isArrayCreation()) {
                return PURE;
            }
            if (newExpression.getArgumentList() == null || !newExpression.getArgumentList().isEmpty()) {
                return UNKNOWN;
            }
            PsiJavaCodeReferenceElement classReference2 = newExpression.getClassOrAnonymousClassReference();
            if (classReference2 == null) {
                return UNKNOWN;
            }
            PsiClass clazz = (PsiClass)ObjectUtils.tryCast((Object)classReference2.resolve(), PsiClass.class);
            if (clazz == null) {
                return UNKNOWN;
            }
            HashSet<PsiClass> visited = new HashSet<PsiClass>();
            do {
                for (PsiField psiField : clazz.getFields()) {
                    if (psiField.hasModifierProperty("static") || !psiField.hasInitializer()) continue;
                    return UNKNOWN;
                }
                for (PsiField psiField : clazz.getInitializers()) {
                    if (psiField.hasModifierProperty("static")) continue;
                    return UNKNOWN;
                }
                for (PsiField psiField : clazz.getConstructors()) {
                    if (!psiField.getParameterList().isEmpty()) continue;
                    return MutationSignature.fromMethod((PsiMethod)psiField);
                }
            } while ((clazz = clazz.getSuperClass()) != null && visited.add(clazz));
            return MutationSignature.unknown();
        }
        return UNKNOWN;
    }

    @NotNull
    public static MutationSignature pure() {
        return PURE;
    }

    @NotNull
    public static MutationSignature unknown() {
        return UNKNOWN;
    }
}

