/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum DfaNullability {
    NULL("Null", "null", Nullability.NULLABLE),
    NULLABLE("Nullable", "nullable", Nullability.NULLABLE),
    NOT_NULL("Not-null", "non-null", Nullability.NOT_NULL),
    UNKNOWN("Unknown", "", Nullability.UNKNOWN),
    FLUSHED("Flushed", "", Nullability.UNKNOWN);

    @NotNull
    private final String myInternalName;
    @NotNull
    private final String myPresentationalName;
    @NotNull
    private final Nullability myNullability;

    private DfaNullability(@NotNull String internalName, String presentationalName, Nullability nullability) {
        this.myInternalName = internalName;
        this.myPresentationalName = presentationalName;
        this.myNullability = nullability;
    }

    @NotNull
    public String getInternalName() {
        return this.myInternalName;
    }

    @NotNull
    public String getPresentationName() {
        return this.myPresentationalName;
    }

    @NotNull
    public DfaNullability unite(@NotNull DfaNullability other) {
        if (this == other) {
            return this;
        }
        if (this == NULL || other == NULL || this == NULLABLE || other == NULLABLE) {
            return NULLABLE;
        }
        if (this == FLUSHED || other == FLUSHED) {
            return FLUSHED;
        }
        return UNKNOWN;
    }

    @Nullable
    public DfaNullability intersect(@NotNull DfaNullability right) {
        if (this == NOT_NULL) {
            return right == NULL ? null : NOT_NULL;
        }
        if (right == NOT_NULL) {
            return this == NULL ? null : NOT_NULL;
        }
        if (this == UNKNOWN) {
            return right;
        }
        if (right == UNKNOWN) {
            return this;
        }
        if (this == FLUSHED && DfaNullability.toNullability(right) == Nullability.NULLABLE || right == FLUSHED && DfaNullability.toNullability(this) == Nullability.NULLABLE) {
            return NULLABLE;
        }
        return this.equals((Object)right) ? this : null;
    }

    @NotNull
    public static Nullability toNullability(@Nullable DfaNullability dfaNullability) {
        return dfaNullability == null ? Nullability.UNKNOWN : dfaNullability.myNullability;
    }

    @NotNull
    public static DfaNullability fromNullability(@NotNull Nullability nullability) {
        switch (nullability) {
            case NOT_NULL: {
                return NOT_NULL;
            }
            case NULLABLE: {
                return NULLABLE;
            }
            case UNKNOWN: {
                return UNKNOWN;
            }
        }
        throw new IllegalStateException("Unknown nullability: " + nullability);
    }

    @NotNull
    public DfReferenceType asDfType() {
        switch (this) {
            case NULL: {
                return DfTypes.NULL;
            }
            case NOT_NULL: {
                return DfTypes.NOT_NULL_OBJECT;
            }
            case UNKNOWN: {
                return DfTypes.OBJECT_OR_NULL;
            }
        }
        return DfTypes.customObject(TypeConstraints.TOP, this, Mutability.UNKNOWN, null, DfTypes.BOTTOM);
    }

    @NotNull
    public static DfaNullability fromDfType(@NotNull DfType type2) {
        return type2 instanceof DfReferenceType ? ((DfReferenceType)type2).getNullability() : UNKNOWN;
    }
}

