/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.concurrencyAnnotations;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.concurrencyAnnotations.JCiPUtil;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class NonFinalGuardInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        return InspectionsBundle.message((String)"group.names.concurrency.annotation.issues", (Object[])new Object[0]);
    }

    @NotNull
    public String getShortName() {
        return "NonFinalGuard";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new Visitor(holder);
    }

    private static class Visitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        Visitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            super.visitAnnotation(annotation);
            if (!JCiPUtil.isGuardedByAnnotation(annotation)) {
                return;
            }
            String guardValue = JCiPUtil.getGuardValue(annotation);
            if (guardValue == null || "this".equals(guardValue)) {
                return;
            }
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiClass.class);
            if (containingClass == null) {
                return;
            }
            PsiField guardField = containingClass.findFieldByName(guardValue, true);
            if (guardField == null) {
                return;
            }
            if (guardField.hasModifierProperty("final")) {
                return;
            }
            PsiAnnotationMemberValue member = annotation.findAttributeValue("value");
            if (member == null) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)member, JavaAnalysisBundle.message((String)"non.final.guarded.by.field.ref.loc", (Object[])new Object[0]), new LocalQuickFix[0]);
        }

        public void visitDocTag(PsiDocTag psiDocTag) {
            super.visitDocTag(psiDocTag);
            if (!JCiPUtil.isGuardedByTag(psiDocTag)) {
                return;
            }
            String guardValue = JCiPUtil.getGuardValue(psiDocTag);
            if ("this".equals(guardValue)) {
                return;
            }
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiDocTag, PsiClass.class);
            if (containingClass == null) {
                return;
            }
            PsiField guardField = containingClass.findFieldByName(guardValue, true);
            if (guardField == null) {
                return;
            }
            if (guardField.hasModifierProperty("final")) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)psiDocTag, JavaAnalysisBundle.message((String)"non.final.guarded.by.field.0.loc", (Object[])new Object[]{guardValue}), new LocalQuickFix[0]);
        }
    }
}

