/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.concurrencyAnnotations;

import com.intellij.codeInsight.daemon.quickFix.ExternalLibraryResolver;
import com.intellij.codeInspection.concurrencyAnnotations.JCiPUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JCiPExternalLibraryResolver
extends ExternalLibraryResolver {
    private static final ExternalLibraryDescriptor JDCIP_LIBRARY_DESCRIPTOR = new ExternalLibraryDescriptor("net.jcip", "jcip-annotations", null, null, "1.0"){

        @Override
        @NotNull
        public String getPresentableName() {
            return "jcip-annotations.jar";
        }
    };

    @Override
    @Nullable
    public ExternalLibraryResolver.ExternalClassResolveResult resolveClass(@NotNull String shortClassName, @NotNull ThreeState isAnnotation, @NotNull Module contextModule) {
        if (JCiPUtil.isJCiPAnnotation(shortClassName) && isAnnotation == ThreeState.YES) {
            return new ExternalLibraryResolver.ExternalClassResolveResult("net.jcip.annotations." + shortClassName, JDCIP_LIBRARY_DESCRIPTOR);
        }
        return null;
    }

    @Override
    @Nullable
    public ExternalLibraryDescriptor resolvePackage(@NotNull String packageName) {
        if (packageName.equals("net.jcip.annotations")) {
            return JDCIP_LIBRARY_DESCRIPTOR;
        }
        return null;
    }
}

