/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Conf;
import java.util.List;

final class State {
    final int index;
    final Conf conf;
    final List<Conf> history;
    final boolean taken;
    final boolean hasCompanions;
    final boolean unsure;

    State(int index, Conf conf, List<Conf> history, boolean taken, boolean hasCompanions, boolean unsure) {
        this.index = index;
        this.conf = conf;
        this.history = history;
        this.taken = taken;
        this.hasCompanions = hasCompanions;
        this.unsure = unsure;
    }

    boolean equiv(State prev) {
        if (this.taken != prev.taken) {
            return false;
        }
        if (this.unsure != prev.unsure) {
            return false;
        }
        if (!this.conf.equiv(prev.conf)) {
            return false;
        }
        if (this.history.size() != prev.history.size()) {
            return false;
        }
        for (int i = 0; i < this.history.size(); ++i) {
            Conf prev1;
            Conf curr1 = this.history.get(i);
            if (curr1.equiv(prev1 = prev.history.get(i))) continue;
            return false;
        }
        return true;
    }
}

