/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.blockingCallsDetection;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

class BlockingAnnotationsPanel {
    private final Project myProject;
    private String myDefaultAnnotation;
    private final Set<String> myDefaultAnnotations;
    private final JBTable myTable;
    private final JPanel myComponent;
    protected final ListWrappingTableModel myTableModel;
    private final String myCustomEmptyText;
    private final String myCustomAddLinkText;

    BlockingAnnotationsPanel(Project project, final String name2, String defaultAnnotation, List<String> annotations, List<String> defaultAnnotations, String customEmptyText, String customAddLinkText) {
        this.myProject = project;
        this.myDefaultAnnotation = defaultAnnotation;
        this.myDefaultAnnotations = new HashSet<String>(defaultAnnotations);
        this.myCustomEmptyText = customEmptyText;
        this.myCustomAddLinkText = customAddLinkText;
        this.myTableModel = new ListWrappingTableModel(annotations, name2){

            public boolean isCellEditable(int row, int column) {
                return column == 1;
            }
        };
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        columnModel.addColumn(new TableColumn(0, 100, (TableCellRenderer)new ColoredTableCellRenderer(){

            public void acquireState(JTable table, boolean isSelected, boolean hasFocus, int row, int column) {
                super.acquireState(table, isSelected, false, row, column);
            }

            protected void customizeCellRenderer(JTable table, Object value2, boolean selected, boolean hasFocus, int row, int column) {
                if (value2 == null) {
                    return;
                }
                if (!BlockingAnnotationsPanel.this.isAnnotationAccessible((String)value2)) {
                    this.append((String)value2, SimpleTextAttributes.ERROR_ATTRIBUTES);
                    this.setIcon(AllIcons.General.Error);
                } else {
                    this.append((String)value2, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    if (value2.equals(BlockingAnnotationsPanel.this.myDefaultAnnotation)) {
                        this.setIcon(AllIcons.Actions.Forward);
                    } else {
                        this.setIcon(EmptyIcon.ICON_16);
                    }
                }
            }
        }, null));
        this.myTable = new JBTable((TableModel)this.myTableModel, columnModel){

            @NotNull
            public StatusText getEmptyText() {
                StatusText emptyText = super.getEmptyText();
                if (!BlockingAnnotationsPanel.this.myProject.isDefault() && BlockingAnnotationsPanel.this.myCustomEmptyText != null && BlockingAnnotationsPanel.this.myCustomAddLinkText != null) {
                    emptyText.setText(BlockingAnnotationsPanel.this.myCustomEmptyText).appendSecondaryText(BlockingAnnotationsPanel.this.myCustomAddLinkText, SimpleTextAttributes.LINK_ATTRIBUTES, e -> BlockingAnnotationsPanel.this.chooseAnnotation(name2));
                    ShortcutSet shortcutSet = CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.ADD);
                    String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)shortcutSet);
                    emptyText.appendSecondaryText(" (" + shortcutText + ")", StatusText.DEFAULT_ATTRIBUTES, null);
                }
                return emptyText;
            }
        };
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JTable)this.myTable);
        toolbarDecorator.setAddAction(actionButton -> this.chooseAnnotation(name2)).setRemoveAction(actionButton -> {
            String selectedValue = this.getSelectedAnnotation();
            if (selectedValue == null) {
                return;
            }
            if (this.myDefaultAnnotation.equals(selectedValue)) {
                this.myDefaultAnnotation = (String)this.myTable.getValueAt(0, 0);
            }
            this.myTableModel.removeRow(this.myTable.getSelectedRow());
        }).setRemoveActionUpdater(e -> !this.myProject.isDefault() && !this.myDefaultAnnotations.contains(this.getSelectedAnnotation())).setAddActionUpdater(e -> !this.myProject.isDefault());
        JPanel panel2 = toolbarDecorator.createPanel();
        this.myComponent = new JPanel(new BorderLayout());
        BorderLayoutPanel withBorder = JBUI.Panels.simplePanel().addToTop((Component)JBUI.Panels.simplePanel((Component)new JLabel(name2 + ":")).withBorder((Border)JBUI.Borders.empty((int)10, (int)0))).addToCenter((Component)panel2);
        this.myComponent.add((Component)withBorder, "Center");
        this.myComponent.setPreferredSize((Dimension)new JBDimension(this.myComponent.getPreferredSize().width, 200));
        this.myTable.setSelectionMode(0);
        this.myTable.setRowSelectionAllowed(true);
        this.myTable.setShowGrid(false);
        this.selectAnnotation(this.myDefaultAnnotation);
    }

    private boolean isAnnotationAccessible(String annotationFqn) {
        return JavaPsiFacade.getInstance((Project)this.myProject).findClass(annotationFqn, GlobalSearchScope.allScope((Project)this.myProject)) != null;
    }

    private void addRow(String annotation) {
        this.myTableModel.addRow(new String[]{annotation});
    }

    private Integer selectAnnotation(String annotation) {
        for (int i = 0; i < this.myTable.getRowCount(); ++i) {
            if (!annotation.equals(this.myTable.getValueAt(i, 0))) continue;
            this.myTable.setRowSelectionInterval(i, i);
            return i;
        }
        return null;
    }

    private String getSelectedAnnotation() {
        int selectedRow = this.myTable.getSelectedRow();
        return selectedRow < 0 ? null : (String)this.myTable.getValueAt(selectedRow, 0);
    }

    private void chooseAnnotation(String title) {
        TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)this.myProject).createNoInnerClassesScopeChooser("Choose " + title, GlobalSearchScope.allScope((Project)this.myProject), new ClassFilter(){

            public boolean isAccepted(PsiClass aClass) {
                return PsiAnnotation.TargetType.METHOD.equals((Object)AnnotationTargetUtil.findAnnotationTarget((PsiClass)aClass, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.METHOD}));
            }
        }, null);
        chooser.showDialog();
        PsiClass selected = chooser.getSelected();
        if (selected == null) {
            return;
        }
        String qualifiedName = selected.getQualifiedName();
        if (this.selectAnnotation(qualifiedName) == null) {
            this.addRow(qualifiedName);
        }
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public String[] getAnnotations() {
        int size = this.myTable.getRowCount();
        String[] result = new String[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (String)this.myTable.getValueAt(i, 0);
        }
        return result;
    }
}

