/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.java.JavaBundle;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.types.JvmPrimitiveTypeKind;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.JavaPsiBoxingUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapperTypeMayBePrimitiveInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher TO_STRING = CallMatcher.instanceCall("java.lang.Object", "toString");
    private static final CallMatcher HASH_CODE = CallMatcher.instanceCall("java.lang.Object", "hashCode");
    private static final CallMatcher VALUE_OF = WrapperTypeMayBePrimitiveInspection.getValueOfMatcher();
    private static final Set<String> ourAllowedInstanceCalls = new HashSet<String>();

    private static CallMatcher getValueOfMatcher() {
        CallMatcher[] matchers = (CallMatcher[])JvmPrimitiveTypeKind.getBoxedFqns().stream().filter(fqn -> !fqn.equals("java.lang.Character")).map(fqn -> CallMatcher.staticCall(fqn, "valueOf").parameterTypes("java.lang.String")).toArray(CallMatcher[]::new);
        return CallMatcher.anyOf(matchers);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitMethod(PsiMethod method) {
                PsiCodeBlock body2 = method.getBody();
                if (body2 == null) {
                    return;
                }
                WrapperTypeMayBePrimitiveDetectingVisitor visitor2 = new WrapperTypeMayBePrimitiveDetectingVisitor();
                body2.accept((PsiElementVisitor)visitor2);
                for (PsiVariable variable : visitor2.getVariablesToUnbox()) {
                    PsiVariable elementToHighlight = variable.getTypeElement() != null ? variable.getTypeElement() : variable;
                    holder.registerProblem((PsiElement)elementToHighlight, JavaBundle.message((String)"inspection.wrapper.type.may.be.primitive.name", (Object[])new Object[0]), new LocalQuickFix[]{new ConvertWrapperTypeToPrimitive()});
                }
            }
        };
    }

    private static boolean isValueOfCall(PsiExpression expression2) {
        return expression2 instanceof PsiMethodCallExpression && VALUE_OF.test((PsiMethodCallExpression)expression2);
    }

    static {
        ourAllowedInstanceCalls.add("isInfinite");
        ourAllowedInstanceCalls.add("isNaN");
        ourAllowedInstanceCalls.add("byteValue");
        ourAllowedInstanceCalls.add("shortValue");
        ourAllowedInstanceCalls.add("intValue");
        ourAllowedInstanceCalls.add("longValue");
        ourAllowedInstanceCalls.add("floatValue");
        ourAllowedInstanceCalls.add("doubleValue");
    }

    private static class ConvertWrapperTypeToPrimitive
    implements LocalQuickFix {
        private ConvertWrapperTypeToPrimitive() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            return this.getFamilyName();
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"inspection.wrapper.type.may.be.primitive.fix.name", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiType type2;
            String boxedType;
            String unboxedType;
            PsiElement element = descriptor.getStartElement();
            PsiTypeElement typeElement = (PsiTypeElement)ObjectUtils.tryCast((Object)element, PsiTypeElement.class);
            if (typeElement == null) {
                return;
            }
            PsiLocalVariable variable = (PsiLocalVariable)ObjectUtils.tryCast((Object)typeElement.getParent(), PsiLocalVariable.class);
            if (variable == null) {
                return;
            }
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null) {
                ConvertWrapperTypeToPrimitive.tryReplaceStaticCall(initializer);
            }
            if ((unboxedType = PsiTypesUtil.unboxIfPossible((String)(boxedType = (type2 = variable.getType()).getCanonicalText()))).equals(boxedType)) {
                return;
            }
            PsiElement codeBlock = PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
            if (codeBlock == null) {
                return;
            }
            codeBlock.accept((PsiElementVisitor)new UnboxingVisitor(variable));
            new CommentTracker().replaceAndRestoreComments((PsiElement)typeElement, unboxedType);
        }

        private static void tryReplaceStaticCall(PsiExpression expression2) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expression2, PsiMethodCallExpression.class);
            if (!VALUE_OF.test(callExpression)) {
                return;
            }
            PsiMethod method = callExpression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            PsiExpression[] arguments = callExpression.getArgumentList().getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            if (containingClass == null) {
                return;
            }
            String containingClassName = containingClass.getQualifiedName();
            String replacementMethodCall = JavaPsiBoxingUtils.getParseMethod(containingClassName);
            if (replacementMethodCall == null) {
                return;
            }
            CommentTracker tracker = new CommentTracker();
            String argumentText = tracker.text((PsiElement)argument);
            String replacementText = containingClassName + "." + replacementMethodCall + "(" + argumentText + ")";
            tracker.replaceAndRestoreComments((PsiElement)callExpression, replacementText);
        }

        private static void replaceInstanceCall(PsiMethodCallExpression call) {
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiType qualifierType = qualifier.getType();
            if (qualifierType == null) {
                return;
            }
            String qualifierTypeText = qualifierType.getCanonicalText();
            CommentTracker tracker = new CommentTracker();
            String qualifierText = tracker.text((PsiElement)qualifier);
            String replacement = ConvertWrapperTypeToPrimitive.findStaticReplacement(call, qualifierText, qualifierTypeText);
            if (replacement == null) {
                return;
            }
            tracker.replaceAndRestoreComments((PsiElement)call, replacement);
        }

        private static String findStaticReplacement(PsiMethodCallExpression call, String qualifierText, String qualifierTypeText) {
            String type2;
            String callName = call.getMethodExpression().getReferenceName();
            String methodNameText = HASH_CODE.test(call) ? "hashCode" : (TO_STRING.test(call) ? "toString" : ("isInfinite".equals(callName) ? "isInfinite" : ("isNaN".equals(callName) ? "isNaN" : null)));
            if (methodNameText != null) {
                return qualifierTypeText + "." + methodNameText + "(" + qualifierText + ")";
            }
            if ("intValue".equals(callName)) {
                type2 = "int";
            } else if ("byteValue".equals(callName)) {
                type2 = "byte";
            } else if ("floatValue".equals(callName)) {
                type2 = "float";
            } else if ("doubleValue".equals(callName)) {
                type2 = "double";
            } else if ("shortValue".equals(callName)) {
                type2 = "short";
            } else {
                return null;
            }
            return "(" + type2 + ")" + qualifierText;
        }

        private static class UnboxingVisitor
        extends JavaRecursiveElementVisitor {
            private final PsiLocalVariable myVariable;

            UnboxingVisitor(PsiLocalVariable variable) {
                this.myVariable = variable;
            }

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                super.visitReferenceExpression(expression2);
                if (!ExpressionUtils.isReferenceTo((PsiExpression)expression2, (PsiVariable)this.myVariable)) {
                    return;
                }
                PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2).getParent();
                PsiMethodCallExpression call = ExpressionUtils.getCallForQualifier((PsiExpression)expression2);
                if (call != null) {
                    ConvertWrapperTypeToPrimitive.replaceInstanceCall(call);
                } else if (parent instanceof PsiAssignmentExpression) {
                    PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
                    if (!ExpressionUtils.isReferenceTo(assignment.getLExpression(), (PsiVariable)this.myVariable)) {
                        return;
                    }
                    ConvertWrapperTypeToPrimitive.tryReplaceStaticCall(assignment.getRExpression());
                }
            }
        }
    }

    private static class WrapperTypeMayBePrimitiveDetectingVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private static final int IN_LOOP_OPERATION_MULTIPLIER = 10;
        private final Map<String, List<BoxingInfo>> myBoxingMap = new HashMap<String, List<BoxingInfo>>();

        private WrapperTypeMayBePrimitiveDetectingVisitor() {
        }

        public void visitClass(PsiClass aClass) {
        }

        public void visitLocalVariable(PsiLocalVariable variable) {
            super.visitLocalVariable(variable);
            if (variable instanceof PsiField) {
                return;
            }
            if (!TypeConversionUtil.isPrimitiveWrapper((PsiType)variable.getType())) {
                return;
            }
            PsiExpression initializer = variable.getInitializer();
            BoxingInfo boxingInfo = new BoxingInfo((PsiVariable)variable);
            if (initializer != null && !boxingInfo.checkExpression(initializer)) {
                return;
            }
            String name2 = variable.getName();
            ArrayList<BoxingInfo> infos = new ArrayList<BoxingInfo>();
            infos.add(boxingInfo);
            this.myBoxingMap.put(name2, infos);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            super.visitReferenceExpression(expression2);
            String name2 = expression2.getReferenceName();
            if (name2 == null) {
                return;
            }
            List<BoxingInfo> infos = this.myBoxingMap.get(name2);
            if (infos == null) {
                return;
            }
            Iterator<BoxingInfo> iterator = infos.iterator();
            while (iterator.hasNext()) {
                BoxingInfo boxingInfo = iterator.next();
                if (!ExpressionUtils.isReferenceTo((PsiExpression)expression2, boxingInfo.myVariable)) continue;
                boxingInfo.myHasReferences = true;
                Integer boxingRemovalImpact = WrapperTypeMayBePrimitiveDetectingVisitor.afterBoxingRemovalReferenceBoostedImpact(expression2, boxingInfo);
                if (boxingRemovalImpact == null) {
                    iterator.remove();
                    break;
                }
                BoxingInfo boxingInfo2 = boxingInfo;
                boxingInfo2.myAfterRemovalOperationCountDiff = boxingInfo2.myAfterRemovalOperationCountDiff + boxingRemovalImpact;
                break;
            }
            if (infos.isEmpty()) {
                this.myBoxingMap.remove(name2);
            }
        }

        public List<PsiVariable> getVariablesToUnbox() {
            ArrayList<PsiVariable> variables = new ArrayList<PsiVariable>();
            for (List<BoxingInfo> infos : this.myBoxingMap.values()) {
                for (BoxingInfo boxingInfo : infos) {
                    if (!boxingInfo.myHasReferences || !boxingInfo.primitiveReplacementReducesUnnecessaryOperationCount()) continue;
                    variables.add(boxingInfo.myVariable);
                }
            }
            return variables;
        }

        private static boolean isAllowedInstanceCall(@NotNull PsiMethodCallExpression call) {
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return false;
            }
            if (method.hasModifier(JvmModifier.STATIC)) {
                return false;
            }
            return ourAllowedInstanceCalls.contains(call.getMethodExpression().getReferenceName());
        }

        @Nullable(value="When use not allows unboxing")
        private static @Nullable(value="When use not allows unboxing") Integer afterBoxingRemovalReferenceBoostedImpact(@NotNull PsiReferenceExpression expression2, @NotNull BoxingInfo boxingInfo) {
            Integer impact = WrapperTypeMayBePrimitiveDetectingVisitor.afterBoxingRemovalReferenceImpact(expression2, boxingInfo);
            if (impact == null) {
                return null;
            }
            LocalSearchScope scope = (LocalSearchScope)ObjectUtils.tryCast((Object)boxingInfo.myVariable.getUseScope(), LocalSearchScope.class);
            if (scope == null) {
                return impact;
            }
            Object[] scopeElements = scope.getScope();
            PsiLoopStatement loop = (PsiLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiLoopStatement.class, (boolean)false, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class, PsiMethod.class});
            if (loop != null && StreamEx.of((Object[])scopeElements).anyMatch(scopeElement -> PsiTreeUtil.isAncestor((PsiElement)scopeElement, (PsiElement)loop, (boolean)false)) && !PsiTreeUtil.isAncestor((PsiElement)loop, (PsiElement)boxingInfo.myVariable, (boolean)true)) {
                impact = impact * 10;
            }
            return impact;
        }

        @Nullable(value="When use not allows unboxing")
        private static @Nullable(value="When use not allows unboxing") Integer afterBoxingRemovalReferenceImpact(@NotNull PsiReferenceExpression expression2, @NotNull BoxingInfo boxingInfo) {
            PsiType returnType;
            PsiMethod method;
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2).getParent();
            PsiMethodCallExpression call = ExpressionUtils.getCallForQualifier((PsiExpression)expression2);
            if (!(call == null || TO_STRING.test(call) || HASH_CODE.test(call) || WrapperTypeMayBePrimitiveDetectingVisitor.isAllowedInstanceCall(call))) {
                return null;
            }
            if (parent instanceof PsiExpressionList) {
                return WrapperTypeMayBePrimitiveDetectingVisitor.expressionListImpactAfterBoxingRemoval((PsiExpressionList)parent, expression2);
            }
            if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
                PsiType lExprType = assignment.getLExpression().getType();
                if (lExprType != null && TypeUtils.isJavaLangString(lExprType)) {
                    return 0;
                }
                PsiExpression rExpression = assignment.getRExpression();
                if (rExpression == null) {
                    return 0;
                }
                if (!boxingInfo.checkExpression(rExpression)) {
                    return null;
                }
                return TypeConversionUtil.convertEQtoOperation((IElementType)assignment.getOperationTokenType()) != null ? -2 : -1;
            }
            if (parent instanceof PsiSynchronizedStatement) {
                return null;
            }
            if (parent instanceof PsiPolyadicExpression) {
                return WrapperTypeMayBePrimitiveDetectingVisitor.polyadicExpressionImpactAfterBoxingRemoval((PsiPolyadicExpression)parent, expression2);
            }
            if (parent instanceof PsiReturnStatement && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiMethod.class, (boolean)false, (Class[])new Class[]{PsiLambdaExpression.class})) != null && (returnType = method.getReturnType()) != null) {
                return returnType instanceof PsiPrimitiveType ? -1 : 1;
            }
            return 0;
        }

        @Nullable(value="When use not allows unboxing")
        private static @Nullable(value="When use not allows unboxing") Integer expressionListImpactAfterBoxingRemoval(@NotNull PsiExpressionList expressionList, @NotNull PsiReferenceExpression reference) {
            int parameterIndex;
            PsiElement grandParent = expressionList.getParent();
            if (!(grandParent instanceof PsiCallExpression)) {
                return null;
            }
            Object[] arguments = expressionList.getExpressions();
            int argumentsIndex = ArrayUtil.indexOf((Object[])arguments, (Object)reference);
            if (argumentsIndex == -1) {
                return null;
            }
            PsiCallExpression callExpression = (PsiCallExpression)grandParent;
            PsiMethod method = callExpression.resolveMethod();
            if (method == null) {
                return null;
            }
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            int n = parameterIndex = parameters2.length < argumentsIndex + 1 ? parameters2.length - 1 : argumentsIndex;
            if (parameterIndex < 0) {
                return null;
            }
            PsiParameter parameter2 = parameters2[parameterIndex];
            PsiType type2 = parameter2.getType();
            return type2 instanceof PsiPrimitiveType ? -1 : 1;
        }

        private static int getBinOpImpact(boolean haveBoxAfter, IElementType operationTokenType) {
            if (!haveBoxAfter) {
                return -1;
            }
            if (operationTokenType == JavaTokenType.EQEQ || operationTokenType == JavaTokenType.NE) {
                return -1;
            }
            boolean isRelational = operationTokenType == JavaTokenType.GT || operationTokenType == JavaTokenType.GE || operationTokenType == JavaTokenType.LT || operationTokenType == JavaTokenType.LE;
            return isRelational ? 0 : 1;
        }

        @Nullable(value="When use not allows unboxing")
        private static @Nullable(value="When use not allows unboxing") Integer polyadicExpressionImpactAfterBoxingRemoval(@NotNull PsiPolyadicExpression polyadic, PsiReferenceExpression reference) {
            int nextOperandIndex;
            PsiExpression[] operands2 = polyadic.getOperands();
            IElementType tokenType = polyadic.getOperationTokenType();
            int afterRemovalOpCountDiff = 0;
            int referenceIndex = -1;
            boolean leftPartBoxed = false;
            boolean hasLeftPart = false;
            boolean isPlus = polyadic.getOperationTokenType() == JavaTokenType.PLUS;
            for (int i = 0; i < operands2.length; ++i) {
                PsiExpression operand2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)operands2[i]);
                if (operand2 == null) {
                    return null;
                }
                if (operand2 == reference) {
                    referenceIndex = i;
                    break;
                }
                hasLeftPart = true;
                PsiType operandType = operand2.getType();
                if (isPlus && TypeUtils.isJavaLangString(operandType)) {
                    return afterRemovalOpCountDiff;
                }
                if (operandType instanceof PsiPrimitiveType) continue;
                if (NullabilityUtil.getExpressionNullability(operand2, true) != Nullability.NOT_NULL) {
                    return null;
                }
                leftPartBoxed = true;
            }
            if (hasLeftPart) {
                afterRemovalOpCountDiff += WrapperTypeMayBePrimitiveDetectingVisitor.getBinOpImpact(leftPartBoxed, tokenType);
            }
            if ((nextOperandIndex = referenceIndex + 1) < operands2.length) {
                PsiExpression next = operands2[nextOperandIndex];
                if (ExpressionUtils.isNullLiteral(next)) {
                    return null;
                }
                afterRemovalOpCountDiff += WrapperTypeMayBePrimitiveDetectingVisitor.getBinOpImpact(!(next.getType() instanceof PsiPrimitiveType), tokenType);
            }
            return afterRemovalOpCountDiff;
        }
    }

    private static class BoxingInfo {
        @NotNull
        private final PsiVariable myVariable;
        boolean myHasReferences = false;
        private int myAfterRemovalOperationCountDiff = 0;

        private BoxingInfo(@NotNull PsiVariable variable) {
            this.myVariable = variable;
        }

        boolean checkExpression(@NotNull PsiExpression expression2) {
            if (expression2.getType() instanceof PsiPrimitiveType && !PsiType.NULL.equals((Object)expression2.getType())) {
                --this.myAfterRemovalOperationCountDiff;
            } else if (WrapperTypeMayBePrimitiveInspection.isValueOfCall(expression2)) {
                --this.myAfterRemovalOperationCountDiff;
            } else {
                if (NullabilityUtil.getExpressionNullability(expression2, true) != Nullability.NOT_NULL) {
                    return false;
                }
                ++this.myAfterRemovalOperationCountDiff;
            }
            return true;
        }

        boolean primitiveReplacementReducesUnnecessaryOperationCount() {
            return this.myAfterRemovalOperationCountDiff < 0;
        }
    }
}

