/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightingFeature;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextBlockMigrationInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean mySuggestLiteralReplacement = false;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JavaBundle.message((String)"inspection.text.block.migration.suggest.literal.replacement", (Object[])new Object[0]), (InspectionProfileEntry)this, "mySuggestLiteralReplacement");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (!HighlightingFeature.TEXT_BLOCKS.isAvailable((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
                if (!TextBlockMigrationInspection.isConcatenation(expression2)) {
                    return;
                }
                int nNewLines = 0;
                PsiExpression[] operands2 = expression2.getOperands();
                TextRange firstNewLineTextRange = null;
                for (PsiExpression operand2 : operands2) {
                    String text2;
                    int newLineIdx;
                    PsiLiteralExpression literal = TextBlockMigrationInspection.getLiteralExpression(operand2);
                    if (literal == null) {
                        return;
                    }
                    if (nNewLines > 1 || (newLineIdx = TextBlockMigrationInspection.getNewLineIndex(text2 = literal.getText(), 0)) == -1) continue;
                    if (firstNewLineTextRange == null) {
                        int operandOffset = literal.getTextOffset() - expression2.getTextOffset();
                        firstNewLineTextRange = new TextRange(operandOffset + newLineIdx, operandOffset + newLineIdx + 2);
                    }
                    while (nNewLines <= 1 && newLineIdx != -1) {
                        ++nNewLines;
                        newLineIdx = TextBlockMigrationInspection.getNewLineIndex(text2, newLineIdx + 1);
                    }
                }
                if (nNewLines <= 1) {
                    return;
                }
                boolean quickFixOnly = isOnTheFly && InspectionProjectProfileManager.isInformationLevel((String)TextBlockMigrationInspection.this.getShortName(), (PsiElement)expression2);
                holder.registerProblem((PsiElement)expression2, quickFixOnly ? null : firstNewLineTextRange, JavaBundle.message((String)"inspection.text.block.migration.message", (Object[])new Object[]{"Concatenation"}), new LocalQuickFix[]{new ReplaceWithTextBlockFix()});
            }

            public void visitLiteralExpression(PsiLiteralExpression expression2) {
                boolean quickFixOnly;
                boolean bl = quickFixOnly = isOnTheFly && InspectionProjectProfileManager.isInformationLevel((String)TextBlockMigrationInspection.this.getShortName(), (PsiElement)expression2);
                if (!TextBlockMigrationInspection.this.mySuggestLiteralReplacement && !quickFixOnly) {
                    return;
                }
                PsiLiteralExpression literal = TextBlockMigrationInspection.getLiteralExpression((PsiExpression)expression2);
                if (literal == null) {
                    return;
                }
                String text2 = literal.getText();
                int newLineIdx = TextBlockMigrationInspection.getNewLineIndex(text2, 0);
                if (newLineIdx == -1 || TextBlockMigrationInspection.getNewLineIndex(text2, newLineIdx + 1) == -1) {
                    return;
                }
                holder.registerProblem((PsiElement)expression2, quickFixOnly ? null : new TextRange(newLineIdx, newLineIdx + 2), JavaBundle.message((String)"inspection.text.block.migration.message", (Object[])new Object[]{"String"}), new LocalQuickFix[]{new ReplaceWithTextBlockFix()});
            }
        };
    }

    private static int getNewLineIndex(@NotNull String text2, int start) {
        int i = start;
        while (i < text2.length()) {
            char c = text2.charAt(i);
            if (c == '\\') {
                if (i + 1 < text2.length() && text2.charAt(i + 1) == 'n') {
                    return i;
                }
                i += 2;
                continue;
            }
            ++i;
        }
        return -1;
    }

    private static boolean isConcatenation(@NotNull PsiPolyadicExpression expression2) {
        PsiType type2 = expression2.getType();
        return type2 != null && type2.equalsToText("java.lang.String");
    }

    @Nullable
    private static PsiLiteralExpression getLiteralExpression(@NotNull PsiExpression expression2) {
        PsiLiteralExpression literal = (PsiLiteralExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2), PsiLiteralExpression.class);
        if (literal == null || literal.isTextBlock()) {
            return null;
        }
        return literal;
    }

    private static class ReplaceWithTextBlockFix
    implements LocalQuickFix {
        private ReplaceWithTextBlockFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"inspection.replace.with.text.block.fix", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiExpression expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)ObjectUtils.tryCast((Object)descriptor.getPsiElement(), PsiExpression.class)));
            if (expression2 == null) {
                return;
            }
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(expression2.getContainingFile());
            if (document == null) {
                return;
            }
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)ObjectUtils.tryCast((Object)expression2, PsiLiteralExpression.class);
            if (literalExpression != null) {
                ReplaceWithTextBlockFix.replaceWithTextBlock(new PsiExpression[]{literalExpression}, (PsiExpression)literalExpression);
                return;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)expression2, PsiPolyadicExpression.class);
            if (polyadicExpression == null || !TextBlockMigrationInspection.isConcatenation(polyadicExpression)) {
                return;
            }
            ReplaceWithTextBlockFix.replaceWithTextBlock(polyadicExpression.getOperands(), (PsiExpression)polyadicExpression);
        }

        private static void replaceWithTextBlock(PsiExpression @NotNull [] operands2, @NotNull PsiExpression toReplace) {
            String[] lines = ReplaceWithTextBlockFix.getContentLines(operands2);
            if (lines == null) {
                return;
            }
            String textBlock = ReplaceWithTextBlockFix.getTextBlock(lines);
            PsiReplacementUtil.replaceExpression(toReplace, textBlock, new CommentTracker());
        }

        @NotNull
        private static String getTextBlock(String @NotNull [] lines) {
            int indent = PsiLiteralUtil.getTextBlockIndent((String[])(lines = ReplaceWithTextBlockFix.getTextBlockLines(lines)), (boolean)true, (boolean)true);
            if (indent > 0 && lines.length > 0 && lines[lines.length - 1].endsWith("\n")) {
                indent = 0;
            }
            return "\"\"\"\n" + ReplaceWithTextBlockFix.concatenateTextBlockLines(lines, indent) + "\"\"\"" + (indent > 0 ? ".indent(" + indent + ")" : "");
        }

        private static String @NotNull [] getTextBlockLines(String @NotNull [] lines) {
            String blockLines = PsiLiteralUtil.escapeTextBlockCharacters((String)StringUtil.join((String[])lines), (boolean)true, (boolean)true, (boolean)true);
            return blockLines.split("(?<=\n)");
        }

        private static String concatenateTextBlockLines(String @NotNull [] lines, int indent) {
            if (indent <= 0) {
                return StringUtil.join((String[])lines);
            }
            return Arrays.stream(lines).map(line -> indent < line.length() ? line.substring(indent) : line).collect(Collectors.joining());
        }

        private static String @Nullable [] getContentLines(PsiExpression @NotNull [] operands2) {
            String[] lines = new String[operands2.length];
            for (int i = 0; i < operands2.length; ++i) {
                PsiExpression operand2 = operands2[i];
                PsiLiteralExpression literal = TextBlockMigrationInspection.getLiteralExpression(operand2);
                if (literal == null) {
                    return null;
                }
                String line = ReplaceWithTextBlockFix.getLiteralText(literal);
                if (line == null) {
                    return null;
                }
                lines[i] = line;
            }
            return lines;
        }

        @Nullable
        private static String getLiteralText(@NotNull PsiLiteralExpression literal) {
            if (!literal.isTextBlock() && ExpressionUtils.hasStringType((PsiExpression)literal)) {
                return PsiLiteralUtil.getStringLiteralContent((PsiLiteralExpression)literal);
            }
            Object value2 = literal.getValue();
            return value2 == null ? null : value2.toString();
        }
    }
}

