/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingFeature;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.StringJoiner;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TextBlockBackwardMigrationInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!HighlightingFeature.TEXT_BLOCKS.isAvailable((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitLiteralExpression(PsiLiteralExpression expression2) {
                if (!expression2.isTextBlock() || PsiLiteralUtil.getTextBlockText((PsiLiteralExpression)expression2) == null) {
                    return;
                }
                holder.registerProblem((PsiElement)expression2, JavaBundle.message((String)"inspection.text.block.backward.migration.message", (Object[])new Object[0]), new LocalQuickFix[]{new ReplaceWithRegularStringLiteralFix()});
            }
        };
    }

    private static class ReplaceWithRegularStringLiteralFix
    implements LocalQuickFix {
        private ReplaceWithRegularStringLiteralFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"inspection.replace.with.regular.string.literal.fix", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)ObjectUtils.tryCast((Object)descriptor.getPsiElement(), PsiLiteralExpression.class);
            if (literalExpression == null || !literalExpression.isTextBlock()) {
                return;
            }
            String text2 = PsiLiteralUtil.getTextBlockText((PsiLiteralExpression)literalExpression);
            if (text2 == null) {
                return;
            }
            String replacement = ReplaceWithRegularStringLiteralFix.convertToConcatenation(text2);
            PsiFile file = descriptor.getPsiElement().getContainingFile();
            if (file == null) {
                return;
            }
            CodeStyleSettings tempSettings = CodeStyle.getSettings((PsiFile)file);
            tempSettings.getCommonSettings((Language)JavaLanguage.INSTANCE).ALIGN_MULTILINE_BINARY_OPERATION = true;
            CodeStyleManager manager = CodeStyleManager.getInstance((Project)literalExpression.getProject());
            CodeStyle.doWithTemporarySettings((Project)project, (CodeStyleSettings)tempSettings, () -> {
                PsiElement result = new CommentTracker().replaceAndRestoreComments((PsiElement)literalExpression, replacement);
                manager.reformat(result);
            });
        }

        @NotNull
        private static String convertToConcatenation(@NotNull String text2) {
            if (text2.isEmpty()) {
                return "\"\"";
            }
            StringJoiner joiner = new StringJoiner(" +\n");
            String[] lines = ReplaceWithRegularStringLiteralFix.getTextBlockLines(text2).split("\n", -1);
            for (int i = 0; i < lines.length; ++i) {
                boolean addNewLine;
                String line = lines[i];
                boolean bl = addNewLine = i != lines.length - 1;
                if (!addNewLine && line.isEmpty()) break;
                joiner.add("\"" + line + (addNewLine ? "\\n\"" : "\""));
            }
            return joiner.toString();
        }

        @NotNull
        private static String getTextBlockLines(@NotNull String text2) {
            int length = text2.length();
            StringBuilder result = new StringBuilder(length);
            int i = 0;
            while (i < length) {
                int nSlashes = 0;
                int next = i;
                while (next < length && (next = PsiLiteralUtil.parseBackSlash((String)text2, (int)next)) != -1) {
                    ++nSlashes;
                    i = next;
                }
                if (i >= length) {
                    result.append(StringUtil.repeatSymbol((char)'\\', (int)nSlashes));
                    break;
                }
                next = ReplaceWithRegularStringLiteralFix.parseQuote(i, text2, nSlashes, result);
                if (next != -1) {
                    i = next;
                    continue;
                }
                if (nSlashes != 0) {
                    i = ReplaceWithRegularStringLiteralFix.parseEscapedChar(i, text2, nSlashes, result);
                    continue;
                }
                result.append(text2.charAt(i));
                ++i;
            }
            return result.toString();
        }

        private static int parseEscapedChar(int i, @NotNull String text2, int nSlashes, @NotNull StringBuilder result) {
            int next = ReplaceWithRegularStringLiteralFix.parseEscapedSpace(i, text2, nSlashes, result);
            if (next != -1) {
                return next;
            }
            next = ReplaceWithRegularStringLiteralFix.parseEscapedLineBreak(i, text2, nSlashes, result);
            if (next != -1) {
                return next;
            }
            result.append(StringUtil.repeatSymbol((char)'\\', (int)nSlashes)).append(text2.charAt(i));
            return i + 1;
        }

        private static int parseEscapedSpace(int i, @NotNull String text2, int nSlashes, @NotNull StringBuilder result) {
            char c = text2.charAt(i);
            if (c == 's' && nSlashes % 2 != 0) {
                result.append(StringUtil.repeatSymbol((char)'\\', (int)(nSlashes - 1))).append(' ');
                return i + 1;
            }
            if (StringUtil.startsWith((CharSequence)text2, (int)i, (CharSequence)"040") && nSlashes % 2 != 0) {
                result.append(StringUtil.repeatSymbol((char)'\\', (int)(nSlashes - 1))).append(' ');
                return i + 3;
            }
            return -1;
        }

        private static int parseEscapedLineBreak(int i, @NotNull String text2, int nSlashes, @NotNull StringBuilder result) {
            char c = text2.charAt(i);
            if (c == '\n' && nSlashes % 2 != 0) {
                result.append(StringUtil.repeatSymbol((char)'\\', (int)(nSlashes - 1)));
                return i + 1;
            }
            return -1;
        }

        private static int parseQuote(int i, @NotNull String text2, int nSlashes, @NotNull StringBuilder result) {
            char c = text2.charAt(i);
            if (c != '\"') {
                return -1;
            }
            if (nSlashes % 2 == 0) {
                ++nSlashes;
            }
            result.append(StringUtil.repeatSymbol((char)'\\', (int)nSlashes)).append(c);
            return i + 1;
        }
    }
}

