/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.generation.surroundWith.JavaWithIfSurrounder;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.trivialif.MergeIfAndIntention;
import org.jetbrains.annotations.NotNull;

public class SurroundWithIfFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance(SurroundWithIfFix.class);
    private final String myText;
    private final String mySuffix;

    @NotNull
    public String getName() {
        return JavaBundle.message((String)"inspection.surround.if.quickfix", (Object[])new Object[]{this.myText, this.mySuffix});
    }

    public SurroundWithIfFix(@NotNull PsiExpression expressionToAssert, String suffix) {
        this.myText = ParenthesesUtils.getText(expressionToAssert, 10);
        this.mySuffix = suffix;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Editor editor;
        PsiElement element = descriptor.getPsiElement();
        PsiElement anchorStatement = RefactoringUtil.getParentStatement(element, false);
        LOG.assertTrue(anchorStatement != null);
        if (anchorStatement.getParent() instanceof PsiLambdaExpression) {
            PsiCodeBlock body2 = RefactoringUtil.expandExpressionLambdaToCodeBlock((PsiLambdaExpression)anchorStatement.getParent());
            anchorStatement = body2.getStatements()[0];
        }
        if ((editor = PsiEditorUtil.findEditor((PsiElement)anchorStatement)) == null) {
            return;
        }
        PsiFile file = anchorStatement.getContainingFile();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = documentManager.getDocument(file);
        if (document == null) {
            return;
        }
        PsiElement[] elements = new PsiElement[]{anchorStatement};
        PsiElement prev = PsiTreeUtil.skipWhitespacesBackward((PsiElement)anchorStatement);
        if (prev instanceof PsiComment && JavaSuppressionUtil.getSuppressedInspectionIdsIn(prev) != null) {
            elements = new PsiElement[]{prev, anchorStatement};
        }
        try {
            TextRange textRange = new JavaWithIfSurrounder().surroundElements(project, editor, elements);
            if (textRange == null) {
                return;
            }
            String newText = this.myText + this.mySuffix;
            document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)newText);
            editor.getCaretModel().moveToOffset(textRange.getEndOffset() + newText.length());
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            new MergeIfAndIntention().invoke(project, editor, file);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"inspection.surround.if.family", (Object[])new Object[0]);
    }

    public static boolean isAvailable(PsiExpression qualifier) {
        if (!qualifier.isValid() || qualifier.getText() == null) {
            return false;
        }
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)qualifier, PsiStatement.class);
        if (statement == null) {
            return false;
        }
        PsiElement parent = statement.getParent();
        return !(parent instanceof PsiForStatement);
    }
}

