/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.CountingLoop;
import com.siyeh.ig.psiutils.JavaPsiMathUtil;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringRepeatCanBeUsedInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher APPEND = CallMatcher.instanceCall("java.lang.AbstractStringBuilder", "append").parameterCount(1);
    public boolean ADD_MATH_MAX = true;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JavaBundle.message((String)"label.add.math.max.0.count.to.avoid.possible.semantics.change", (Object[])new Object[0]), (InspectionProfileEntry)this, "ADD_MATH_MAX");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!PsiUtil.isLanguageLevel11OrHigher((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitForStatement(PsiForStatement statement) {
                PsiMethodCallExpression call = StringRepeatCanBeUsedInspection.findAppendCall(statement);
                if (call == null) {
                    return;
                }
                PsiReferenceExpression qualifier = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getMethodExpression().getQualifierExpression()), PsiReferenceExpression.class);
                if (qualifier == null || !ExpressionUtil.isEffectivelyUnqualified(qualifier)) {
                    return;
                }
                CountingLoop loop = CountingLoop.from(statement);
                if (loop == null) {
                    return;
                }
                PsiLocalVariable var = loop.getCounter();
                if (var.getType().equals(PsiType.LONG) || VariableAccessUtils.variableIsUsed((PsiVariable)var, (PsiElement)call)) {
                    return;
                }
                PsiExpression arg = call.getArgumentList().getExpressions()[0];
                if (SideEffectChecker.mayHaveSideEffects(arg)) {
                    return;
                }
                holder.registerProblem(statement.getFirstChild(), JavaBundle.message((String)"inspection.message.can.be.replaced.with.string.repeat", (Object[])new Object[0]), new LocalQuickFix[]{new StringRepeatCanBeUsedFix(StringRepeatCanBeUsedInspection.this.ADD_MATH_MAX)});
            }
        };
    }

    @Nullable
    private static PsiMethodCallExpression findAppendCall(PsiForStatement statement) {
        PsiExpressionStatement body2 = (PsiExpressionStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces(statement.getBody()), PsiExpressionStatement.class);
        if (body2 == null) {
            return null;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)body2.getExpression(), PsiMethodCallExpression.class);
        if (!APPEND.test(call)) {
            return null;
        }
        return call;
    }

    private static class StringRepeatCanBeUsedFix
    implements LocalQuickFix {
        private final boolean myAddMathMax;

        private StringRepeatCanBeUsedFix(boolean addMathMax) {
            this.myAddMathMax = addMathMax;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"String.repeat()"});
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethodCallExpression appendCall;
            PsiMethodCallExpression repeatCall;
            PsiMethodCallExpression maxCall;
            PsiExpression count;
            LongRangeSet range;
            PsiExpression to;
            PsiExpression from;
            PsiForStatement statement = (PsiForStatement)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiForStatement.class);
            if (statement == null) {
                return;
            }
            CountingLoop loop = CountingLoop.from(statement);
            if (loop == null) {
                return;
            }
            PsiMethodCallExpression call = StringRepeatCanBeUsedInspection.findAppendCall(statement);
            if (call == null) {
                return;
            }
            PsiExpression builder = call.getMethodExpression().getQualifierExpression();
            if (builder == null) {
                return;
            }
            PsiExpression arg = call.getArgumentList().getExpressions()[0];
            if (loop.isDescending()) {
                from = loop.getBound();
                to = loop.getInitializer();
            } else {
                from = loop.getInitializer();
                to = loop.getBound();
            }
            CommentTracker ct = new CommentTracker();
            String repeatQualifier = StringRepeatCanBeUsedFix.getRepeatQualifier(arg, ct);
            String countText = StringRepeatCanBeUsedFix.getCountText(from, to, loop.isIncluding(), ct);
            if (this.myAddMathMax) {
                countText = "java.lang.Math.max(0," + countText + ")";
            }
            String replacement = repeatQualifier + ".repeat(" + countText + ")";
            ct.replace((PsiElement)arg, replacement);
            PsiExpressionStatement result = (PsiExpressionStatement)ct.replaceAndRestoreComments((PsiElement)statement, call.getParent());
            if (this.myAddMathMax && (range = CommonDataflow.getExpressionRange(count = (maxCall = (PsiMethodCallExpression)(repeatCall = (PsiMethodCallExpression)(appendCall = (PsiMethodCallExpression)result.getExpression()).getArgumentList().getExpressions()[0]).getArgumentList().getExpressions()[0]).getArgumentList().getExpressions()[1])) != null && !range.isEmpty() && range.min() >= 0L) {
                maxCall.replace((PsiElement)count);
            }
        }

        @NotNull
        private static String getCountText(PsiExpression from, PsiExpression to, boolean including, CommentTracker ct) {
            int origin;
            String countText = null;
            Number fromNumber = JavaPsiMathUtil.getNumberFromLiteral(from);
            if (fromNumber instanceof Integer && (origin = fromNumber.intValue()) < Integer.MAX_VALUE) {
                if (including) {
                    --origin;
                }
                countText = JavaPsiMathUtil.add(to, -origin, ct);
            }
            if (countText == null) {
                countText = ct.text(to, 6) + "-" + ct.text(from, 5);
                if (including) {
                    PsiExpression expr2 = JavaPsiFacade.getElementFactory((Project)from.getProject()).createExpressionFromText(countText, (PsiElement)from);
                    countText = JavaPsiMathUtil.add(expr2, 1, ct);
                }
            }
            return countText;
        }

        @NotNull
        private static String getRepeatQualifier(PsiExpression arg, CommentTracker ct) {
            if (arg instanceof PsiLiteralExpression && !TypeUtils.isJavaLangString(arg.getType())) {
                PsiLiteralExpression literal = (PsiLiteralExpression)arg;
                Object value2 = literal.getValue();
                if (value2 instanceof Character) {
                    return PsiLiteralUtil.stringForCharLiteral((String)literal.getText());
                }
                return StringUtil.wrapWithDoubleQuote((String)StringUtil.escapeStringCharacters((String)String.valueOf(value2)));
            }
            if (TypeUtils.isJavaLangString(arg.getType()) && NullabilityUtil.getExpressionNullability(arg, true) == Nullability.NOT_NULL) {
                return ct.text(arg, 1);
            }
            return "java.lang.String.valueOf(" + ct.text((PsiElement)arg) + ")";
        }
    }
}

