/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import org.jetbrains.annotations.NotNull;

public class ReplaceTypeInCastFix
implements LocalQuickFix {
    private final String myExistingTypeText;
    private final String myWantedTypeText;
    private final String myWantedTypeCanonicalText;

    public ReplaceTypeInCastFix(PsiType existingType, PsiType wantedType) {
        this.myExistingTypeText = existingType.getPresentableText();
        this.myWantedTypeText = wantedType.getPresentableText();
        this.myWantedTypeCanonicalText = wantedType.getCanonicalText();
    }

    @NotNull
    public String getName() {
        return InspectionGadgetsBundle.message("cast.conflicts.with.instanceof.quickfix1", this.myExistingTypeText, this.myWantedTypeText);
    }

    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"quickfix.family.replace.cast.type", (Object[])new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiTypeElement typeElement = (PsiTypeElement)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiTypeElement.class);
        if (typeElement == null) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiTypeElement replacement = factory.createTypeElement(factory.createTypeFromText(this.myWantedTypeCanonicalText, (PsiElement)typeElement));
        typeElement.replace((PsiElement)replacement);
    }
}

