/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceNullCheckInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final EquivalenceChecker ourEquivalence = EquivalenceChecker.getCanonicalPsiEquivalence();
    private static final int MINIMAL_WARN_DELTA_SIZE = 30;
    private static final CallMatcher STREAM_EMPTY = CallMatcher.staticCall("java.util.stream.Stream", "empty").parameterCount(0);
    private static final CallMatcher STREAM_OF = CallMatcher.anyOf(CallMatcher.staticCall("java.util.stream.Stream", "ofNullable").parameterCount(1), CallMatcher.staticCall("java.util.stream.Stream", "of").parameterTypes("T"));
    public boolean noWarningReplacementBigger = true;

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(JavaBundle.message((String)"inspection.require.non.null.no.warning.replacement.bigger", (Object[])new Object[0]), "noWarningReplacementBigger");
        return panel2;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        PsiFile file = holder.getFile();
        if (!PsiUtil.isLanguageLevel9OrHigher((PsiElement)file)) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitIfStatement(PsiIfStatement ifStatement) {
                NotNullContext context = NotNullContext.from(ifStatement);
                if (context == null) {
                    return;
                }
                String method = ReplaceNullCheckInspection.getMethodWithClass(context.myExpressionToReplace, context.myIsStream);
                PsiStatement nextToDelete = context.myNextToDelete;
                int maybeImplicitElseLength = nextToDelete != null ? nextToDelete.getTextLength() : 0;
                boolean isInfoLevel = ReplaceNullCheckInspection.this.noWarningReplacementBigger && ifStatement.getTextLength() + maybeImplicitElseLength - context.getLenAfterReplace() < 30;
                ProblemHighlightType highlight = this.getHighlight(context, isInfoLevel);
                if (!isOnTheFly && highlight == ProblemHighlightType.INFORMATION) {
                    return;
                }
                holder.registerProblem(ifStatement.getFirstChild(), JavaBundle.message((String)"inspection.require.non.null.message", (Object[])new Object[]{method}), highlight, new LocalQuickFix[]{new ReplaceWithRequireNonNullFix(method, false)});
            }

            @NotNull
            private ProblemHighlightType getHighlight(NotNullContext context, boolean isInfoLevel) {
                if (context.myIsStream) {
                    return ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                }
                if (isInfoLevel) {
                    return ProblemHighlightType.INFORMATION;
                }
                return ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            }

            public void visitConditionalExpression(PsiConditionalExpression ternary) {
                ProblemHighlightType highlightType;
                TernaryNotNullContext context = TernaryNotNullContext.from(ternary);
                if (context == null) {
                    return;
                }
                String method = ReplaceNullCheckInspection.getMethodWithClass(context.myNullExpr, false);
                String name2 = context.myReferenceExpression.getText();
                boolean replacementShorter = name2 != null && context.myNullExpr.getTextLength() + method.length() + name2.length() < context.myTernary.getTextLength() + 30;
                boolean isInfoLevel = ReplaceNullCheckInspection.this.noWarningReplacementBigger && replacementShorter;
                ProblemHighlightType problemHighlightType = highlightType = isInfoLevel ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                if (!isOnTheFly && highlightType == ProblemHighlightType.INFORMATION) {
                    return;
                }
                holder.registerProblem((PsiElement)ternary, JavaBundle.message((String)"inspection.require.non.null.message", (Object[])new Object[]{method}), highlightType, new LocalQuickFix[]{new ReplaceWithRequireNonNullFix(method, true)});
            }
        };
    }

    @NotNull
    private static PsiExpression createRequireExpression(@NotNull CommentTracker tracker, @NotNull PsiExpression expression2, @NotNull Project project, @NotNull PsiReferenceExpression nullableReference, @NotNull PsiElement context) {
        boolean isSimple = ExpressionUtils.isSafelyRecomputableExpression(expression2);
        String expr2 = tracker.text((PsiElement)expression2);
        if (!isSimple) {
            expr2 = "()->" + expr2;
        }
        String varName = nullableReference.getText();
        String requireCallText = "java.util.Objects." + ReplaceNullCheckInspection.getMethod(expression2) + "(" + varName + "," + expr2 + ")";
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        return factory.createExpressionFromText(requireCallText, context);
    }

    @NotNull
    private static String getMethod(PsiExpression expression2) {
        return ExpressionUtils.isSafelyRecomputableExpression(expression2) ? "requireNonNullElse" : "requireNonNullElseGet";
    }

    @NotNull
    private static String getMethodWithClass(PsiExpression expression2, boolean isStream) {
        return isStream ? "Stream.ofNullable" : "Objects." + ReplaceNullCheckInspection.getMethod(expression2);
    }

    private static class TopmostQualifierDiff {
        @Nullable
        private final PsiExpression myLeft;
        @Nullable
        private final PsiExpression myRight;

        private TopmostQualifierDiff(@Nullable PsiExpression left, @Nullable PsiExpression right) {
            this.myLeft = left;
            this.myRight = right;
        }

        @Nullable
        public PsiExpression getRight() {
            return this.myRight;
        }

        @Nullable
        public PsiExpression getLeft() {
            return this.myLeft;
        }

        @Nullable
        static TopmostQualifierDiff from(@Nullable PsiExpression left, @Nullable PsiExpression right) {
            PsiExpression rightQualifier;
            PsiExpression leftQualifier;
            PsiMethodCallExpression leftCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)left, PsiMethodCallExpression.class);
            PsiMethodCallExpression rightCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)right, PsiMethodCallExpression.class);
            if (leftCall == null || rightCall == null) {
                return null;
            }
            do {
                PsiExpression[] rightExpressions;
                PsiReferenceExpression leftMethodExpression = leftCall.getMethodExpression();
                PsiReferenceExpression rightMethodExpression = rightCall.getMethodExpression();
                if (ObjectUtils.tryCast((Object)leftMethodExpression.resolve(), PsiMethod.class) != ObjectUtils.tryCast((Object)rightMethodExpression.resolve(), PsiMethod.class)) {
                    return null;
                }
                PsiExpression[] leftExpressions = leftCall.getArgumentList().getExpressions();
                int length = leftExpressions.length;
                if (length != (rightExpressions = rightCall.getArgumentList().getExpressions()).length) {
                    return null;
                }
                for (int i = 0; i < length; ++i) {
                    if (ourEquivalence.expressionsAreEquivalent(leftExpressions[i], rightExpressions[i])) continue;
                    return null;
                }
                leftQualifier = leftMethodExpression.getQualifierExpression();
                leftCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)leftQualifier, PsiMethodCallExpression.class);
                rightQualifier = rightMethodExpression.getQualifierExpression();
                rightCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)rightQualifier, PsiMethodCallExpression.class);
            } while (leftCall != null && rightCall != null);
            return new TopmostQualifierDiff(leftQualifier, rightQualifier);
        }
    }

    private static class TernaryNotNullContext {
        @NotNull
        private final PsiConditionalExpression myTernary;
        @NotNull
        private final PsiExpression myNullExpr;
        @NotNull
        private final PsiReferenceExpression myReferenceExpression;

        private TernaryNotNullContext(@NotNull PsiConditionalExpression ternary, @NotNull PsiExpression nullExpr, @NotNull PsiReferenceExpression expression2) {
            this.myTernary = ternary;
            this.myNullExpr = nullExpr;
            this.myReferenceExpression = expression2;
        }

        @Nullable
        static TernaryNotNullContext from(@NotNull PsiConditionalExpression ternary) {
            PsiExpression nonNullBranch;
            PsiExpression nullBranch;
            PsiBinaryExpression binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)ternary.getCondition()), PsiBinaryExpression.class);
            if (binOp == null) {
                return null;
            }
            PsiExpression value2 = ExpressionUtils.getValueComparedWithNull(binOp);
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)value2), PsiReferenceExpression.class);
            if (referenceExpression == null) {
                return null;
            }
            PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)referenceExpression.resolve(), PsiVariable.class);
            if (variable == null) {
                return null;
            }
            boolean negated = binOp.getOperationTokenType() == JavaTokenType.NE;
            PsiExpression psiExpression = nullBranch = negated ? ternary.getElseExpression() : ternary.getThenExpression();
            if (ClassUtils.isPrimitive(variable.getType())) {
                return null;
            }
            PsiExpression psiExpression2 = nonNullBranch = negated ? ternary.getThenExpression() : ternary.getElseExpression();
            if (!ExpressionUtils.isReferenceTo(nonNullBranch, variable)) {
                return null;
            }
            if (NullabilityUtil.getExpressionNullability(nullBranch, true) != Nullability.NOT_NULL) {
                return null;
            }
            if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)nullBranch)) {
                return null;
            }
            return new TernaryNotNullContext(ternary, nullBranch, referenceExpression);
        }
    }

    private static class NotNullContext {
        @NotNull
        private final PsiExpression myExpressionToReplace;
        @NotNull
        private final PsiExpression myDiff;
        @NotNull
        private final PsiStatement myNullBranchStmt;
        @NotNull
        private final PsiReferenceExpression myReference;
        @NotNull
        private final PsiIfStatement myIfStatement;
        @Nullable
        private final PsiStatement myNextToDelete;
        private final boolean myIsStream;

        private NotNullContext(@NotNull PsiExpression expressionToReplace, @NotNull PsiExpression diff, @NotNull PsiStatement nullBranchStmt, @NotNull PsiReferenceExpression reference, @NotNull PsiIfStatement statement, @Nullable PsiStatement nextToDelete, boolean isStream) {
            this.myExpressionToReplace = expressionToReplace;
            this.myDiff = diff;
            this.myNullBranchStmt = nullBranchStmt;
            this.myReference = reference;
            this.myIfStatement = statement;
            this.myNextToDelete = nextToDelete;
            this.myIsStream = isStream;
        }

        int getLenAfterReplace() {
            int lengthAfterReplace = this.myExpressionToReplace.getTextLength() + ReplaceNullCheckInspection.getMethodWithClass(this.myExpressionToReplace, this.myIsStream).length();
            if (!this.myIsStream) {
                lengthAfterReplace += this.myNullBranchStmt.getTextLength() + 6;
            }
            return lengthAfterReplace;
        }

        @Nullable
        static NotNullContext from(@NotNull PsiIfStatement ifStatement) {
            PsiExpression condition2 = ifStatement.getCondition();
            if (condition2 == null) {
                return null;
            }
            PsiBinaryExpression binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)condition2, PsiBinaryExpression.class);
            if (binOp == null) {
                return null;
            }
            PsiExpression value2 = ExpressionUtils.getValueComparedWithNull(binOp);
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)ObjectUtils.tryCast((Object)value2, PsiReferenceExpression.class);
            if (referenceExpression == null) {
                return null;
            }
            PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)referenceExpression.resolve(), PsiVariable.class);
            if (variable == null) {
                return null;
            }
            if (ClassUtils.isPrimitive(variable.getType())) {
                return null;
            }
            boolean inverted = binOp.getOperationTokenType() == JavaTokenType.NE;
            PsiStatement elseBranch = ControlFlowUtils.stripBraces(ifStatement.getElseBranch());
            PsiStatement thenBranch = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
            if (elseBranch != null) {
                PsiStatement nullBranch = inverted ? thenBranch : elseBranch;
                PsiStatement nonNullBranch = inverted ? elseBranch : thenBranch;
                return NotNullContext.extractContext(ifStatement, variable, referenceExpression, nullBranch, nonNullBranch, null);
            }
            PsiReturnStatement nextReturn = (PsiReturnStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)ifStatement), PsiReturnStatement.class);
            if (nextReturn == null) {
                return null;
            }
            if (thenBranch instanceof PsiReturnStatement) {
                PsiStatement nullBranch = inverted ? thenBranch : nextReturn;
                PsiReturnStatement nonNullBranch = inverted ? nextReturn : thenBranch;
                return NotNullContext.extractContext(ifStatement, variable, referenceExpression, nullBranch, (PsiStatement)nonNullBranch, nextReturn);
            }
            return null;
        }

        @Contract(value="_, _, _, null, _, _ -> null")
        private static NotNullContext extractContext(@NotNull PsiIfStatement ifStatement, @NotNull PsiVariable variable, @NotNull PsiReferenceExpression reference, @Nullable PsiStatement nullBranch, @Nullable PsiStatement nonNullBranch, @Nullable PsiReturnStatement toDelete) {
            if (nullBranch == null) {
                return null;
            }
            EquivalenceChecker.Match match = ourEquivalence.statementsMatch(nullBranch, nonNullBranch);
            PsiExpression nullDiff = (PsiExpression)ObjectUtils.tryCast((Object)match.getLeftDiff(), PsiExpression.class);
            PsiExpression nonNullDiff = (PsiExpression)ObjectUtils.tryCast((Object)match.getRightDiff(), PsiExpression.class);
            if (!ExpressionUtils.isReferenceTo(nullDiff, variable)) {
                TopmostQualifierDiff qualifierDiff = TopmostQualifierDiff.from(nullDiff, nonNullDiff);
                if (qualifierDiff == null) {
                    PsiMethodCallExpression nullCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)nullDiff, PsiMethodCallExpression.class);
                    PsiMethodCallExpression nonNullCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)nonNullDiff, PsiMethodCallExpression.class);
                    if (nullCall == null || nonNullCall == null) {
                        return null;
                    }
                    if (!STREAM_EMPTY.test(nonNullCall) || !STREAM_OF.test(nullCall)) {
                        return null;
                    }
                    PsiExpression maybeRef = nullCall.getArgumentList().getExpressions()[0];
                    if (!ExpressionUtils.isReferenceTo(maybeRef, variable)) {
                        return null;
                    }
                    return new NotNullContext((PsiExpression)nullCall, maybeRef, nullBranch, reference, ifStatement, null, true);
                }
                nullDiff = qualifierDiff.getLeft();
                nonNullDiff = qualifierDiff.getRight();
                if (!ExpressionUtils.isReferenceTo(nullDiff, variable)) {
                    return null;
                }
            }
            if (NullabilityUtil.getExpressionNullability(nonNullDiff, true) != Nullability.NOT_NULL) {
                return null;
            }
            if (nonNullDiff instanceof PsiSuperExpression) {
                return null;
            }
            if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)nonNullDiff)) {
                return null;
            }
            return new NotNullContext(nonNullDiff, nullDiff, nullBranch, reference, ifStatement, (PsiStatement)toDelete, false);
        }
    }

    private static class ReplaceWithRequireNonNullFix
    implements LocalQuickFix {
        @NotNull
        private final String myMethod;
        private final boolean myIsTernary;

        private ReplaceWithRequireNonNullFix(@NotNull String method, boolean ternary) {
            this.myMethod = method;
            this.myIsTernary = ternary;
        }

        @Nls
        @NotNull
        public String getName() {
            return JavaBundle.message((String)"inspection.require.non.null.message", (Object[])new Object[]{this.myMethod});
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"inspection.require.non.null", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement result;
            PsiElement element;
            PsiElement psiElement = element = this.myIsTernary ? descriptor.getStartElement() : descriptor.getStartElement().getParent();
            if (element instanceof PsiIfStatement) {
                NotNullContext context = NotNullContext.from((PsiIfStatement)element);
                if (context == null) {
                    return;
                }
                CommentTracker tracker = new CommentTracker();
                PsiExpression expression2 = context.myExpressionToReplace;
                if (!context.myIsStream) {
                    PsiExpression requireCall = ReplaceNullCheckInspection.createRequireExpression(tracker, expression2, project, context.myReference, (PsiElement)context.myDiff);
                    context.myDiff.replace((PsiElement)requireCall);
                } else {
                    PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                    String streamOfNullableText = "java.util.stream.Stream.ofNullable(" + context.myReference.getText() + ")";
                    PsiExpression streamOfNullable = factory.createExpressionFromText(streamOfNullableText, (PsiElement)expression2);
                    expression2.replace((PsiElement)streamOfNullable);
                }
                result = tracker.replaceAndRestoreComments((PsiElement)context.myIfStatement, (PsiElement)context.myNullBranchStmt);
                if (context.myNextToDelete != null) {
                    context.myNextToDelete.delete();
                }
            } else if (element instanceof PsiConditionalExpression) {
                TernaryNotNullContext context = TernaryNotNullContext.from((PsiConditionalExpression)element);
                if (context == null) {
                    return;
                }
                CommentTracker tracker = new CommentTracker();
                PsiExpression requireCall = ReplaceNullCheckInspection.createRequireExpression(tracker, context.myNullExpr, project, context.myReferenceExpression, (PsiElement)context.myNullExpr);
                result = tracker.replaceAndRestoreComments((PsiElement)context.myTernary, (PsiElement)requireCall);
            } else {
                return;
            }
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
            CodeStyleManager.getInstance((Project)project).reformat(JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result));
        }
    }
}

