/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.AnnotateMethodFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.nullable.AnnotateOverriddenMethodParameterFix;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveAnnotationQuickFix
implements LocalQuickFix {
    private final SmartPsiElementPointer<PsiAnnotation> myAnnotation;
    private final SmartPsiElementPointer<PsiModifierListOwner> myListOwner;

    public RemoveAnnotationQuickFix(@NotNull PsiAnnotation annotation, @Nullable PsiModifierListOwner listOwner) {
        Project project = annotation.getProject();
        SmartPointerManager pm = SmartPointerManager.getInstance((Project)project);
        this.myAnnotation = pm.createSmartPsiElementPointer((PsiElement)annotation);
        this.myListOwner = listOwner == null ? null : pm.createSmartPsiElementPointer((PsiElement)listOwner);
    }

    protected boolean shouldRemoveInheritors() {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        return JavaAnalysisBundle.message((String)"remove.annotation", (Object[])new Object[0]);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiAnnotation annotation = (PsiAnnotation)this.myAnnotation.getElement();
        if (annotation == null) {
            return;
        }
        PsiModifierListOwner listOwner = this.myListOwner == null ? null : (PsiModifierListOwner)this.myListOwner.getElement();
        String qualifiedName = annotation.getQualifiedName();
        ArrayList<PsiAnnotation> physical = new ArrayList<PsiAnnotation>();
        ArrayList<PsiModifierListOwner> externalOwners = new ArrayList<PsiModifierListOwner>();
        RemoveAnnotationQuickFix.registerAnnotation(annotation, listOwner, physical, externalOwners);
        if (this.shouldRemoveInheritors() && qualifiedName != null) {
            Consumer<PsiModifierListOwner> inheritorProcessor = owner2 -> RemoveAnnotationQuickFix.registerAnnotation(AnnotationUtil.findAnnotation((PsiModifierListOwner)owner2, (String[])new String[]{qualifiedName}), owner2, physical, externalOwners);
            if (listOwner instanceof PsiMethod && !AnnotateMethodFix.processModifiableInheritorsUnderProgress((PsiMethod)listOwner, inheritorProcessor)) {
                return;
            }
            if (listOwner instanceof PsiParameter && !AnnotateOverriddenMethodParameterFix.processParameterInheritorsUnderProgress((PsiParameter)listOwner, inheritorProcessor)) {
                return;
            }
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(physical)) {
            return;
        }
        WriteAction.run(() -> physical.forEach(PsiElement::delete));
        if (qualifiedName != null) {
            for (PsiModifierListOwner owner3 : externalOwners) {
                ExternalAnnotationsManager.getInstance((Project)project).deannotate(owner3, qualifiedName);
            }
        }
    }

    private static void registerAnnotation(@Nullable PsiAnnotation annotation, @Nullable PsiModifierListOwner listOwner, @NotNull List<PsiAnnotation> physical, @NotNull List<PsiModifierListOwner> externalOwners) {
        if (annotation == null) {
            return;
        }
        if (AnnotationUtil.isExternalAnnotation((PsiAnnotation)annotation)) {
            ContainerUtil.addIfNotNull(externalOwners, (Object)listOwner);
        } else {
            physical.add(annotation);
        }
    }
}

