/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import java.util.Iterator;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RedundantExplicitCloseInspection
extends AbstractBaseJavaLocalInspectionTool {
    CallMatcher CLOSE = CallMatcher.instanceCall("java.lang.AutoCloseable", "close").parameterCount(0);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitTryStatement(PsiTryStatement statement) {
                PsiResourceList resourceList = statement.getResourceList();
                if (resourceList == null) {
                    return;
                }
                PsiCodeBlock tryBlock = statement.getTryBlock();
                if (tryBlock == null) {
                    return;
                }
                PsiStatement last = (PsiStatement)ArrayUtil.getLastElement((Object[])tryBlock.getStatements());
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)last, PsiExpressionStatement.class);
                if (expressionStatement == null) {
                    return;
                }
                PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expressionStatement.getExpression(), PsiMethodCallExpression.class);
                if (!RedundantExplicitCloseInspection.this.CLOSE.test(call)) {
                    return;
                }
                PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
                PsiReferenceExpression reference = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)qualifier), PsiReferenceExpression.class);
                if (reference == null) {
                    return;
                }
                PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)reference.resolve(), PsiVariable.class);
                if (variable == null) {
                    return;
                }
                boolean isReferenceToResourceVariable = StreamEx.of((Iterator)resourceList.iterator()).anyMatch(element -> variable == element || element instanceof PsiResourceExpression && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)reference, ((PsiResourceExpression)element).getExpression()));
                if (!isReferenceToResourceVariable) {
                    return;
                }
                holder.registerProblem((PsiElement)last, JavaBundle.message((String)"inspection.redundant.explicit.close", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new DeleteRedundantCloseFix()});
            }
        };
    }

    private static class DeleteRedundantCloseFix
    implements LocalQuickFix {
        private DeleteRedundantCloseFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return CommonQuickFixBundle.message((String)"fix.remove.redundant", (Object[])new Object[]{"close()"});
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getStartElement();
            new CommentTracker().deleteAndRestoreComments(element);
        }
    }
}

