/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingFeature;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.InstanceOfUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatternVariableCanBeUsedInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!HighlightingFeature.PATTERNS.isAvailable((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitLocalVariable(PsiLocalVariable variable) {
                PsiIdentifier identifier = variable.getNameIdentifier();
                if (identifier == null) {
                    return;
                }
                PsiTypeCastExpression cast = (PsiTypeCastExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)variable.getInitializer()), PsiTypeCastExpression.class);
                if (cast == null || cast.getOperand() == null || cast.getCastType() == null) {
                    return;
                }
                PsiType castType = cast.getCastType().getType();
                if (castType instanceof PsiPrimitiveType) {
                    return;
                }
                if (!variable.getType().equals(castType)) {
                    return;
                }
                PsiElement scope = PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
                if (scope == null) {
                    return;
                }
                PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)variable.getParent(), PsiDeclarationStatement.class);
                if (declaration2 == null) {
                    return;
                }
                if (!variable.hasModifierProperty("final") && !HighlightControlFlowUtil.isEffectivelyFinal((PsiVariable)variable, scope, null)) {
                    return;
                }
                PsiInstanceOfExpression instanceOf = InstanceOfUtils.findPatternCandidate(cast);
                if (instanceOf != null) {
                    String name2 = identifier.getText();
                    holder.registerProblem((PsiElement)identifier, InspectionGadgetsBundle.message("inspection.pattern.variable.can.be.used.message", name2), new LocalQuickFix[]{new PatternVariableCanBeUsedFix(name2, instanceOf)});
                }
            }
        };
    }

    private static class PatternVariableCanBeUsedFix
    implements LocalQuickFix {
        private final SmartPsiElementPointer<PsiInstanceOfExpression> myInstanceOfPointer;
        private final String myName;

        public PatternVariableCanBeUsedFix(@NotNull String name2, @NotNull PsiInstanceOfExpression instanceOf) {
            this.myName = name2;
            this.myInstanceOfPointer = SmartPointerManager.createPointer((PsiElement)instanceOf);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("inspection.pattern.variable.can.be.used.fix.name", this.myName);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("inspection.pattern.variable.can.be.used.fix.family.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiLocalVariable variable = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiLocalVariable.class);
            if (variable == null) {
                return;
            }
            PsiTypeCastExpression cast = (PsiTypeCastExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)variable.getInitializer()), PsiTypeCastExpression.class);
            if (cast == null) {
                return;
            }
            PsiTypeElement typeElement = cast.getCastType();
            if (typeElement == null) {
                return;
            }
            PsiInstanceOfExpression instanceOf = (PsiInstanceOfExpression)this.myInstanceOfPointer.getElement();
            if (instanceOf == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            ct.replace((PsiElement)instanceOf, ct.text((PsiElement)instanceOf.getOperand()) + " instanceof " + typeElement.getText() + " " + variable.getName());
            ct.deleteAndRestoreComments((PsiElement)variable);
        }

        @Nullable
        public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
            PsiInstanceOfExpression instanceOf = (PsiInstanceOfExpression)this.myInstanceOfPointer.getElement();
            return instanceOf == null ? null : new PatternVariableCanBeUsedFix(this.myName, (PsiInstanceOfExpression)PsiTreeUtil.findSameElementInCopy((PsiElement)instanceOf, (PsiFile)target));
        }
    }
}

