/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInspection.AnnotatedApiUsageUtil;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.uast.UastVisitorAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \n2\u00020\u0001:\u0002\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/codeInspection/MissingDeprecatedAnnotationOnScheduledForRemovalApiInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "runForWholeFile", "Companion", "MissingDeprecatedAnnotationOnSFRVisitor", "intellij.jvm.analysis.impl"})
public final class MissingDeprecatedAnnotationOnScheduledForRemovalApiInspection
extends LocalInspectionTool {
    private static final String DEPRECATED_ANNOTATION_NAME;
    private static final String KOTLIN_DEPRECATED_ANNOTATION_NAME;
    private static final String SCHEDULED_FOR_REMOVAL_ANNOTATION_NAME;
    private static final Companion Companion;

    public boolean runForWholeFile() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!AnnotatedApiUsageUtil.INSTANCE.canAnnotationBeUsedInFile(SCHEDULED_FOR_REMOVAL_ANNOTATION_NAME, holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return (PsiElementVisitor)new UastVisitorAdapter((AbstractUastNonRecursiveVisitor)new MissingDeprecatedAnnotationOnSFRVisitor(holder), true);
    }

    static {
        Companion = new Companion(null);
        DEPRECATED_ANNOTATION_NAME = Deprecated.class.getCanonicalName();
        KOTLIN_DEPRECATED_ANNOTATION_NAME = kotlin.Deprecated.class.getCanonicalName();
        SCHEDULED_FOR_REMOVAL_ANNOTATION_NAME = ApiStatus.ScheduledForRemoval.class.getCanonicalName();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\rH\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/codeInspection/MissingDeprecatedAnnotationOnScheduledForRemovalApiInspection$MissingDeprecatedAnnotationOnSFRVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "checkMissingDeprecatedAnnotationOnScheduledForRemovalApi", "", "node", "Lorg/jetbrains/uast/UDeclaration;", "createAnnotationFix", "Lcom/intellij/codeInsight/intention/AddAnnotationFix;", "hasDeprecatedAnnotation", "", "Lorg/jetbrains/uast/UAnnotated;", "isScheduledForRemoval", "annotated", "visitClass", "Lorg/jetbrains/uast/UClass;", "visitField", "Lorg/jetbrains/uast/UField;", "visitMethod", "Lorg/jetbrains/uast/UMethod;", "intellij.jvm.analysis.impl"})
    private static final class MissingDeprecatedAnnotationOnSFRVisitor
    extends AbstractUastNonRecursiveVisitor {
        private final ProblemsHolder problemsHolder;

        public boolean visitClass(@NotNull UClass node) {
            this.checkMissingDeprecatedAnnotationOnScheduledForRemovalApi((UDeclaration)node);
            return true;
        }

        public boolean visitMethod(@NotNull UMethod node) {
            this.checkMissingDeprecatedAnnotationOnScheduledForRemovalApi((UDeclaration)node);
            return true;
        }

        public boolean visitField(@NotNull UField node) {
            this.checkMissingDeprecatedAnnotationOnScheduledForRemovalApi((UDeclaration)node);
            return true;
        }

        private final void checkMissingDeprecatedAnnotationOnScheduledForRemovalApi(UDeclaration node) {
            if (this.isScheduledForRemoval((UAnnotated)node) && !this.hasDeprecatedAnnotation((UAnnotated)node)) {
                PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)node.getUastAnchor());
                if (psiElement == null) {
                    return;
                }
                PsiElement identifierPsi = psiElement;
                this.problemsHolder.registerProblem(identifierPsi, JvmAnalysisBundle.message("jvm.inspections.missing.deprecated.annotation.on.scheduled.for.removal.api.description", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{(LocalQuickFix)this.createAnnotationFix(node)});
            }
        }

        private final AddAnnotationFix createAnnotationFix(UDeclaration node) {
            PsiElement psiElement = node.getSourcePsi();
            if (!(psiElement instanceof PsiModifierListOwner)) {
                psiElement = null;
            }
            PsiModifierListOwner psiModifierListOwner = (PsiModifierListOwner)psiElement;
            if (psiModifierListOwner == null) {
                return null;
            }
            PsiModifierListOwner modifierListOwner = psiModifierListOwner;
            Companion;
            return new AddAnnotationFix(DEPRECATED_ANNOTATION_NAME, modifierListOwner, new String[0]);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean hasDeprecatedAnnotation(UAnnotated node) {
            Companion;
            if (node.findAnnotation(DEPRECATED_ANNOTATION_NAME) != null) return true;
            Companion;
            if (node.findAnnotation(KOTLIN_DEPRECATED_ANNOTATION_NAME) == null) return false;
            return true;
        }

        private final boolean isScheduledForRemoval(UAnnotated annotated) {
            Companion;
            return annotated.findAnnotation(SCHEDULED_FOR_REMOVAL_ANNOTATION_NAME) != null;
        }

        public MissingDeprecatedAnnotationOnSFRVisitor(@NotNull ProblemsHolder problemsHolder) {
            this.problemsHolder = problemsHolder;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/codeInspection/MissingDeprecatedAnnotationOnScheduledForRemovalApiInspection$Companion;", "", "()V", "DEPRECATED_ANNOTATION_NAME", "", "kotlin.jvm.PlatformType", "KOTLIN_DEPRECATED_ANNOTATION_NAME", "SCHEDULED_FOR_REMOVAL_ANNOTATION_NAME", "intellij.jvm.analysis.impl"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

