/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.siyeh.ig.controlflow.UnnecessaryReturnInspection;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StatementExtractor;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakeVoidQuickFix
implements LocalQuickFix {
    private final ProblemDescriptionsProcessor myProcessor;
    private static final Logger LOG = Logger.getInstance(MakeVoidQuickFix.class);

    public MakeVoidQuickFix(@Nullable ProblemDescriptionsProcessor processor2) {
        this.myProcessor = processor2;
    }

    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"inspection.unused.return.value.make.void.quickfix", (Object[])new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiMethod psiMethod = null;
        if (this.myProcessor != null) {
            RefElement refElement = (RefElement)this.myProcessor.getElement((CommonProblemDescriptor)descriptor);
            if (refElement instanceof RefMethod && refElement.isValid()) {
                RefMethod refMethod = (RefMethod)refElement;
                psiMethod = (PsiMethod)refMethod.getPsiElement();
            }
        } else {
            psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethod.class);
        }
        if (psiMethod == null) {
            return;
        }
        MakeVoidQuickFix.makeMethodHierarchyVoid(project, psiMethod);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        return currentFile;
    }

    private static void makeMethodHierarchyVoid(Project project, @NotNull PsiMethod psiMethod) {
        final SmartList methodsToModify = new SmartList((Object)psiMethod);
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> methodsToModify.addAll(OverridingMethodsSearch.search((PsiMethod)psiMethod).findAll()), JavaBundle.message((String)"psi.search.overriding.progress", (Object[])new Object[0]), true, project)) {
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite((Collection)methodsToModify)) {
            return;
        }
        ChangeSignatureProcessor csp = new ChangeSignatureProcessor(project, psiMethod, false, null, psiMethod.getName(), (PsiType)PsiType.VOID, ParameterInfoImpl.fromMethod(psiMethod)){

            protected void performRefactoring(UsageInfo @NotNull [] usages) {
                super.performRefactoring(usages);
                for (PsiMethod method : methodsToModify) {
                    MakeVoidQuickFix.replaceReturnStatements(method);
                }
            }
        };
        csp.run();
    }

    private static void replaceReturnStatements(@NotNull PsiMethod method) {
        PsiReturnStatement[] statements = PsiUtil.findReturnStatements((PsiMethod)method);
        if (statements.length > 0) {
            for (int i = statements.length - 1; i >= 0; --i) {
                PsiReturnStatement returnStatement = statements[i];
                try {
                    PsiExpression expression2 = returnStatement.getReturnValue();
                    if (expression2 == null) continue;
                    List<PsiExpression> sideEffectExpressions = SideEffectChecker.extractSideEffectExpressions(expression2);
                    PsiStatement[] sideEffectStatements = StatementExtractor.generateStatements(sideEffectExpressions, expression2);
                    if (sideEffectStatements.length > 0) {
                        PsiStatement added = BlockUtils.addBefore((PsiStatement)returnStatement, sideEffectStatements);
                        returnStatement = (PsiReturnStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)added, PsiReturnStatement.class);
                    }
                    if (returnStatement == null || returnStatement.getReturnValue() == null) continue;
                    returnStatement.getReturnValue().delete();
                    if (!UnnecessaryReturnInspection.isReturnRedundant(returnStatement, false, true, null)) continue;
                    returnStatement.delete();
                    continue;
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }
}

