/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InvalidComparatorMethodReferenceInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
                PsiElement referenceNameElement2 = expression2.getReferenceNameElement();
                if (referenceNameElement2 == null) {
                    return;
                }
                String name2 = referenceNameElement2.getText();
                if (!name2.equals("min") && !name2.equals("max")) {
                    return;
                }
                String className2 = InvalidComparatorMethodReferenceInspection.getMethodReferenceClassName(expression2);
                if (!"java.lang.Integer".equals(className2) && !"java.lang.Math".equals(className2)) {
                    return;
                }
                String functionalInterface = InvalidComparatorMethodReferenceInspection.getFunctionalInterfaceClassName(expression2);
                if (!"java.util.Comparator".equals(functionalInterface)) {
                    return;
                }
                holder.registerProblem((PsiElement)expression2, JavaAnalysisBundle.message((String)"method.reference.mapped.to.comparator", (Object[])new Object[0]), new LocalQuickFix[]{new ReplaceWithComparatorQuickFix(name2.equals("min"))});
            }
        };
    }

    @Nullable
    static String getFunctionalInterfaceClassName(PsiMethodReferenceExpression expression2) {
        PsiType functionalInterfaceType = expression2.getFunctionalInterfaceType();
        if (!(functionalInterfaceType instanceof PsiClassType)) {
            return null;
        }
        PsiClass targetType = ((PsiClassType)functionalInterfaceType).resolve();
        if (targetType == null) {
            return null;
        }
        return targetType.getQualifiedName();
    }

    @Nullable
    static String getMethodReferenceClassName(PsiMethodReferenceExpression expression2) {
        PsiExpression qualifierExpression2 = expression2.getQualifierExpression();
        if (!(qualifierExpression2 instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement refType = ((PsiReference)qualifierExpression2).resolve();
        if (!(refType instanceof PsiClass)) {
            return null;
        }
        return ((PsiClass)refType).getQualifiedName();
    }

    private static class ReplaceWithComparatorQuickFix
    implements LocalQuickFix {
        private final boolean reverse;

        ReplaceWithComparatorQuickFix(boolean reverse) {
            this.reverse = reverse;
        }

        @Nls
        @NotNull
        public String getName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.reverse ? "Comparator.reverseOrder()" : "Comparator.naturalOrder()"});
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return JavaAnalysisBundle.message((String)"replace.with.comparator", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (parent != null) {
                PsiExpression newMethodExpression = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText("java.util.Comparator." + (this.reverse ? "reverseOrder()" : "naturalOrder()"), parent);
                element.replace((PsiElement)newMethodExpression);
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(parent);
            }
        }
    }
}

